/*
 * Decompiled with CFR 0.152.
 */
package com.shynieke.statues.client.screen.widget;

import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.Tooltip;
import net.minecraft.network.chat.Component;
import org.jetbrains.annotations.Nullable;

public class EnumCycleButton<T extends Enum<T>>
extends Button {
    private final String translationPrefix;
    private T value;
    private T[] options;

    public EnumCycleButton(int x, int y, int width, int height, String translationPrefix, T defaultValue, T[] options, Button.OnPress onPress, Button.CreateNarration createNarration) {
        super(x, y, width, height, (Component)Component.translatable((String)("statues." + translationPrefix + "." + String.valueOf(defaultValue))), onPress, createNarration);
        this.value = defaultValue;
        this.options = options;
        this.translationPrefix = translationPrefix;
    }

    public T getValue() {
        return this.value;
    }

    public T findValue(String name) {
        for (T option : this.options) {
            if (!((Enum)option).name().equals(name)) continue;
            return option;
        }
        return this.options[0];
    }

    public void setValue(T value) {
        this.value = value;
        this.setMessage((Component)Component.translatable((String)("statues." + this.translationPrefix + "." + String.valueOf(value))));
    }

    private T nextOption(T value) {
        for (T option : this.options) {
            if (((Enum)option).ordinal() != ((Enum)value).ordinal() + 1) continue;
            return option;
        }
        return this.options[0];
    }

    public void cycleValue() {
        this.setValue(this.nextOption(this.value));
    }

    static /* synthetic */ Button.CreateNarration access$000() {
        return DEFAULT_NARRATION;
    }

    public static class Builder<T extends Enum<T>> {
        private final T defaultValue;
        private final String translationPrefix;
        private final T[] options;
        private final Button.OnPress onPress;
        @Nullable
        private Tooltip tooltip;
        private int x;
        private int y;
        private int width = 150;
        private int height = 20;
        private Button.CreateNarration createNarration = EnumCycleButton.access$000();

        public Builder(String defaultValue, String translationPrefix, T[] options, Button.OnPress onPress) {
            this.translationPrefix = translationPrefix;
            this.onPress = onPress;
            this.options = options;
            this.defaultValue = this.findValue(defaultValue);
        }

        public T findValue(String name) {
            for (T option : this.options) {
                if (!((Enum)option).name().equals(name)) continue;
                return option;
            }
            return this.options[0];
        }

        public Builder pos(int x, int y) {
            this.x = x;
            this.y = y;
            return this;
        }

        public Builder width(int width) {
            this.width = width;
            return this;
        }

        public Builder size(int width, int height) {
            this.width = width;
            this.height = height;
            return this;
        }

        public Builder bounds(int p_254166_, int p_253872_, int p_254522_, int p_253985_) {
            return this.pos(p_254166_, p_253872_).size(p_254522_, p_253985_);
        }

        public Builder tooltip(@Nullable Tooltip tooltip) {
            this.tooltip = tooltip;
            return this;
        }

        public Builder createNarration(Button.CreateNarration createNarration) {
            this.createNarration = createNarration;
            return this;
        }

        public EnumCycleButton build() {
            EnumCycleButton button = new EnumCycleButton(this.x, this.y, this.width, this.height, this.translationPrefix, this.defaultValue, this.options, this.onPress, this.createNarration);
            button.setTooltip(this.tooltip);
            return button;
        }
    }
}

