/*
 * Decompiled with CFR 0.152.
 */
package com.shynieke.statues.compat.jade;

import com.shynieke.statues.blockentities.AbstractStatueBlockEntity;
import com.shynieke.statues.blocks.AbstractStatueBase;
import java.util.Map;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.block.entity.BlockEntity;
import snownee.jade.api.BlockAccessor;
import snownee.jade.api.IBlockComponentProvider;
import snownee.jade.api.IComponentProvider;
import snownee.jade.api.ITooltip;
import snownee.jade.api.IWailaClientRegistration;
import snownee.jade.api.IWailaCommonRegistration;
import snownee.jade.api.IWailaPlugin;
import snownee.jade.api.WailaPlugin;
import snownee.jade.api.config.IPluginConfig;

@WailaPlugin
public class JadeCompat
implements IWailaPlugin {
    public void register(IWailaCommonRegistration registration) {
    }

    public void registerClient(IWailaClientRegistration registration) {
        registration.registerBlockComponent((IComponentProvider)PastryBodyHandler.INSTANCE, AbstractStatueBase.class);
    }

    public static class PastryBodyHandler
    implements IBlockComponentProvider {
        private static final ResourceLocation BITES = ResourceLocation.fromNamespaceAndPath((String)"statues", (String)"upgrades");
        public static final PastryBodyHandler INSTANCE = new PastryBodyHandler();

        public void appendTooltip(ITooltip iTooltip, BlockAccessor blockAccessor, IPluginConfig iPluginConfig) {
            BlockEntity blockEntity = blockAccessor.getBlockEntity();
            if (blockEntity instanceof AbstractStatueBlockEntity) {
                AbstractStatueBlockEntity statueBlockEntity = (AbstractStatueBlockEntity)blockEntity;
                iTooltip.add((Component)Component.translatable((String)"statues.info.level").withStyle(ChatFormatting.GOLD).append(" ").append((Component)Component.literal((String)String.valueOf(statueBlockEntity.getStatueLevel())).withStyle(ChatFormatting.YELLOW)));
                iTooltip.add((Component)Component.translatable((String)"statues.info.kills").withStyle(ChatFormatting.GOLD).append(" ").append((Component)Component.literal((String)String.valueOf(statueBlockEntity.getKillCount())).withStyle(ChatFormatting.YELLOW)));
                iTooltip.add((Component)Component.translatable((String)"statues.info.upgrade_slots").withStyle(ChatFormatting.GOLD).append(" ").append((Component)Component.literal((String)String.valueOf(statueBlockEntity.getUpgradeSlots())).withStyle(ChatFormatting.YELLOW)));
                for (Map.Entry entry : statueBlockEntity.getUpgrades().entrySet()) {
                    iTooltip.add((Component)this.getUpgradeName((String)entry.getKey(), ((Short)entry.getValue()).shortValue()));
                }
            }
        }

        private MutableComponent getUpgradeName(String id, int level) {
            String descriptionID = "statues.upgrade." + id + ".name";
            MutableComponent mutablecomponent = Component.translatable((String)descriptionID).withStyle(ChatFormatting.GRAY);
            if (level > 0) {
                mutablecomponent.append(" ").append((Component)Component.translatable((String)("enchantment.level." + level)));
            }
            return mutablecomponent;
        }

        public ResourceLocation getUid() {
            return BITES;
        }
    }
}

