/*
 * Decompiled with CFR 0.152.
 */
package com.shynieke.statues.compat.jei.category;

import com.shynieke.statues.compat.jei.JEIPlugin;
import com.shynieke.statues.datacomponent.StatueStats;
import com.shynieke.statues.recipe.UpgradeRecipe;
import com.shynieke.statues.recipe.UpgradeType;
import com.shynieke.statues.registry.StatueDataComponents;
import com.shynieke.statues.registry.StatueRegistry;
import com.shynieke.statues.registry.StatueTags;
import java.util.ArrayList;
import mezz.jei.api.constants.VanillaTypes;
import mezz.jei.api.gui.builder.IRecipeLayoutBuilder;
import mezz.jei.api.gui.builder.IRecipeSlotBuilder;
import mezz.jei.api.gui.builder.ITooltipBuilder;
import mezz.jei.api.gui.drawable.IDrawable;
import mezz.jei.api.gui.ingredient.IRecipeSlotRichTooltipCallback;
import mezz.jei.api.gui.ingredient.IRecipeSlotView;
import mezz.jei.api.gui.ingredient.IRecipeSlotsView;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.ingredients.IIngredientType;
import mezz.jei.api.recipe.IFocus;
import mezz.jei.api.recipe.IFocusGroup;
import mezz.jei.api.recipe.RecipeIngredientRole;
import mezz.jei.api.recipe.RecipeType;
import mezz.jei.api.recipe.category.IRecipeCategory;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.core.HolderLookup;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;

public class UpgradeCategory
implements IRecipeCategory<UpgradeRecipe> {
    private final IDrawable background;
    private final IDrawable icon;
    private final Component localizedName;

    public UpgradeCategory(IGuiHelper guiHelper) {
        this.background = guiHelper.createDrawable(JEIPlugin.UPGRADE_BACKGROUND, 0, 0, 148, 62);
        this.icon = guiHelper.createDrawableIngredient((IIngredientType)VanillaTypes.ITEM_STACK, (Object)new ItemStack((ItemLike)StatueRegistry.STATUE_TABLE.get()));
        this.localizedName = Component.translatable((String)"statues.gui.jei.category.upgrade");
    }

    public RecipeType<UpgradeRecipe> getRecipeType() {
        return JEIPlugin.UPGRADE_TYPE;
    }

    public IDrawable getBackground() {
        return this.background;
    }

    public IDrawable getIcon() {
        return this.icon;
    }

    /*
     * Unable to fully structure code
     */
    public void setRecipe(IRecipeLayoutBuilder builder, UpgradeRecipe recipe, IFocusGroup focuses) {
        callback = new UpgradeTooltipCallback(recipe);
        minecraft = Minecraft.getInstance();
        level = minecraft.level;
        if (level == null) {
            throw new NullPointerException("level must not be null.");
        }
        registryAccess = level.registryAccess();
        focused = focuses.getAllFocuses().stream().findFirst();
        tier = recipe.getTier();
        if (!focused.isPresent() || !((var11_10 = ((IFocus)focused.get()).getTypedValue().getIngredient()) instanceof ItemStack)) ** GOTO lbl-1000
        focusStack = (ItemStack)var11_10;
        if (recipe.getCenter().test(focusStack)) {
            centerStack = focusStack.copy();
            this.fillInTag(centerStack, recipe);
            if (recipe.getUpgradeType() == UpgradeType.UNGLOWING) {
                UpgradeType.GLOWING.apply(centerStack, -1);
            }
            if (tier > -1) {
                for (i = 0; i < tier; ++i) {
                    recipe.getUpgradeType().apply(centerStack, i);
                }
            }
            if (recipe.getUpgradeType() == UpgradeType.UPGRADE) {
                this.setUpgradeSlots(centerStack, 0);
            } else {
                this.setUpgradeSlots(centerStack, 1);
            }
            builder.addSlot(RecipeIngredientRole.INPUT, 73, 23).addItemStack(centerStack);
            if (recipe.getResultItem((HolderLookup.Provider)registryAccess).isEmpty()) {
                outputStack = centerStack.copy();
                recipe.getUpgradeType().apply(outputStack, tier);
                if (recipe.getUpgradeType() == UpgradeType.UPGRADE) {
                    this.setUpgradeSlots(outputStack, 0);
                } else {
                    this.setUpgradeSlots(outputStack, 1);
                }
                ((IRecipeSlotBuilder)builder.addSlot(RecipeIngredientRole.OUTPUT, 127, 23).addItemStack(outputStack)).addRichTooltipCallback((IRecipeSlotRichTooltipCallback)callback);
            } else {
                ((IRecipeSlotBuilder)builder.addSlot(RecipeIngredientRole.OUTPUT, 127, 23).addItemStack(recipe.getResultItem((HolderLookup.Provider)registryAccess))).addRichTooltipCallback((IRecipeSlotRichTooltipCallback)callback);
            }
        } else lbl-1000:
        // 2 sources

        {
            centerList = new ArrayList<ItemStack>();
            for (ItemStack centerStack : recipe.getCenter().getItems()) {
                stack = centerStack.copy();
                this.fillInTag(stack, recipe);
                if (recipe.getUpgradeType() == UpgradeType.UNGLOWING) {
                    UpgradeType.GLOWING.apply(stack, -1);
                }
                if (tier > -1) {
                    for (i = 0; i < tier; ++i) {
                        recipe.getUpgradeType().apply(stack, i);
                    }
                }
                if (recipe.getUpgradeType() == UpgradeType.UPGRADE) {
                    this.setUpgradeSlots(stack, 0);
                } else {
                    this.setUpgradeSlots(stack, 1);
                }
                centerList.add(stack);
            }
            builder.addSlot(RecipeIngredientRole.INPUT, 73, 23).addItemStacks(centerList);
            if (recipe.getResultItem((HolderLookup.Provider)registryAccess).isEmpty()) {
                stackList = new ArrayList<ItemStack>();
                for (ItemStack centerStack : centerList) {
                    stack = centerStack.copy();
                    recipe.getUpgradeType().apply(stack, tier);
                    if (recipe.getUpgradeType() == UpgradeType.UPGRADE) {
                        this.setUpgradeSlots(stack, 1);
                    } else {
                        this.setUpgradeSlots(stack, 0);
                    }
                    stackList.add(stack);
                }
                ((IRecipeSlotBuilder)builder.addSlot(RecipeIngredientRole.OUTPUT, 127, 23).addItemStacks(stackList)).addRichTooltipCallback((IRecipeSlotRichTooltipCallback)callback);
            } else {
                ((IRecipeSlotBuilder)builder.addSlot(RecipeIngredientRole.OUTPUT, 127, 23).addItemStack(recipe.getResultItem((HolderLookup.Provider)registryAccess))).addRichTooltipCallback((IRecipeSlotRichTooltipCallback)callback);
            }
        }
        builder.addSlot(RecipeIngredientRole.CATALYST, 1, 41).addIngredients(recipe.requiresCore() != false ? Ingredient.of(StatueTags.STATUE_CORE) : Ingredient.EMPTY);
        catalysts = recipe.getCatalysts();
        if (catalysts.size() > 0) {
            builder.addSlot(RecipeIngredientRole.CATALYST, 55, 5).addIngredients((Ingredient)catalysts.get(0));
            if (catalysts.size() > 1) {
                builder.addSlot(RecipeIngredientRole.CATALYST, 91, 5).addIngredients((Ingredient)catalysts.get(1));
                if (catalysts.size() > 2) {
                    builder.addSlot(RecipeIngredientRole.CATALYST, 55, 41).addIngredients((Ingredient)catalysts.get(2));
                    if (catalysts.size() > 3) {
                        builder.addSlot(RecipeIngredientRole.CATALYST, 91, 41).addIngredients((Ingredient)catalysts.get(3));
                    }
                }
            }
        }
    }

    private void fillInTag(ItemStack stack, UpgradeRecipe recipe) {
        int tier = recipe.getTier();
        int actualTier = tier == -1 ? (recipe.getUpgradeType() == UpgradeType.UPGRADE ? 0 : 1) : tier + 1;
        StatueStats stats = new StatueStats(actualTier, actualTier * 10, 20);
        stack.set(StatueDataComponents.STATS, (Object)stats);
        stack.set(StatueDataComponents.UPGRADED, (Object)true);
    }

    private void setUpgradeSlots(ItemStack stack, int count) {
        StatueStats stats = (StatueStats)stack.getOrDefault(StatueDataComponents.STATS, (Object)StatueStats.empty());
        stack.set(StatueDataComponents.STATS, (Object)new StatueStats(stats.level(), count, stats.killCount()));
    }

    public void draw(UpgradeRecipe recipe, IRecipeSlotsView recipeSlotsView, GuiGraphics guiGraphics, double mouseX, double mouseY) {
        super.draw((Object)recipe, recipeSlotsView, guiGraphics, mouseX, mouseY);
    }

    public Component getTitle() {
        return this.localizedName;
    }

    public static class UpgradeTooltipCallback
    implements IRecipeSlotRichTooltipCallback {
        public final MutableComponent component;

        public UpgradeTooltipCallback(UpgradeRecipe recipe) {
            this.component = recipe.getUpgradeName();
        }

        public void onRichTooltip(IRecipeSlotView recipeSlotView, ITooltipBuilder tooltip) {
            tooltip.add((FormattedText)this.component);
        }
    }
}

