/*
 * Decompiled with CFR 0.152.
 */
package com.shynieke.statues.datagen;

import com.shynieke.statues.datagen.client.StatueBlockstateProvider;
import com.shynieke.statues.datagen.client.StatueItemModelProvider;
import com.shynieke.statues.datagen.client.StatueLanguageProvider;
import com.shynieke.statues.datagen.client.StatueSoundProvider;
import com.shynieke.statues.datagen.server.StatueAdvancementProvider;
import com.shynieke.statues.datagen.server.StatueBiomeModifiers;
import com.shynieke.statues.datagen.server.StatueBiomeTagProvider;
import com.shynieke.statues.datagen.server.StatueBlockTagProvider;
import com.shynieke.statues.datagen.server.StatueGLMProvider;
import com.shynieke.statues.datagen.server.StatueItemTagProvider;
import com.shynieke.statues.datagen.server.StatueLootProvider;
import com.shynieke.statues.datagen.server.StatueRecipeProvider;
import com.shynieke.statues.datagen.server.patchouli.StatuePatchouliProvider;
import com.shynieke.statues.registry.StatueJukeboxSongs;
import com.shynieke.statues.registry.StatueTrims;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import net.minecraft.core.Cloner;
import net.minecraft.core.Registry;
import net.minecraft.core.RegistryAccess;
import net.minecraft.core.RegistrySetBuilder;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.data.DataGenerator;
import net.minecraft.data.DataProvider;
import net.minecraft.data.PackOutput;
import net.minecraft.data.registries.VanillaRegistries;
import net.minecraft.data.tags.TagsProvider;
import net.minecraft.world.level.block.Block;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.common.data.DatapackBuiltinEntriesProvider;
import net.neoforged.neoforge.common.data.ExistingFileHelper;
import net.neoforged.neoforge.data.event.GatherDataEvent;
import net.neoforged.neoforge.registries.DataPackRegistriesHooks;
import net.neoforged.neoforge.registries.NeoForgeRegistries;

@EventBusSubscriber(bus=EventBusSubscriber.Bus.MOD)
public class StatuesDataGenerator {
    @SubscribeEvent
    public static void gatherData(GatherDataEvent event) {
        DataGenerator generator = event.getGenerator();
        PackOutput packOutput = generator.getPackOutput();
        CompletableFuture lookupProvider = event.getLookupProvider();
        ExistingFileHelper helper = event.getExistingFileHelper();
        if (event.includeServer()) {
            generator.addProvider(event.includeServer(), (DataProvider)new StatueLootProvider(packOutput, lookupProvider));
            generator.addProvider(event.includeServer(), (DataProvider)new StatueRecipeProvider(packOutput, lookupProvider));
            StatueBlockTagProvider blockTags = new StatueBlockTagProvider(packOutput, lookupProvider, helper);
            generator.addProvider(event.includeServer(), (DataProvider)blockTags);
            generator.addProvider(event.includeServer(), (DataProvider)new StatueItemTagProvider(packOutput, lookupProvider, (TagsProvider<Block>)blockTags, helper));
            generator.addProvider(event.includeServer(), (DataProvider)new StatueBiomeTagProvider(packOutput, lookupProvider, helper));
            generator.addProvider(event.includeServer(), (DataProvider)new StatueGLMProvider(packOutput, lookupProvider));
            generator.addProvider(event.includeServer(), (DataProvider)new StatuePatchouliProvider(packOutput, lookupProvider));
            generator.addProvider(event.includeServer(), (DataProvider)new StatueAdvancementProvider(packOutput, lookupProvider, helper));
            generator.addProvider(event.includeServer(), (DataProvider)new DatapackBuiltinEntriesProvider(packOutput, CompletableFuture.supplyAsync(StatuesDataGenerator::getProvider), Set.of("statues")));
        }
        if (event.includeClient()) {
            generator.addProvider(event.includeClient(), (DataProvider)new StatueLanguageProvider(packOutput));
            generator.addProvider(event.includeClient(), (DataProvider)new StatueSoundProvider(packOutput, helper));
            generator.addProvider(event.includeClient(), (DataProvider)new StatueBlockstateProvider(packOutput, helper));
            generator.addProvider(event.includeClient(), (DataProvider)new StatueItemModelProvider(packOutput, helper));
        }
    }

    private static RegistrySetBuilder.PatchedRegistries getProvider() {
        RegistrySetBuilder registryBuilder = new RegistrySetBuilder();
        registryBuilder.add(Registries.CONFIGURED_FEATURE, $ -> {});
        registryBuilder.add(Registries.PLACED_FEATURE, $ -> {});
        registryBuilder.add(Registries.TRIM_PATTERN, StatueTrims::bootstrap);
        registryBuilder.add(Registries.JUKEBOX_SONG, StatueJukeboxSongs::bootstrap);
        registryBuilder.add(NeoForgeRegistries.Keys.BIOME_MODIFIERS, StatueBiomeModifiers::bootstrap);
        registryBuilder.add(Registries.BIOME, $ -> {});
        RegistryAccess.Frozen regAccess = RegistryAccess.fromRegistryOfRegistries((Registry)BuiltInRegistries.REGISTRY);
        Cloner.Factory cloner$factory = new Cloner.Factory();
        DataPackRegistriesHooks.getDataPackRegistriesWithDimensions().forEach(data -> data.runWithArguments((arg_0, arg_1) -> ((Cloner.Factory)cloner$factory).addCodec(arg_0, arg_1)));
        return registryBuilder.buildPatch((RegistryAccess)regAccess, VanillaRegistries.createLookup(), cloner$factory);
    }
}

