/*
 * Decompiled with CFR 0.152.
 */
package com.shynieke.statues.datagen.client;

import com.shynieke.statues.blocks.AbstractBaseBlock;
import com.shynieke.statues.blocks.CoreFlowerCropBlock;
import com.shynieke.statues.registry.StatueRegistry;
import net.minecraft.core.Direction;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.data.PackOutput;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.CropBlock;
import net.minecraft.world.level.block.FlowerBlock;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.neoforged.neoforge.client.model.generators.BlockModelBuilder;
import net.neoforged.neoforge.client.model.generators.BlockStateProvider;
import net.neoforged.neoforge.client.model.generators.ModelBuilder;
import net.neoforged.neoforge.client.model.generators.ModelFile;
import net.neoforged.neoforge.client.model.generators.VariantBlockStateBuilder;
import net.neoforged.neoforge.common.data.ExistingFileHelper;
import net.neoforged.neoforge.registries.DeferredHolder;

public class StatueBlockstateProvider
extends BlockStateProvider {
    public StatueBlockstateProvider(PackOutput packOutput, ExistingFileHelper helper) {
        super(packOutput, "statues", helper);
    }

    protected void registerStatesAndModels() {
        for (DeferredHolder registryObject : StatueRegistry.BLOCKS.getEntries()) {
            if (registryObject.get() instanceof AbstractBaseBlock) {
                this.makeStatue((DeferredHolder<Block, ? extends Block>)registryObject);
                continue;
            }
            if (registryObject.get() instanceof CoreFlowerCropBlock) {
                this.buildCrop((CoreFlowerCropBlock)((Object)registryObject.get()), CoreFlowerCropBlock.AGE);
                continue;
            }
            if (registryObject.get() instanceof FlowerBlock) {
                this.crossBlock((DeferredHolder<Block, ? extends Block>)registryObject);
                continue;
            }
            ModelFile.ExistingModelFile blockModel = this.models().getExistingFile(this.modLoc("block/" + registryObject.getId().getPath()));
            this.getVariantBuilder((Block)registryObject.get()).partialState().modelForState().modelFile((ModelFile)blockModel).addModel();
        }
    }

    protected void buildCrop(CropBlock block, IntegerProperty property) {
        VariantBlockStateBuilder builder = this.getVariantBuilder((Block)block);
        for (int i = 0; i <= block.getMaxAge(); ++i) {
            ModelBuilder file = ((BlockModelBuilder)this.models().crop(BuiltInRegistries.BLOCK.getKey((Object)block).getPath() + "_" + i, ResourceLocation.fromNamespaceAndPath((String)"statues", (String)("block/" + BuiltInRegistries.BLOCK.getKey((Object)block).getPath() + "_stage" + i)))).renderType(ResourceLocation.withDefaultNamespace((String)"cutout"));
            builder.partialState().with((Property)property, (Comparable)Integer.valueOf(i)).modelForState().modelFile((ModelFile)file).addModel();
        }
    }

    private void crossBlock(DeferredHolder<Block, ? extends Block> block) {
        this.simpleBlock((Block)block.get(), (ModelFile)((BlockModelBuilder)this.models().cross(block.getId().getPath(), this.blockTexture((Block)block.get()))).renderType(ResourceLocation.withDefaultNamespace((String)"cutout")));
    }

    private void makeStatue(DeferredHolder<Block, ? extends Block> registryObject) {
        ModelFile.ExistingModelFile model = this.models().getExistingFile(this.modLoc("block/" + registryObject.getId().getPath()));
        ((VariantBlockStateBuilder)((VariantBlockStateBuilder)((VariantBlockStateBuilder)this.getVariantBuilder((Block)registryObject.get()).partialState().with((Property)BlockStateProperties.HORIZONTAL_FACING, (Comparable)Direction.NORTH).modelForState().modelFile((ModelFile)model).addModel()).partialState().with((Property)BlockStateProperties.HORIZONTAL_FACING, (Comparable)Direction.EAST).modelForState().modelFile((ModelFile)model).rotationY(90).addModel()).partialState().with((Property)BlockStateProperties.HORIZONTAL_FACING, (Comparable)Direction.SOUTH).modelForState().modelFile((ModelFile)model).rotationY(180).addModel()).partialState().with((Property)BlockStateProperties.HORIZONTAL_FACING, (Comparable)Direction.WEST).modelForState().modelFile((ModelFile)model).rotationY(270).addModel();
    }
}

