/*
 * Decompiled with CFR 0.152.
 */
package com.shynieke.statues.entity;

import com.shynieke.statues.config.StatuesConfig;
import java.time.LocalDate;
import net.minecraft.core.BlockPos;
import net.minecraft.tags.DamageTypeTags;
import net.minecraft.util.RandomSource;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ambient.Bat;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.ServerLevelAccessor;
import org.jetbrains.annotations.Nullable;

public class StatueBatEntity
extends Bat {
    public StatueBatEntity(EntityType<? extends StatueBatEntity> type, Level level) {
        super(type, level);
    }

    public static AttributeSupplier.Builder createAttributes() {
        return Bat.createMobAttributes().add(Attributes.MAX_HEALTH, 12.0);
    }

    @Nullable
    public SpawnGroupData finalizeSpawn(ServerLevelAccessor level, DifficultyInstance difficultyIn, MobSpawnType reason, @Nullable SpawnGroupData spawnDataIn) {
        SpawnGroupData data = super.finalizeSpawn(level, difficultyIn, reason, spawnDataIn);
        int random = this.getRandom().nextInt(10);
        if (random < 5) {
            this.addEffect(new MobEffectInstance(MobEffects.MOVEMENT_SPEED, 40000, 2, true, false));
        }
        return data;
    }

    public boolean hurt(DamageSource source, float amount) {
        Entity entity;
        if (!source.is(DamageTypeTags.AVOIDS_GUARDIAN_THORNS) && (entity = source.getDirectEntity()) instanceof LivingEntity) {
            LivingEntity livingEntity = (LivingEntity)entity;
            livingEntity.hurt(this.damageSources().thorns((Entity)this), 2.0f);
        }
        return super.hurt(source, amount);
    }

    public static boolean canSpawnHere(EntityType<StatueBatEntity> batIn, LevelAccessor levelAccessor, MobSpawnType reason, BlockPos pos, RandomSource randomIn) {
        if (!((Boolean)StatuesConfig.COMMON.statueBatSpawning.get()).booleanValue()) {
            return false;
        }
        if (pos.getY() >= levelAccessor.getSeaLevel()) {
            return false;
        }
        int i = levelAccessor.getMaxLocalRawBrightness(pos);
        int j = 4;
        if (StatueBatEntity.isNearHalloween()) {
            j = 7;
        } else if (randomIn.nextBoolean()) {
            return false;
        }
        return i > randomIn.nextInt(j) ? false : StatueBatEntity.checkMobSpawnRules(batIn, (LevelAccessor)levelAccessor, (MobSpawnType)reason, (BlockPos)pos, (RandomSource)randomIn);
    }

    private static boolean isNearHalloween() {
        LocalDate localdate = LocalDate.now();
        int i = localdate.getDayOfMonth();
        int j = localdate.getMonthValue();
        return j == 10 && i >= 20 || j == 11 && i <= 3;
    }
}

