/*
 * Decompiled with CFR 0.152.
 */
package com.shynieke.statues.handlers;

import com.shynieke.statues.blocks.AbstractStatueBase;
import com.shynieke.statues.blocks.statues.SheepStatueBlock;
import com.shynieke.statues.config.StatuesConfig;
import com.shynieke.statues.registry.StatueRegistry;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.component.DataComponents;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.animal.Bee;
import net.minecraft.world.entity.animal.Cat;
import net.minecraft.world.entity.animal.CatVariant;
import net.minecraft.world.entity.animal.Fox;
import net.minecraft.world.entity.animal.FrogVariant;
import net.minecraft.world.entity.animal.MushroomCow;
import net.minecraft.world.entity.animal.Panda;
import net.minecraft.world.entity.animal.Rabbit;
import net.minecraft.world.entity.animal.Sheep;
import net.minecraft.world.entity.animal.axolotl.Axolotl;
import net.minecraft.world.entity.animal.frog.Frog;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.monster.ElderGuardian;
import net.minecraft.world.entity.monster.Evoker;
import net.minecraft.world.entity.monster.Ravager;
import net.minecraft.world.entity.monster.Vindicator;
import net.minecraft.world.entity.monster.warden.Warden;
import net.minecraft.world.entity.npc.Villager;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.neoforge.common.util.FakePlayer;
import net.neoforged.neoforge.event.entity.living.LivingDropsEvent;
import net.neoforged.neoforge.registries.DeferredHolder;

public class DropHandler {
    @SubscribeEvent
    public void onLivingDrop(LivingDropsEvent event) {
        LivingEntity entity = event.getEntity();
        Entity source = event.getSource().getEntity();
        Level level = entity.level();
        RandomSource rand = level.random;
        if (entity instanceof Villager) {
            switch (rand.nextInt(4)) {
                case 1: {
                    this.dropLootStatues((Entity)entity, new ItemStack((ItemLike)StatueRegistry.VILLAGER_WH_STATUE.get()), source, event);
                    break;
                }
                case 2: {
                    this.dropLootStatues((Entity)entity, new ItemStack((ItemLike)StatueRegistry.VILLAGER_PU_STATUE.get()), source, event);
                    break;
                }
                case 3: {
                    this.dropLootStatues((Entity)entity, new ItemStack((ItemLike)StatueRegistry.VILLAGER_GR_STATUE.get()), source, event);
                    break;
                }
                default: {
                    this.dropLootStatues((Entity)entity, new ItemStack((ItemLike)StatueRegistry.VILLAGER_BR_STATUE.get()), source, event);
                    break;
                }
            }
        } else if (entity instanceof Evoker) {
            itemStackToDrop = new ItemStack((ItemLike)StatueRegistry.EVOKER_STATUE.get());
            this.dropLootStatues((Entity)entity, itemStackToDrop, source, event);
        } else if (entity instanceof Vindicator) {
            itemStackToDrop = new ItemStack((ItemLike)StatueRegistry.VINDICATOR_STATUE.get());
            this.dropLootStatues((Entity)entity, itemStackToDrop, source, event);
        } else if (entity instanceof Sheep) {
            Sheep sheep = (Sheep)entity;
            itemStackToDrop = new ItemStack((ItemLike)StatueRegistry.SHEEP_SHAVEN_STATUE.get());
            if (!sheep.isSheared()) {
                itemStackToDrop = new ItemStack((ItemLike)SheepStatueBlock.getStatue(sheep.getColor()));
            }
            this.dropLootStatues((Entity)entity, itemStackToDrop, source, event);
        } else if (entity instanceof Bee) {
            Bee bee = (Bee)entity;
            itemStackToDrop = new ItemStack((ItemLike)StatueRegistry.BEE_STATUE.get());
            if (rand.nextBoolean()) {
                itemStackToDrop = new ItemStack((ItemLike)StatueRegistry.ANGRY_BEE_STATUE.get());
            }
            String trans = "Trans Bee";
            if (bee.getDisplayName().getString().equalsIgnoreCase(trans)) {
                itemStackToDrop = new ItemStack((ItemLike)StatueRegistry.BEE_STATUE.get());
                itemStackToDrop.set(DataComponents.CUSTOM_NAME, (Object)Component.literal((String)trans));
            }
            String tropi = "Tropibee";
            if (bee.getDisplayName().getString().equalsIgnoreCase(tropi)) {
                itemStackToDrop = new ItemStack((ItemLike)StatueRegistry.TROPIBEE.get());
                itemStackToDrop.set(DataComponents.CUSTOM_NAME, (Object)Component.literal((String)tropi));
            }
            this.dropLootStatues((Entity)entity, itemStackToDrop, source, event);
        } else if (entity instanceof Rabbit) {
            Rabbit rabbit = (Rabbit)entity;
            new ItemStack((ItemLike)StatueRegistry.RABBIT_BR_STATUE.get());
            itemStackToDrop = switch (rabbit.getVariant()) {
                case Rabbit.Variant.WHITE -> new ItemStack((ItemLike)StatueRegistry.RABBIT_WH_STATUE.get());
                case Rabbit.Variant.WHITE_SPLOTCHED -> new ItemStack((ItemLike)StatueRegistry.RABBIT_WS_STATUE.get());
                case Rabbit.Variant.BLACK -> new ItemStack((ItemLike)StatueRegistry.RABBIT_BS_STATUE.get());
                case Rabbit.Variant.GOLD -> new ItemStack((ItemLike)StatueRegistry.RABBIT_GO_STATUE.get());
                case Rabbit.Variant.BROWN -> new ItemStack((ItemLike)StatueRegistry.RABBIT_BW_STATUE.get());
                default -> new ItemStack((ItemLike)StatueRegistry.RABBIT_BR_STATUE.get());
            };
            this.dropLootStatues((Entity)entity, itemStackToDrop, source, event);
        } else if (entity instanceof Panda) {
            Panda panda = (Panda)entity;
            new ItemStack((ItemLike)StatueRegistry.PANDA_NORMAL_STATUE.get());
            itemStackToDrop = switch (panda.getMainGene()) {
                case Panda.Gene.AGGRESSIVE -> new ItemStack((ItemLike)StatueRegistry.PANDA_ANGRY_STATUE.get());
                case Panda.Gene.BROWN -> new ItemStack((ItemLike)StatueRegistry.PANDA_BROWN_STATUE.get());
                case Panda.Gene.LAZY -> new ItemStack((ItemLike)StatueRegistry.PANDA_LAZY_STATUE.get());
                case Panda.Gene.PLAYFUL -> new ItemStack((ItemLike)StatueRegistry.PANDA_PLAYFUL_STATUE.get());
                case Panda.Gene.WEAK -> new ItemStack((ItemLike)StatueRegistry.PANDA_WEAK_STATUE.get());
                case Panda.Gene.WORRIED -> new ItemStack((ItemLike)StatueRegistry.PANDA_WORRIED_STATUE.get());
                default -> new ItemStack((ItemLike)StatueRegistry.PANDA_NORMAL_STATUE.get());
            };
            this.dropLootStatues((Entity)entity, itemStackToDrop, source, event);
        } else if (entity instanceof Cat) {
            Cat cat = (Cat)entity;
            itemStackToDrop = ItemStack.EMPTY;
            CatVariant variant = (CatVariant)cat.getVariant().value();
            ResourceKey catKey = BuiltInRegistries.CAT_VARIANT.getResourceKey((Object)variant).orElse(null);
            itemStackToDrop = catKey == CatVariant.TABBY ? new ItemStack((ItemLike)StatueRegistry.CAT_TABBY_STATUE.get()) : (catKey == CatVariant.BLACK ? new ItemStack((ItemLike)StatueRegistry.CAT_TUXEDO_STATUE.get()) : (catKey == CatVariant.RED ? new ItemStack((ItemLike)StatueRegistry.CAT_RED_STATUE.get()) : (catKey == CatVariant.SIAMESE ? new ItemStack((ItemLike)StatueRegistry.CAT_SIAMESE_STATUE.get()) : (catKey == CatVariant.BRITISH_SHORTHAIR ? new ItemStack((ItemLike)StatueRegistry.CAT_BRITISH_SHORTHAIR_STATUE.get()) : (catKey == CatVariant.CALICO ? new ItemStack((ItemLike)StatueRegistry.CAT_CALICO_STATUE.get()) : (catKey == CatVariant.PERSIAN ? new ItemStack((ItemLike)StatueRegistry.CAT_PERSIAN_STATUE.get()) : (catKey == CatVariant.RAGDOLL ? new ItemStack((ItemLike)StatueRegistry.CAT_RAGDOLL_STATUE.get()) : (catKey == CatVariant.WHITE ? new ItemStack((ItemLike)StatueRegistry.CAT_WHITE_STATUE.get()) : (catKey == CatVariant.JELLIE ? new ItemStack((ItemLike)StatueRegistry.CAT_JELLIE_STATUE.get()) : (catKey == CatVariant.ALL_BLACK ? new ItemStack((ItemLike)StatueRegistry.CAT_BLACK_STATUE.get()) : new ItemStack((ItemLike)StatueRegistry.CAT_TABBY_STATUE.get())))))))))));
            this.dropLootStatues((Entity)entity, itemStackToDrop, source, event);
        } else if (entity instanceof ElderGuardian) {
            itemStackToDrop = new ItemStack((ItemLike)StatueRegistry.ELDER_GUARDIAN_STATUE.get());
            this.dropBossStatue((Entity)entity, itemStackToDrop, source, event);
        } else if (entity instanceof Ravager) {
            itemStackToDrop = new ItemStack((ItemLike)StatueRegistry.RAVAGER_STATUE.get());
            if (rand.nextFloat() <= 0.25f) {
                this.dropBossStatue((Entity)entity, itemStackToDrop, source, event);
            }
        } else if (entity instanceof MushroomCow) {
            MushroomCow mooshroom = (MushroomCow)entity;
            itemStackToDrop = new ItemStack((ItemLike)StatueRegistry.MOOSHROOM_STATUE.get());
            if (mooshroom.getVariant() == MushroomCow.MushroomType.BROWN) {
                itemStackToDrop = new ItemStack((ItemLike)StatueRegistry.BROWN_MOOSHROOM_STATUE.get());
            }
            this.dropLootStatues((Entity)entity, itemStackToDrop, source, event);
        } else if (entity instanceof Fox) {
            Fox fox = (Fox)entity;
            itemStackToDrop = new ItemStack((ItemLike)StatueRegistry.FOX_STATUE.get());
            if (fox.getVariant() == Fox.Type.SNOW) {
                itemStackToDrop = new ItemStack((ItemLike)StatueRegistry.FOX_SNOW_STATUE.get());
            }
            this.dropLootStatues((Entity)entity, itemStackToDrop, source, event);
        } else if (entity instanceof Axolotl) {
            Axolotl axolotl = (Axolotl)entity;
            itemStackToDrop = switch (axolotl.getVariant()) {
                default -> new ItemStack((ItemLike)StatueRegistry.AXOLOTL_LUCY_STATUE.get());
                case Axolotl.Variant.WILD -> new ItemStack((ItemLike)StatueRegistry.AXOLOTL_WILD_STATUE.get());
                case Axolotl.Variant.GOLD -> new ItemStack((ItemLike)StatueRegistry.AXOLOTL_GOLD_STATUE.get());
                case Axolotl.Variant.CYAN -> new ItemStack((ItemLike)StatueRegistry.AXOLOTL_CYAN_STATUE.get());
                case Axolotl.Variant.BLUE -> new ItemStack((ItemLike)StatueRegistry.AXOLOTL_BLUE_STATUE.get());
            };
            this.dropLootStatues((Entity)entity, itemStackToDrop, source, event);
        } else if (entity instanceof Frog) {
            Frog frog = (Frog)entity;
            itemStackToDrop = new ItemStack((ItemLike)StatueRegistry.FROG_TEMPERATE_STATUE.get());
            ResourceKey frogVariant = (ResourceKey)frog.getVariant().unwrapKey().orElseThrow();
            if (frogVariant.location().equals((Object)FrogVariant.WARM.location())) {
                itemStackToDrop = new ItemStack((ItemLike)StatueRegistry.FROG_WARM_STATUE.get());
            } else if (frogVariant.location().equals((Object)FrogVariant.COLD.location())) {
                itemStackToDrop = new ItemStack((ItemLike)StatueRegistry.FROG_COLD_STATUE.get());
            }
            this.dropLootStatues((Entity)entity, itemStackToDrop, source, event);
        } else if (entity instanceof Warden) {
            itemStackToDrop = new ItemStack((ItemLike)StatueRegistry.WARDEN_STATUE.get());
            this.dropBossStatue((Entity)entity, itemStackToDrop, source, event);
        } else {
            ArrayList<DeferredHolder> matchingStatues = new ArrayList<DeferredHolder>();
            for (DeferredHolder block : StatueRegistry.BLOCKS.getEntries()) {
                AbstractStatueBase statue;
                Object object = block.get();
                if (!(object instanceof AbstractStatueBase) || !(statue = (AbstractStatueBase)((Object)object)).getEntity().equals((Object)entity.getType()) || statue.isHiddenStatue()) continue;
                matchingStatues.add(block);
            }
            if (!matchingStatues.isEmpty()) {
                DeferredHolder block = (DeferredHolder)matchingStatues.get(rand.nextInt(matchingStatues.size()));
                AbstractStatueBase statue = (AbstractStatueBase)((Object)block.get());
                ItemStack itemStackToDrop = new ItemStack((ItemLike)statue);
                if (entity instanceof Mob) {
                    if (((Mob)entity).isBaby() == statue.isBaby()) {
                        this.dropLootStatues((Entity)entity, itemStackToDrop, source, event);
                    }
                } else {
                    this.dropLootStatues((Entity)entity, itemStackToDrop, source, event);
                }
            }
        }
        if (((Boolean)StatuesConfig.COMMON.playerDropsStatue.get()).booleanValue() && entity instanceof Player) {
            Player player = (Player)entity;
            ItemStack playerStatueStack = new ItemStack((ItemLike)StatueRegistry.PLAYER_STATUE.get());
            playerStatueStack.set(DataComponents.CUSTOM_NAME, (Object)Component.literal((String)player.getName().getString()));
            double random_drop = Math.random();
            double playerDropChance = (Double)StatuesConfig.COMMON.playerStatueDropChance.get();
            BlockPos entityPos = entity.blockPosition();
            switch ((StatuesConfig.EnumDeathSource)((Object)StatuesConfig.COMMON.playerStatueKillSource.get())) {
                default: {
                    if (!(source instanceof ServerPlayer)) break;
                    ServerPlayer sourcePlayer = (ServerPlayer)source;
                    if (source instanceof FakePlayer) break;
                    List luckyPlayers = (List)StatuesConfig.COMMON.lucky_players.get();
                    if (!luckyPlayers.isEmpty()) {
                        for (String luckyName : luckyPlayers) {
                            String user = sourcePlayer.getName().getString();
                            if (luckyName.isEmpty() || !user.equals(luckyName)) continue;
                            playerDropChance = (Double)StatuesConfig.COMMON.playerStatueDropChance.get() / 4.0;
                        }
                    }
                    if (!(random_drop <= playerDropChance)) break;
                    event.getDrops().add(new ItemEntity(level, (double)entityPos.getX(), (double)entityPos.getY(), (double)entityPos.getZ(), playerStatueStack));
                    break;
                }
                case PLAYER_FAKEPLAYER: {
                    if (!(source instanceof ServerPlayer) || !(random_drop <= playerDropChance)) break;
                    event.getDrops().add(new ItemEntity(level, (double)entityPos.getX(), (double)entityPos.getY(), (double)entityPos.getZ(), playerStatueStack));
                    break;
                }
                case ALL: {
                    if (!(random_drop <= playerDropChance)) break;
                    event.getDrops().add(new ItemEntity(level, (double)entityPos.getX(), (double)entityPos.getY(), (double)entityPos.getZ(), playerStatueStack));
                }
            }
        }
    }

    public void dropBossStatue(Entity entity, ItemStack itemStackToDrop, Entity source, LivingDropsEvent event) {
        BlockPos entityPos = entity.blockPosition();
        switch ((StatuesConfig.EnumDeathSource)((Object)StatuesConfig.COMMON.statueKillSource.get())) {
            default: {
                if (!(source instanceof ServerPlayer) || source instanceof FakePlayer) break;
                event.getDrops().add(new ItemEntity(entity.level(), (double)entityPos.getX(), (double)entityPos.getY(), (double)entityPos.getZ(), itemStackToDrop));
                break;
            }
            case PLAYER_FAKEPLAYER: {
                if (!(source instanceof ServerPlayer)) break;
                event.getDrops().add(new ItemEntity(entity.level(), (double)entityPos.getX(), (double)entityPos.getY(), (double)entityPos.getZ(), itemStackToDrop));
                break;
            }
            case ALL: {
                event.getDrops().add(new ItemEntity(entity.level(), (double)entityPos.getX(), (double)entityPos.getY(), (double)entityPos.getZ(), itemStackToDrop));
            }
        }
    }

    public void dropLootStatues(Entity entity, ItemStack itemStackToDrop, Entity source, LivingDropsEvent event) {
        double random_drop = Math.random();
        double default_drop_chance = (Double)StatuesConfig.COMMON.statueDropChance.get();
        BlockPos entityPos = entity.blockPosition();
        switch ((StatuesConfig.EnumDeathSource)((Object)StatuesConfig.COMMON.statueKillSource.get())) {
            default: {
                if (!(source instanceof ServerPlayer)) break;
                ServerPlayer player = (ServerPlayer)source;
                if (source instanceof FakePlayer) break;
                List luckyPlayers = (List)StatuesConfig.COMMON.lucky_players.get();
                if (!luckyPlayers.isEmpty()) {
                    for (String luckyName : luckyPlayers) {
                        String user = player.getName().getString();
                        if (luckyName.isEmpty() || !user.equals(luckyName)) continue;
                        default_drop_chance = (Double)StatuesConfig.COMMON.statueDropChance.get() / 4.0;
                    }
                }
                if (!(random_drop <= default_drop_chance)) break;
                event.getDrops().add(new ItemEntity(entity.level(), (double)entityPos.getX(), (double)entityPos.getY(), (double)entityPos.getZ(), itemStackToDrop));
                break;
            }
            case PLAYER_FAKEPLAYER: {
                if (!(source instanceof ServerPlayer) || !(random_drop <= default_drop_chance)) break;
                event.getDrops().add(new ItemEntity(entity.level(), (double)entityPos.getX(), (double)entityPos.getY(), (double)entityPos.getZ(), itemStackToDrop));
                break;
            }
            case ALL: {
                if (!(random_drop <= default_drop_chance)) break;
                event.getDrops().add(new ItemEntity(entity.level(), (double)entityPos.getX(), (double)entityPos.getY(), (double)entityPos.getZ(), itemStackToDrop));
            }
        }
    }
}

