/*
 * Decompiled with CFR 0.152.
 */
package com.shynieke.statues.handlers;

import com.shynieke.statues.blockentities.AbstractStatueBlockEntity;
import com.shynieke.statues.datacomponent.StatueStats;
import com.shynieke.statues.fakeplayer.StatueFakePlayer;
import com.shynieke.statues.items.StatueBlockItem;
import com.shynieke.statues.registry.StatueDataComponents;
import com.shynieke.statues.storage.StatueSavedData;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.neoforge.event.entity.living.FinalizeSpawnEvent;
import net.neoforged.neoforge.event.entity.living.LivingDeathEvent;
import net.neoforged.neoforge.event.level.LevelEvent;

public class StatueHandler {
    @SubscribeEvent
    public void onKill(LivingDeathEvent event) {
        LivingEntity target = event.getEntity();
        Entity source = event.getSource().getEntity();
        if (source instanceof Player) {
            Player player = (Player)source;
            Inventory inventory = player.getInventory();
            for (int i = 0; i < inventory.getContainerSize(); ++i) {
                Item item;
                ItemStack stack = inventory.getItem(i);
                if (stack.getCount() != 1 || !((item = stack.getItem()) instanceof StatueBlockItem)) continue;
                StatueBlockItem statue = (StatueBlockItem)item;
                if (!this.upgraded(stack) || !statue.matchesEntity(target)) continue;
                this.increaseKillCounter(stack);
                break;
            }
        }
    }

    private boolean upgraded(ItemStack stack) {
        return (Boolean)stack.getOrDefault(StatueDataComponents.UPGRADED, (Object)false);
    }

    private void increaseKillCounter(ItemStack stack) {
        StatueStats stats = (StatueStats)stack.getOrDefault(StatueDataComponents.STATS, (Object)StatueStats.empty());
        stats.setKillCount(stats.killCount() + 1);
        int level = this.getLevel(stats.killCount());
        if (stats.level() != level) {
            stats.setLevel(level);
            stats.setUpgradeSlots(stats.upgradeSlots() + 1);
        }
        stack.set(StatueDataComponents.STATS, (Object)stats);
    }

    public int getLevel(int killedMobs) {
        if (killedMobs > 0) {
            int level = (int)Math.floor((double)killedMobs / 10.0);
            return Math.min(level, 16);
        }
        return 0;
    }

    @SubscribeEvent
    public void onLivingSpawnEvent(FinalizeSpawnEvent event) {
        MobSpawnType spawnReason = event.getSpawnType();
        if (spawnReason == MobSpawnType.NATURAL || spawnReason == MobSpawnType.REINFORCEMENT || spawnReason == MobSpawnType.EVENT) {
            Mob mob = event.getEntity();
            BlockPos nearestDespawner = StatueSavedData.get().getNearestDespawner((ResourceKey<Level>)mob.level().dimension(), mob.blockPosition(), 32);
            if (nearestDespawner != null) {
                AbstractStatueBlockEntity statueBlockEntity;
                BlockEntity blockEntity = mob.level().getBlockEntity(nearestDespawner);
                if (blockEntity instanceof AbstractStatueBlockEntity && !(statueBlockEntity = (AbstractStatueBlockEntity)blockEntity).drainPower(statueBlockEntity.getDespawnPowerUsage())) {
                    return;
                }
                event.setSpawnCancelled(true);
            }
        }
    }

    @SubscribeEvent
    public void onLevelUnload(LevelEvent.Unload event) {
        LevelAccessor levelAccessor = event.getLevel();
        if (levelAccessor instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)levelAccessor;
            StatueFakePlayer.unload(serverLevel);
        }
    }
}

