/*
 * Decompiled with CFR 0.152.
 */
package com.shynieke.statues.items;

import com.shynieke.statues.blocks.statues.PlayerStatueBlock;
import com.shynieke.statues.datacomponent.PlayerCompassData;
import com.shynieke.statues.registry.StatueDataComponents;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;

public class PlayerCompassItem
extends Item {
    public PlayerCompassItem(Item.Properties builder) {
        super(builder);
    }

    public InteractionResult useOn(UseOnContext context) {
        Level level = context.getLevel();
        BlockPos pos = context.getClickedPos();
        Player playerIn = context.getPlayer();
        if (!level.isClientSide && playerIn != null && playerIn.isShiftKeyDown() && level.getBlockState(pos).getBlock() instanceof PlayerStatueBlock) {
            playerIn.setItemInHand(context.getHand(), new ItemStack((ItemLike)Items.COMPASS));
        }
        return super.useOn(context);
    }

    public void appendHoverText(ItemStack stack, Item.TooltipContext context, List<Component> tooltip, TooltipFlag flag) {
        PlayerCompassData data;
        if (stack.has(StatueDataComponents.PLAYER_COMPASS_DATA.get()) && (data = (PlayerCompassData)stack.get(StatueDataComponents.PLAYER_COMPASS_DATA.get())) != null) {
            tooltip.add((Component)Component.translatable((String)"statues.last.known.location", (Object[])new Object[]{data.name()}).withStyle(ChatFormatting.GOLD));
        }
    }
}

