/*
 * Decompiled with CFR 0.152.
 */
package com.shynieke.statues.items;

import com.mojang.authlib.GameProfile;
import com.shynieke.statues.entity.PlayerStatue;
import com.shynieke.statues.registry.StatueRegistry;
import java.util.Objects;
import net.minecraft.Util;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.core.Rotations;
import net.minecraft.core.component.DataComponents;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.component.ResolvableProfile;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.gameevent.GameEvent;

public class PlayerStatueSpawnItem
extends Item {
    public PlayerStatueSpawnItem(Item.Properties builder) {
        super(builder);
    }

    public InteractionResult useOn(UseOnContext context) {
        Level level = context.getLevel();
        if (!(level instanceof ServerLevel)) {
            return InteractionResult.SUCCESS;
        }
        ItemStack stack = context.getItemInHand();
        BlockPos pos = context.getClickedPos();
        Direction direction = context.getClickedFace();
        BlockState state = level.getBlockState(pos);
        BlockPos relativePos = state.getCollisionShape((BlockGetter)level, pos).isEmpty() ? pos : pos.relative(direction);
        EntityType<PlayerStatue> type = StatueRegistry.PLAYER_STATUE_ENTITY.get();
        Entity entity = type.spawn((ServerLevel)level, stack, context.getPlayer(), relativePos, MobSpawnType.SPAWN_EGG, true, !Objects.equals(pos, relativePos) && direction == Direction.UP);
        if (entity instanceof PlayerStatue) {
            PlayerStatue playerStatue = (PlayerStatue)entity;
            PlayerStatueSpawnItem.applyRandomRotations(playerStatue, level.random);
            if (!stack.has(DataComponents.CUSTOM_NAME)) {
                if (context.getPlayer() != null) {
                    playerStatue.setGameProfile(new ResolvableProfile(context.getPlayer().getGameProfile()));
                } else {
                    playerStatue.setGameProfile(new ResolvableProfile(new GameProfile(Util.NIL_UUID, "steve")));
                }
            }
            stack.shrink(1);
            level.gameEvent((Entity)context.getPlayer(), (Holder)GameEvent.ENTITY_PLACE, pos);
        }
        return InteractionResult.CONSUME;
    }

    public static void applyRandomRotations(PlayerStatue playerStatueEntity, RandomSource rand) {
        Rotations rotations = playerStatueEntity.getHeadRotation();
        float f = rand.nextFloat() * 5.0f;
        float f1 = rand.nextFloat() * 20.0f - 10.0f;
        Rotations rotations1 = new Rotations(rotations.getX() + f, rotations.getY() + f1, rotations.getZ());
        playerStatueEntity.setHeadRotation(rotations1);
        rotations = playerStatueEntity.getBodyRotation();
        f = rand.nextFloat() * 10.0f - 5.0f;
        rotations1 = new Rotations(rotations.getX(), rotations.getY() + f, rotations.getZ());
        playerStatueEntity.setBodyRotation(rotations1);
    }
}

