/*
 * Decompiled with CFR 0.152.
 */
package com.sunekaer.toolkit.commands.level;

import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.IntegerArgumentType;
import com.mojang.brigadier.builder.ArgumentBuilder;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.sunekaer.toolkit.jobs.ServerTickJobRunner;
import java.util.ArrayDeque;
import java.util.HashSet;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.commands.arguments.coordinates.BlockPosArgument;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.structure.BoundingBox;
import net.minecraft.world.level.material.FluidState;

public class DrainFluidCommand {
    public static ArgumentBuilder<CommandSourceStack, ?> register() {
        return ((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal((String)"drain").requires(cs -> cs.hasPermission(2))).then(Commands.argument((String)"area-size", (ArgumentType)IntegerArgumentType.integer((int)1, (int)300)).executes(ctx -> DrainFluidCommand.drainFluids((CommandSourceStack)ctx.getSource(), ((CommandSourceStack)ctx.getSource()).getPlayerOrException().blockPosition(), IntegerArgumentType.getInteger((CommandContext)ctx, (String)"area-size"), false)))).then(Commands.argument((String)"location", (ArgumentType)BlockPosArgument.blockPos()).then(Commands.argument((String)"area-size", (ArgumentType)IntegerArgumentType.integer((int)1, (int)300)).executes(ctx -> DrainFluidCommand.drainFluids((CommandSourceStack)ctx.getSource(), BlockPosArgument.getLoadedBlockPos((CommandContext)ctx, (String)"location"), IntegerArgumentType.getInteger((CommandContext)ctx, (String)"area-size"), true))));
    }

    private static int drainFluids(CommandSourceStack source, BlockPos location, int areaSize, boolean shift) {
        BlockState state;
        ServerLevel level = source.getLevel();
        BlockPos pos = location;
        if (shift) {
            for (Direction dir : Direction.values()) {
                BlockPos offset = pos.relative(dir);
                FluidState currentState = level.getFluidState(offset);
                if (currentState.isEmpty()) continue;
                pos = offset;
                break;
            }
        }
        if ((state = level.getBlockState(pos)).isAir()) {
            source.sendFailure((Component)Component.literal((String)"Go closer to the fluid source"));
            return 1;
        }
        if (state.getFluidState().isEmpty()) {
            source.sendFailure((Component)Component.literal((String)"No fluid found"));
            return 1;
        }
        FluidState fluidState = state.getFluidState();
        ArrayDeque<BlockPos> scanQueue = new ArrayDeque<BlockPos>();
        scanQueue.add(pos);
        int maxSize = Math.min(areaSize, 300);
        BoundingBox box = new BoundingBox(pos).inflatedBy(maxSize);
        HashSet<BlockPos> locationsToRemove = new HashSet<BlockPos>();
        while (!scanQueue.isEmpty()) {
            BlockPos currentPos = (BlockPos)scanQueue.pop();
            locationsToRemove.add(currentPos);
            for (Direction dir : Direction.values()) {
                BlockPos offset = currentPos.relative(dir);
                FluidState currentState = level.getFluidState(offset);
                if (currentState.isEmpty() || !fluidState.getType().isSame(currentState.getType()) || locationsToRemove.contains(offset) || !box.isInside((Vec3i)offset)) continue;
                scanQueue.add(offset);
                locationsToRemove.add(offset);
            }
        }
        ServerTickJobRunner.get().add(() -> {
            for (BlockPos blockPos : locationsToRemove) {
                level.setBlock(blockPos, Blocks.AIR.defaultBlockState(), 2);
                level.blockUpdated(blockPos, Blocks.AIR);
            }
        });
        return 0;
    }
}

