/*
 * Decompiled with CFR 0.152.
 */
package com.sunekaer.toolkit.commands.level;

import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.builder.ArgumentBuilder;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.serialization.Codec;
import java.util.ArrayList;
import java.util.function.BiPredicate;
import net.minecraft.commands.CommandBuildContext;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.commands.arguments.ResourceArgument;
import net.minecraft.commands.arguments.StringRepresentableArgument;
import net.minecraft.commands.synchronization.SuggestionProviders;
import net.minecraft.core.Holder;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.StringRepresentable;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.ExperienceOrb;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.vehicle.AbstractMinecart;
import org.jetbrains.annotations.NotNull;

public class KillEntitiesCommand {
    public static ArgumentBuilder<CommandSourceStack, ?> register(CommandBuildContext arg) {
        return ((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal((String)"kill").requires(cs -> cs.hasPermission(2))).then(Commands.argument((String)"type", (ArgumentType)KillTypeArgument.killType()).executes(context -> KillEntitiesCommand.kill(KillTypeArgument.getKillType((CommandContext<CommandSourceStack>)context, "type"), (CommandSourceStack)context.getSource())))).then(Commands.literal((String)"by").then(Commands.argument((String)"entity", (ArgumentType)ResourceArgument.resource((CommandBuildContext)arg, (ResourceKey)Registries.ENTITY_TYPE)).suggests(SuggestionProviders.SUMMONABLE_ENTITIES).executes(context -> KillEntitiesCommand.killByEntity((CommandContext<CommandSourceStack>)context, ResourceArgument.getSummonableEntityType((CommandContext)context, (String)"entity")))));
    }

    private static int killByEntity(CommandContext<CommandSourceStack> context, Holder.Reference<EntityType<?>> reference) throws CommandSyntaxException {
        CommandSourceStack source = (CommandSourceStack)context.getSource();
        ServerLevel level = source.getLevel();
        EntityType entityType = (EntityType)reference.value();
        source.sendSuccess(() -> Component.translatable((String)"commands.toolkit.kill.start", (Object[])new Object[]{entityType}), true);
        int entitiesKilled = KillEntitiesCommand.yeetEntities((player, entity) -> entity.getType().equals(entityType), level, (Player)source.getPlayerOrException());
        KillEntitiesCommand.yeetedEntitiesMessage(source, entitiesKilled, entityType.toShortString());
        return 0;
    }

    private static int kill(KillType type, CommandSourceStack source) throws CommandSyntaxException {
        ServerLevel level = source.getLevel();
        int entitiesKilled = 0;
        String typeName = Component.translatable((String)("commands.toolkit.kill.type." + type.name())).getString();
        source.sendSuccess(() -> Component.translatable((String)"commands.toolkit.kill.start", (Object[])new Object[]{typeName}), true);
        if (type == KillType.me || type == KillType.players) {
            for (Player player : level.getPlayers(e -> type.checker.test((Player)e, (Entity)e))) {
                player.kill();
                ++entitiesKilled;
            }
        } else {
            entitiesKilled += KillEntitiesCommand.yeetEntities(type.checker, level, (Player)source.getPlayerOrException());
        }
        KillEntitiesCommand.yeetedEntitiesMessage(source, entitiesKilled, typeName);
        return 1;
    }

    private static void yeetedEntitiesMessage(CommandSourceStack source, int yeetedAmount, String typeName) {
        if (yeetedAmount > 0) {
            source.sendSuccess(() -> Component.translatable((String)"commands.toolkit.kill.done", (Object[])new Object[]{yeetedAmount}), true);
        } else {
            source.sendSuccess(() -> Component.translatable((String)"commands.toolkit.kill.no", (Object[])new Object[]{typeName}), true);
        }
    }

    private static int yeetEntities(BiPredicate<Player, Entity> tester, ServerLevel level, Player player) {
        int entitiesKilled = 0;
        Iterable entities = level.getAllEntities();
        ArrayList entityList = new ArrayList();
        entities.forEach(entityList::add);
        for (Entity entity : entityList) {
            if (entity == null || !tester.test(player, entity)) continue;
            entity.remove(Entity.RemovalReason.KILLED);
            ++entitiesKilled;
        }
        return entitiesKilled;
    }

    public static class KillTypeArgument
    extends StringRepresentableArgument<KillType> {
        protected KillTypeArgument() {
            super(KillType.CODEC, KillType::values);
        }

        public static KillTypeArgument killType() {
            return new KillTypeArgument();
        }

        public static KillType getKillType(CommandContext<CommandSourceStack> source, String name) {
            return (KillType)((Object)source.getArgument(name, KillType.class));
        }
    }

    static enum KillType implements StringRepresentable
    {
        all((p, entity) -> !(entity instanceof AbstractMinecart) && !entity.getUUID().equals(p.getUUID())),
        animals((p, entity) -> entity instanceof Animal),
        monsters((p, entity) -> entity instanceof Monster),
        items((p, entity) -> entity instanceof ItemEntity),
        xp((p, entity) -> entity instanceof ExperienceOrb),
        players((p, entity) -> entity instanceof Player),
        me((p, entity) -> entity instanceof Player && entity.getUUID().equals(p.getUUID()));

        final BiPredicate<Player, Entity> checker;
        public static final Codec<KillType> CODEC;

        private KillType(BiPredicate<Player, Entity> checker) {
            this.checker = checker;
        }

        @NotNull
        public String getSerializedName() {
            return this.name();
        }

        static {
            CODEC = StringRepresentable.fromEnum(KillType::values);
        }
    }
}

