/*
 * Decompiled with CFR 0.152.
 */
package com.yungnickyoung.minecraft.yungsextras.world.feature.swamp;

import com.yungnickyoung.minecraft.yungsextras.world.config.ResourceLocationFeatureConfiguration;
import com.yungnickyoung.minecraft.yungsextras.world.feature.swamp.AbstractSwampFeature;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.levelgen.feature.FeaturePlaceContext;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureTemplate;

@ParametersAreNonnullByDefault
public class SwampChurchFeature
extends AbstractSwampFeature<ResourceLocationFeatureConfiguration> {
    public SwampChurchFeature() {
        super(ResourceLocationFeatureConfiguration.CODEC);
    }

    public boolean place(FeaturePlaceContext<ResourceLocationFeatureConfiguration> context) {
        WorldGenLevel level = context.level();
        RandomSource randomSource = context.random();
        BlockPos pos = context.origin();
        ResourceLocation location = ((ResourceLocationFeatureConfiguration)context.config()).getLocation();
        BlockPos.MutableBlockPos mutable = pos.mutable();
        while (level.isEmptyBlock((BlockPos)mutable) && mutable.getY() > 2) {
            mutable.move(Direction.DOWN);
        }
        BlockPos surfacePos = mutable.immutable();
        BlockPos cornerPos = surfacePos.offset(-6, 0, -2);
        mutable.set((Vec3i)cornerPos).move(Direction.DOWN, 4);
        if (level.isEmptyBlock((BlockPos)mutable)) {
            return false;
        }
        mutable.set((Vec3i)cornerPos).move(Direction.SOUTH, 4).move(Direction.DOWN, 4);
        if (level.isEmptyBlock((BlockPos)mutable)) {
            return false;
        }
        mutable.set((Vec3i)cornerPos).move(Direction.EAST, 12).move(Direction.DOWN, 4);
        if (level.isEmptyBlock((BlockPos)mutable)) {
            return false;
        }
        mutable.set((Vec3i)cornerPos).move(Direction.SOUTH, 4).move(Direction.EAST, 12).move(Direction.DOWN, 4);
        if (level.isEmptyBlock((BlockPos)mutable)) {
            return false;
        }
        StructureTemplate template = this.createTemplateFromCenter(location, level, randomSource, surfacePos);
        return template != null;
    }
}

