/*
 * Decompiled with CFR 0.152.
 */
package dev.aaronhowser.mods.aaron.registry;

import dev.aaronhowser.mods.aaron.AaronExtensions;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Supplier;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import net.minecraft.core.Holder;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.ArmorItem;
import net.minecraft.world.item.ArmorMaterial;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;
import net.neoforged.neoforge.registries.DeferredHolder;
import net.neoforged.neoforge.registries.DeferredRegister;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b&\u0018\u00002\u00020\u0001:\u0001\u0007B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005H&\u00a8\u0006\b"}, d2={"Ldev/aaronhowser/mods/aaron/registry/AaronArmorMaterialRegistry;", "", "<init>", "()V", "getArmorMaterialRegistry", "Lnet/neoforged/neoforge/registries/DeferredRegister;", "Lnet/minecraft/world/item/ArmorMaterial;", "Builder", "aaron-1.21.1"})
public abstract class AaronArmorMaterialRegistry {
    @NotNull
    public abstract DeferredRegister<ArmorMaterial> getArmorMaterialRegistry();

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000f\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0007\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0084\u0004\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0012\u0010\r\u001a\u00060\u0000R\u00020\u00182\u0006\u0010\u0019\u001a\u00020\tJ\u0012\u0010\u001a\u001a\u00060\u0000R\u00020\u00182\u0006\u0010\u001b\u001a\u00020\tJ\u0012\u0010\u001c\u001a\u00060\u0000R\u00020\u00182\u0006\u0010\u001b\u001a\u00020\tJ\u0012\u0010\u001d\u001a\u00060\u0000R\u00020\u00182\u0006\u0010\u001b\u001a\u00020\tJ\u0012\u0010\u001e\u001a\u00060\u0000R\u00020\u00182\u0006\u0010\u001b\u001a\u00020\tJ\u0012\u0010\u001f\u001a\u00060\u0000R\u00020\u00182\u0006\u0010\u001b\u001a\u00020\tJ\u0018\u0010 \u001a\u00060\u0000R\u00020\u00182\f\u0010!\u001a\b\u0012\u0004\u0012\u00020#0\"J\u0018\u0010 \u001a\u00060\u0000R\u00020\u00182\f\u0010$\u001a\b\u0012\u0004\u0012\u00020#0\u000fJ\u0012\u0010%\u001a\u00060\u0000R\u00020\u00182\u0006\u0010&\u001a\u00020\u0017J\u0006\u0010'\u001a\u00020(J\u0012\u0010)\u001a\u000e\u0012\u0004\u0012\u00020(\u0012\u0004\u0012\u00020(0*R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0006\u001a\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\t0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00100\u000fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001c\u0010\u0011\u001a\u0010\u0012\f\u0012\n \u0014*\u0004\u0018\u00010\u00130\u00130\u0012X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00170\u0016X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006+"}, d2={"Ldev/aaronhowser/mods/aaron/registry/AaronArmorMaterialRegistry$Builder;", "", "path", "", "<init>", "(Ldev/aaronhowser/mods/aaron/registry/AaronArmorMaterialRegistry;Ljava/lang/String;)V", "armorMap", "", "Lnet/minecraft/world/item/ArmorItem$Type;", "", "toughness", "", "knockbackResist", "enchantValue", "equipSound", "Lnet/minecraft/core/Holder;", "Lnet/minecraft/sounds/SoundEvent;", "repairIngredient", "Ljava/util/function/Supplier;", "Lnet/minecraft/world/item/crafting/Ingredient;", "kotlin.jvm.PlatformType", "layers", "", "Lnet/minecraft/world/item/ArmorMaterial$Layer;", "Ldev/aaronhowser/mods/aaron/registry/AaronArmorMaterialRegistry;", "value", "boot", "armorAmount", "leg", "chestplate", "helmet", "armor", "repair", "tag", "Lnet/minecraft/tags/TagKey;", "Lnet/minecraft/world/item/Item;", "itemHolder", "addLayer", "layer", "build", "Lnet/minecraft/world/item/ArmorMaterial;", "register", "Lnet/neoforged/neoforge/registries/DeferredHolder;", "aaron-1.21.1"})
    protected final class Builder {
        @NotNull
        private final String path;
        @NotNull
        private final Map<ArmorItem.Type, Integer> armorMap;
        private float toughness;
        private float knockbackResist;
        private int enchantValue;
        @NotNull
        private Holder<SoundEvent> equipSound;
        @NotNull
        private Supplier<Ingredient> repairIngredient;
        @NotNull
        private final List<ArmorMaterial.Layer> layers;

        public Builder(String path) {
            Intrinsics.checkNotNullParameter((Object)path, (String)"path");
            this.path = path;
            this.armorMap = new LinkedHashMap();
            this.enchantValue = 10;
            Holder holder = SoundEvents.ARMOR_EQUIP_GENERIC;
            Intrinsics.checkNotNullExpressionValue((Object)holder, (String)"ARMOR_EQUIP_GENERIC");
            this.equipSound = holder;
            this.repairIngredient = Builder::repairIngredient$lambda$0;
            this.layers = new ArrayList();
            ResourceLocation id = ResourceLocation.fromNamespaceAndPath((String)AaronArmorMaterialRegistry.this.getArmorMaterialRegistry().getNamespace(), (String)this.path);
            this.addLayer(new ArmorMaterial.Layer(id));
        }

        @NotNull
        public final Builder enchantValue(int value) {
            this.enchantValue = value;
            return this;
        }

        @NotNull
        public final Builder boot(int armorAmount) {
            Integer n = armorAmount;
            this.armorMap.put(ArmorItem.Type.BOOTS, n);
            return this;
        }

        @NotNull
        public final Builder leg(int armorAmount) {
            Integer n = armorAmount;
            this.armorMap.put(ArmorItem.Type.LEGGINGS, n);
            return this;
        }

        @NotNull
        public final Builder chestplate(int armorAmount) {
            Integer n = armorAmount;
            this.armorMap.put(ArmorItem.Type.CHESTPLATE, n);
            return this;
        }

        @NotNull
        public final Builder helmet(int armorAmount) {
            Integer n = armorAmount;
            this.armorMap.put(ArmorItem.Type.HELMET, n);
            return this;
        }

        @NotNull
        public final Builder armor(int armorAmount) {
            this.helmet(armorAmount);
            this.chestplate(armorAmount);
            this.leg(armorAmount);
            this.boot(armorAmount);
            return this;
        }

        @NotNull
        public final Builder repair(@NotNull TagKey<Item> tag) {
            Intrinsics.checkNotNullParameter(tag, (String)"tag");
            this.repairIngredient = () -> Builder.repair$lambda$1(tag);
            return this;
        }

        @NotNull
        public final Builder repair(@NotNull Holder<Item> itemHolder) {
            Intrinsics.checkNotNullParameter(itemHolder, (String)"itemHolder");
            this.repairIngredient = () -> Builder.repair$lambda$2(itemHolder);
            return this;
        }

        @NotNull
        public final Builder addLayer(@NotNull ArmorMaterial.Layer layer) {
            Intrinsics.checkNotNullParameter((Object)layer, (String)"layer");
            this.layers.add(layer);
            return this;
        }

        @NotNull
        public final ArmorMaterial build() {
            return new ArmorMaterial(this.armorMap, this.enchantValue, this.equipSound, this.repairIngredient, this.layers, this.toughness, this.knockbackResist);
        }

        @NotNull
        public final DeferredHolder<ArmorMaterial, ArmorMaterial> register() {
            DeferredHolder deferredHolder = AaronArmorMaterialRegistry.this.getArmorMaterialRegistry().register(this.path, this::build);
            Intrinsics.checkNotNullExpressionValue((Object)deferredHolder, (String)"register(...)");
            return deferredHolder;
        }

        private static final Ingredient repairIngredient$lambda$0() {
            return Ingredient.EMPTY;
        }

        private static final Ingredient repair$lambda$1(TagKey $tag) {
            return AaronExtensions.INSTANCE.asIngredient((TagKey<Item>)$tag);
        }

        private static final Ingredient repair$lambda$2(Holder $itemHolder) {
            Object object = $itemHolder.value();
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"value(...)");
            return AaronExtensions.INSTANCE.asIngredient((ItemLike)object);
        }
    }
}

