/*
 * Decompiled with CFR 0.152.
 */
package de.ellpeck.actuallyadditions.mod.items;

import de.ellpeck.actuallyadditions.mod.components.ActuallyComponents;
import de.ellpeck.actuallyadditions.mod.components.LastXY;
import de.ellpeck.actuallyadditions.mod.config.CommonConfig;
import de.ellpeck.actuallyadditions.mod.items.ActuallyItems;
import de.ellpeck.actuallyadditions.mod.items.base.ItemBase;
import javax.annotation.Nonnull;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.stats.Stats;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.ItemUtils;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.BucketPickup;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.neoforge.common.NeoForge;
import net.neoforged.neoforge.event.entity.player.PlayerInteractEvent;

public class ItemWaterBowl
extends ItemBase {
    public ItemWaterBowl() {
        super(ActuallyItems.defaultProps().stacksTo(1));
        NeoForge.EVENT_BUS.register((Object)this);
    }

    @SubscribeEvent
    public void onPlayerInteractEvent(PlayerInteractEvent.RightClickItem event) {
        if (((Boolean)CommonConfig.Other.WATER_BOWL.get()).booleanValue() && event.getItemStack().is(Items.BOWL)) {
            BlockState blockState;
            FluidState fluidState;
            Player player = event.getEntity();
            Level level = event.getLevel();
            BlockHitResult trace = ItemWaterBowl.getPlayerPOVHitResult((Level)level, (Player)player, (ClipContext.Fluid)ClipContext.Fluid.SOURCE_ONLY);
            if (trace.getType() != HitResult.Type.BLOCK) {
                return;
            }
            ItemStack bowl = event.getItemStack();
            BlockPos pos = trace.getBlockPos();
            if (level.mayInteract(player, pos) && player.mayUseItemAt(pos.relative(trace.getDirection()), trace.getDirection(), bowl) && (fluidState = (blockState = level.getBlockState(pos)).getFluidState()).isSourceOfType((Fluid)Fluids.WATER)) {
                Block block = blockState.getBlock();
                if (block instanceof BucketPickup) {
                    BucketPickup pickup = (BucketPickup)block;
                    ItemStack fillResult = pickup.pickupBlock(player, (LevelAccessor)level, pos, blockState);
                    if (!fillResult.isEmpty()) {
                        player.awardStat(Stats.ITEM_USED.get((Object)bowl.getItem()));
                        level.gameEvent((Entity)player, (Holder)GameEvent.FLUID_PICKUP, pos);
                    }
                    pickup.getPickupSound(blockState).ifPresent(soundEvent -> player.playSound(soundEvent, 1.0f, 1.0f));
                }
                ItemStack waterBowl = new ItemStack((ItemLike)ActuallyItems.WATER_BOWL.get());
                ItemStack inHand = ItemUtils.createFilledResult((ItemStack)bowl, (Player)player, (ItemStack)waterBowl);
                player.setItemInHand(event.getHand(), inHand);
            }
        }
    }

    @Nonnull
    public InteractionResultHolder<ItemStack> use(@Nonnull Level world, Player player, @Nonnull InteractionHand hand) {
        BlockPos pos1;
        ItemStack stack = player.getItemInHand(hand);
        HitResult trace = player.pick(player.blockInteractionRange(), 1.0f, false);
        if (trace.getType() == HitResult.Type.MISS) {
            return InteractionResultHolder.pass((Object)stack);
        }
        if (trace.getType() != HitResult.Type.BLOCK) {
            return InteractionResultHolder.pass((Object)stack);
        }
        BlockHitResult blockTrace = (BlockHitResult)trace;
        BlockPos pos = blockTrace.getBlockPos();
        if (!world.mayInteract(player, pos)) {
            return InteractionResultHolder.fail((Object)stack);
        }
        BlockPos blockPos = pos1 = world.getBlockState(pos).canBeReplaced() && blockTrace.getDirection() == Direction.UP ? pos : pos.relative(blockTrace.getDirection());
        if (!player.mayUseItemAt(pos1, blockTrace.getDirection(), stack)) {
            return InteractionResultHolder.fail((Object)stack);
        }
        if (this.tryPlaceContainedLiquid(player, world, pos1, false)) {
            return !player.isCreative() ? InteractionResultHolder.success((Object)new ItemStack((ItemLike)Items.BOWL)) : InteractionResultHolder.success((Object)stack);
        }
        return InteractionResultHolder.fail((Object)stack);
    }

    public void inventoryTick(@Nonnull ItemStack stack, Level world, @Nonnull Entity entity, int itemSlot, boolean isSelected) {
        if (!world.isClientSide && ((Boolean)CommonConfig.Other.WATER_BOWL_LOSS.get()).booleanValue() && world.getGameTime() % 10L == 0L && world.random.nextFloat() >= 0.5f) {
            int lastX = 0;
            int lastY = 0;
            if (stack.has(ActuallyComponents.LAST_XY)) {
                LastXY lastXY = (LastXY)stack.get(ActuallyComponents.LAST_XY);
                lastX = lastXY.x();
                lastY = lastXY.y();
            }
            boolean change = false;
            if (lastX != 0 && lastX != (int)entity.getX() || lastY != 0 && lastY != (int)entity.getY()) {
                Player player;
                if (!entity.isShiftKeyDown() && entity instanceof Player && this.tryPlaceContainedLiquid(player = (Player)entity, world, player.blockPosition(), true)) {
                    this.checkReplace(player, stack, new ItemStack((ItemLike)Items.BOWL), itemSlot);
                }
                change = true;
            }
            if (change || lastX == 0 || lastY == 0) {
                stack.set(ActuallyComponents.LAST_XY, (Object)new LastXY((int)entity.getX(), (int)entity.getY()));
            }
        }
    }

    private void checkReplace(Player player, ItemStack old, ItemStack stack, int slot) {
        if (player.getInventory().getItem(slot) == old) {
            player.getInventory().setItem(slot, stack);
        } else if (player.getInventory().offhand.get(slot) == old) {
            player.getInventory().offhand.set(slot, (Object)stack);
        }
    }

    public boolean shouldCauseReequipAnimation(@Nonnull ItemStack oldStack, @Nonnull ItemStack newStack, boolean slotChanged) {
        return !ItemStack.isSameItem((ItemStack)oldStack, (ItemStack)newStack);
    }

    public boolean tryPlaceContainedLiquid(Player player, Level world, BlockPos pos, boolean finite) {
        BlockState state = world.getBlockState(pos);
        boolean nonSolid = !state.isSolid();
        boolean replaceable = state.canBeReplaced();
        if (!(world.isEmptyBlock(pos) || nonSolid || replaceable)) {
            return false;
        }
        if (world.dimensionType().ultraWarm()) {
            world.playSound(player, pos, SoundEvents.FIRE_EXTINGUISH, SoundSource.BLOCKS, 0.5f, 2.6f + (world.random.nextFloat() - world.random.nextFloat()) * 0.8f);
            for (int k = 0; k < 8; ++k) {
                world.addParticle((ParticleOptions)ParticleTypes.LARGE_SMOKE, (double)pos.getX() + Math.random(), (double)pos.getY() + Math.random(), (double)pos.getZ() + Math.random(), 0.0, 0.0, 0.0);
            }
        } else {
            if (!world.isClientSide && (nonSolid || replaceable) && world.getFluidState(pos).isEmpty()) {
                world.destroyBlock(pos, true);
            }
            world.playSound(player, pos, SoundEvents.BUCKET_EMPTY, SoundSource.BLOCKS, 1.0f, 1.0f);
            BlockState placeState = Blocks.WATER.defaultBlockState();
            world.setBlock(pos, placeState, 3);
        }
        return true;
    }
}

