/*
 * Decompiled with CFR 0.152.
 */
package de.ellpeck.actuallyadditions.mod.misc.special;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import net.minecraft.Util;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.player.PlayerModelPart;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.phys.Vec3;

public class RenderSpecial {
    private final ItemStack theThingToRender;

    public RenderSpecial(ItemStack stack) {
        this.theThingToRender = stack;
    }

    public void render(PoseStack matrixStack, MultiBufferSource buffer, int combinedLight, Player player, float partialTick) {
        if (this.theThingToRender.isEmpty() || player.isInvisible() || !player.isModelPartShown(PlayerModelPart.CAPE) || player.isFallFlying()) {
            return;
        }
        matrixStack.pushPose();
        Vec3 currentPos = Minecraft.getInstance().player.getEyePosition(partialTick);
        Vec3 playerPos = player.getEyePosition(partialTick);
        matrixStack.translate(playerPos.x - currentPos.x, playerPos.y - currentPos.y, playerPos.z - currentPos.z);
        matrixStack.translate(0.0, 2.575 - (player.isCrouching() ? 0.125 : 0.0), 0.0);
        matrixStack.pushPose();
        boolean isBlock = this.theThingToRender.getItem() instanceof BlockItem;
        if (isBlock) {
            matrixStack.translate(0.0, -0.1875, 0.0);
        }
        matrixStack.mulPose(Axis.ZP.rotationDegrees(180.0f));
        float size = isBlock ? 0.5f : 0.4f;
        matrixStack.scale(size, size, size);
        double boop = (double)Util.getMillis() / 1000.0;
        matrixStack.translate(0.0, Math.sin(boop % (Math.PI * 2)) * 0.25, 0.0);
        matrixStack.mulPose(Axis.YP.rotationDegrees((float)(boop * 40.0 % 360.0)));
        matrixStack.pushPose();
        if (!isBlock) {
            matrixStack.translate(0.0, 0.5, 0.0);
        }
        matrixStack.mulPose(Axis.XN.rotationDegrees(180.0f));
        Minecraft.getInstance().getItemRenderer().renderStatic(this.theThingToRender, ItemDisplayContext.FIXED, combinedLight, OverlayTexture.NO_OVERLAY, matrixStack, buffer, null, 0);
        matrixStack.popPose();
        matrixStack.popPose();
        matrixStack.popPose();
    }
}

