/*
 * Decompiled with CFR 0.152.
 */
package dev.uncandango.alltheleaks.api.windows;

import org.lwjgl.system.APIUtil;
import org.lwjgl.system.Checks;
import org.lwjgl.system.FunctionProvider;
import org.lwjgl.system.JNI;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.SharedLibrary;
import org.lwjgl.system.windows.Kernel32;

public class PsApi {
    private static final SharedLibrary PSAPI = APIUtil.apiCreateLibrary((String)"psapi");

    public static SharedLibrary getLibrary() {
        return PSAPI;
    }

    @NativeType(value="BOOL")
    private static boolean nEmptyWorkingSet(@NativeType(value="HANDLE") long hProcess) {
        long __functionAddress = Functions.EmptyWorkingSet;
        if (Checks.CHECKS) {
            Checks.check((long)__functionAddress);
            Checks.check((long)hProcess);
        }
        return JNI.callPI((long)hProcess, (long)__functionAddress) != 0;
    }

    public static boolean EmptyWorkingSetOfCurrentProcess() {
        return PsApi.nEmptyWorkingSet(Kernel32.GetCurrentProcess());
    }

    @NativeType(value="BOOL")
    public static boolean GetProcessMemoryInfo(@NativeType(value="HANDLE") long Process, @NativeType(value="PROCESS_MEMORY_COUNTERS *") long ppsmemCounters, @NativeType(value="DWORD") int cb) {
        long __functionAddress = Functions.GetProcessMemoryInfo;
        if (Checks.CHECKS) {
            Checks.check((long)__functionAddress);
            Checks.check((long)Process);
            Checks.check((long)ppsmemCounters);
        }
        return JNI.callPPPI((long)Process, (long)ppsmemCounters, (long)cb, (long)__functionAddress) != 0;
    }

    public static final class Functions {
        public static final long EmptyWorkingSet = APIUtil.apiGetFunctionAddress((FunctionProvider)PSAPI, (String)"EmptyWorkingSet");
        public static final long GetProcessMemoryInfo = APIUtil.apiGetFunctionAddress((FunctionProvider)PSAPI, (String)"GetProcessMemoryInfo");

        private Functions() {
        }
    }
}

