/*
 * Decompiled with CFR 0.152.
 */
package com.almostreliable.unified.compat.viewer;

import com.almostreliable.unified.unification.recipe.RecipeLink;
import com.almostreliable.unified.utils.Utils;
import com.google.common.collect.ImmutableMap;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.core.HolderLookup;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeInput;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.Nullable;

public record ClientRecipeTracker(String namespace, Map<ResourceLocation, ClientRecipeLink> recipes) implements Recipe<RecipeInput>
{
    public static final ResourceLocation ID = Utils.getRL("client_recipe_tracker");
    public static final String RECIPES = "recipes";
    public static final String NAMESPACE = "namespace";
    public static final int UNIFIED_FLAG = 1;
    public static final int DUPLICATE_FLAG = 2;
    public static final RecipeSerializer<ClientRecipeTracker> SERIALIZER = new Serializer();
    public static final RecipeType<ClientRecipeTracker> TYPE = new RecipeType<ClientRecipeTracker>(){

        public String toString() {
            return ID.getPath();
        }
    };

    private static String createRaw(boolean isUnified, boolean isDuplicate, String idPath) {
        int flag = 0;
        if (isUnified) {
            flag |= 1;
        }
        if (isDuplicate) {
            flag |= 2;
        }
        return flag + "$" + idPath;
    }

    public boolean matches(RecipeInput recipeInput, Level level) {
        return false;
    }

    public ItemStack assemble(RecipeInput recipeInput, HolderLookup.Provider provider) {
        return ItemStack.EMPTY;
    }

    public boolean canCraftInDimensions(int width, int height) {
        return false;
    }

    public ItemStack getResultItem(HolderLookup.Provider provider) {
        return ItemStack.EMPTY;
    }

    public RecipeSerializer<?> getSerializer() {
        return SERIALIZER;
    }

    public RecipeType<?> getType() {
        return TYPE;
    }

    private void add(ClientRecipeLink clientRecipeLink) {
        this.recipes.put(clientRecipeLink.id(), clientRecipeLink);
    }

    @Nullable
    public ClientRecipeLink getLink(ResourceLocation recipeId) {
        return this.recipes.get(recipeId);
    }

    public List<String> getLinkStrings() {
        return this.recipes.values().stream().map(l -> ClientRecipeTracker.createRaw(l.isUnified, l.isDuplicate, l.id.getPath())).toList();
    }

    public record ClientRecipeLink(ResourceLocation id, boolean isUnified, boolean isDuplicate) {
    }

    public static class Serializer
    implements RecipeSerializer<ClientRecipeTracker> {
        public static final MapCodec<ClientRecipeTracker> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)Codec.STRING.fieldOf(ClientRecipeTracker.NAMESPACE).forGetter(ClientRecipeTracker::namespace), (App)Codec.list((Codec)Codec.STRING).fieldOf(ClientRecipeTracker.RECIPES).forGetter(ClientRecipeTracker::getLinkStrings)).apply((Applicative)instance, Serializer::of));
        public static final StreamCodec<RegistryFriendlyByteBuf, ClientRecipeTracker> STREAM_CODEC = new StreamCodec<RegistryFriendlyByteBuf, ClientRecipeTracker>(){

            public ClientRecipeTracker decode(RegistryFriendlyByteBuf buffer) {
                int size = buffer.readInt();
                String namespace = buffer.readUtf();
                ImmutableMap.Builder builder = ImmutableMap.builder();
                for (int i = 0; i < size; ++i) {
                    String raw = buffer.readUtf();
                    ClientRecipeLink clientRecipeLink = Serializer.parseRaw(namespace, raw);
                    builder.put((Object)clientRecipeLink.id(), (Object)clientRecipeLink);
                }
                return new ClientRecipeTracker(namespace, (Map<ResourceLocation, ClientRecipeLink>)builder.build());
            }

            public void encode(RegistryFriendlyByteBuf buffer, ClientRecipeTracker recipe) {
                buffer.writeInt(recipe.recipes.size());
                buffer.writeUtf(recipe.namespace);
                for (ClientRecipeLink clientRecipeLink : recipe.recipes.values()) {
                    String raw = ClientRecipeTracker.createRaw(clientRecipeLink.isUnified(), clientRecipeLink.isDuplicate(), clientRecipeLink.id().getPath());
                    buffer.writeUtf(raw);
                }
            }
        };

        public MapCodec<ClientRecipeTracker> codec() {
            return CODEC;
        }

        public StreamCodec<RegistryFriendlyByteBuf, ClientRecipeTracker> streamCodec() {
            return STREAM_CODEC;
        }

        private static ClientRecipeTracker of(String namespace, List<String> recipes) {
            ImmutableMap.Builder builder = ImmutableMap.builder();
            for (String recipe : recipes) {
                ClientRecipeLink link = Serializer.parseRaw(namespace, recipe);
                builder.put((Object)link.id(), (Object)link);
            }
            return new ClientRecipeTracker(namespace, (Map<ResourceLocation, ClientRecipeLink>)builder.build());
        }

        public static ClientRecipeLink parseRaw(String namespace, String raw) {
            String[] split = raw.split("\\$", 2);
            int flag = Integer.parseInt(split[0]);
            boolean isUnified = (flag & 1) != 0;
            boolean isDuplicate = (flag & 2) != 0;
            return new ClientRecipeLink(ResourceLocation.fromNamespaceAndPath((String)namespace, (String)split[1]), isUnified, isDuplicate);
        }
    }

    public static class RawBuilder {
        private final Map<String, JsonArray> recipesByNamespace = new HashMap<String, JsonArray>();

        public void add(RecipeLink recipe) {
            ResourceLocation recipeId = recipe.getId();
            JsonArray array = this.recipesByNamespace.computeIfAbsent(recipeId.getNamespace(), k -> new JsonArray());
            array.add(ClientRecipeTracker.createRaw(recipe.isUnified(), recipe.hasDuplicateLink(), recipeId.getPath()));
        }

        public Map<ResourceLocation, JsonObject> compute() {
            HashMap<ResourceLocation, JsonObject> result = new HashMap<ResourceLocation, JsonObject>();
            this.recipesByNamespace.forEach((namespace, recipes) -> {
                JsonObject json = new JsonObject();
                json.addProperty("type", ID.toString());
                json.addProperty(ClientRecipeTracker.NAMESPACE, namespace);
                json.add(ClientRecipeTracker.RECIPES, (JsonElement)recipes);
                result.put(Utils.getRL(namespace), json);
            });
            return result;
        }
    }
}

