/*
 * Decompiled with CFR 0.152.
 */
package squeek.appleskin.helpers;

import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectCategory;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.food.FoodData;
import net.minecraft.world.food.FoodProperties;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.Level;
import net.neoforged.bus.api.Event;
import net.neoforged.neoforge.common.NeoForge;
import org.jetbrains.annotations.Nullable;
import squeek.appleskin.api.event.FoodValuesEvent;

public class FoodHelper {
    public static FoodProperties EMPTY_FOOD_PROPERTIES = new FoodProperties.Builder().build();
    public static float REGEN_EXHAUSTION_INCREMENT = 6.0f;
    public static float MAX_EXHAUSTION = 4.0f;

    public static boolean isFood(ItemStack itemStack, Player player) {
        return itemStack.getFoodProperties((LivingEntity)player) != null;
    }

    public static boolean canConsume(Player player, FoodProperties foodProperties) {
        return player.canEat(foodProperties.canAlwaysEat());
    }

    public static FoodProperties getDefaultFoodValues(ItemStack itemStack, Player player) {
        FoodProperties properties = itemStack.getFoodProperties((LivingEntity)player);
        return properties != null ? properties : EMPTY_FOOD_PROPERTIES;
    }

    @Nullable
    public static QueriedFoodResult query(ItemStack itemStack, Player player) {
        if (!FoodHelper.isFood(itemStack, player)) {
            return null;
        }
        FoodProperties defaultFood = FoodHelper.getDefaultFoodValues(itemStack, player);
        FoodValuesEvent foodValuesEvent = new FoodValuesEvent(player, itemStack, defaultFood, defaultFood);
        NeoForge.EVENT_BUS.post((Event)foodValuesEvent);
        return new QueriedFoodResult(foodValuesEvent.defaultFoodProperties, foodValuesEvent.modifiedFoodProperties, itemStack);
    }

    public static boolean isRotten(FoodProperties foodProperties) {
        for (FoodProperties.PossibleEffect effect : foodProperties.effects()) {
            MobEffectInstance effectInstance = effect.effect();
            if (((MobEffect)effectInstance.getEffect().value()).getCategory() != MobEffectCategory.HARMFUL) continue;
            return true;
        }
        return false;
    }

    public static float getEstimatedHealthIncrement(Player player, FoodProperties foodProperties) {
        if (!player.isHurt()) {
            return 0.0f;
        }
        FoodData stats = player.getFoodData();
        Level world = player.getCommandSenderWorld();
        int foodLevel = Math.min(stats.getFoodLevel() + foodProperties.nutrition(), 20);
        float healthIncrement = 0.0f;
        if ((float)foodLevel >= 18.0f && world != null && world.getGameRules().getBoolean(GameRules.RULE_NATURAL_REGENERATION)) {
            float saturationLevel = Math.min(stats.getSaturationLevel() + foodProperties.saturation(), (float)foodLevel);
            float exhaustionLevel = stats.getExhaustionLevel();
            healthIncrement = FoodHelper.getEstimatedHealthIncrement(foodLevel, saturationLevel, exhaustionLevel);
        }
        for (FoodProperties.PossibleEffect effect : foodProperties.effects()) {
            MobEffectInstance effectInstance = effect.effect();
            if (!effectInstance.is(MobEffects.REGENERATION)) continue;
            int amplifier = effectInstance.getAmplifier();
            int duration = effectInstance.getDuration();
            healthIncrement += (float)Math.floor(duration / Math.max(50 >> amplifier, 1));
            break;
        }
        return healthIncrement;
    }

    public static float getEstimatedHealthIncrement(int foodLevel, float saturationLevel, float exhaustionLevel) {
        float health = 0.0f;
        if (!Float.isFinite(exhaustionLevel) || !Float.isFinite(saturationLevel)) {
            return 0.0f;
        }
        while (foodLevel >= 18) {
            while (exhaustionLevel > MAX_EXHAUSTION) {
                exhaustionLevel -= MAX_EXHAUSTION;
                if (saturationLevel > 0.0f) {
                    saturationLevel = Math.max(saturationLevel - 1.0f, 0.0f);
                    continue;
                }
                --foodLevel;
            }
            if (foodLevel >= 20 && Float.compare(saturationLevel, Float.MIN_NORMAL) > 0) {
                float limitedSaturationLevel = Math.min(saturationLevel, REGEN_EXHAUSTION_INCREMENT);
                float exhaustionUntilAboveMax = Math.nextUp(MAX_EXHAUSTION) - exhaustionLevel;
                int numIterationsUntilAboveMax = Math.max(1, (int)Math.ceil(exhaustionUntilAboveMax / limitedSaturationLevel));
                health += limitedSaturationLevel / REGEN_EXHAUSTION_INCREMENT * (float)numIterationsUntilAboveMax;
                exhaustionLevel += limitedSaturationLevel * (float)numIterationsUntilAboveMax;
                continue;
            }
            if (foodLevel < 18) continue;
            health += 1.0f;
            exhaustionLevel += REGEN_EXHAUSTION_INCREMENT;
        }
        return health;
    }

    public static class QueriedFoodResult {
        public FoodProperties defaultFoodProperties;
        public FoodProperties modifiedFoodProperties;
        public final ItemStack itemStack;

        public QueriedFoodResult(FoodProperties defaultFoodProperties, FoodProperties modifiedFoodProperties, ItemStack itemStack) {
            this.defaultFoodProperties = defaultFoodProperties;
            this.modifiedFoodProperties = modifiedFoodProperties;
            this.itemStack = itemStack;
        }
    }
}

