/*
 * Decompiled with CFR 0.152.
 */
package com.github.jarva.arsadditions.common.item;

import com.github.jarva.arsadditions.ArsAdditions;
import com.github.jarva.arsadditions.common.advancement.Triggers;
import com.github.jarva.arsadditions.server.util.LocateUtil;
import com.github.jarva.arsadditions.server.util.TeleportUtil;
import com.hollingsworth.arsnouveau.common.advancement.ANCriteriaTriggers;
import com.hollingsworth.arsnouveau.common.block.PortalBlock;
import com.hollingsworth.arsnouveau.common.items.data.WarpScrollData;
import com.hollingsworth.arsnouveau.common.util.PortUtil;
import com.hollingsworth.arsnouveau.setup.registry.BlockRegistry;
import com.hollingsworth.arsnouveau.setup.registry.DataComponentRegistry;
import java.util.List;
import java.util.function.Supplier;
import net.minecraft.advancements.critereon.PlayerTrigger;
import net.minecraft.client.Minecraft;
import net.minecraft.core.BlockPos;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.tags.TagKey;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Rarity;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.Level;

public class ExplorationWarpScroll
extends Item {
    public ExplorationWarpScroll() {
        super(new Item.Properties().stacksTo(1).rarity(Rarity.EPIC));
    }

    public InteractionResult useOn(UseOnContext context) {
        return super.useOn(context);
    }

    public boolean onEntityItemUpdate(ItemStack stack, ItemEntity entity) {
        Level level = entity.getCommandSenderWorld();
        if (!(level instanceof ServerLevel)) {
            return false;
        }
        ServerLevel serverLevel = (ServerLevel)level;
        if (LocateUtil.isPending(stack)) {
            LocateUtil.resolveUUID(serverLevel, entity.position(), stack, null);
        }
        BlockPos pos = entity.blockPosition();
        boolean isRuinedPortal = serverLevel.structureManager().getStructureWithPieceAt(pos, TagKey.create((ResourceKey)Registries.STRUCTURE, (ResourceLocation)ArsAdditions.prefix("ruined_portals"))).isValid();
        if (isRuinedPortal) {
            WarpScrollData data = (WarpScrollData)stack.getOrDefault((Supplier)DataComponentRegistry.WARP_SCROLL, (Object)new WarpScrollData(null, null, null, true));
            if (!data.isValid()) {
                return false;
            }
            String displayName = "Explorer's Warp Portal";
            if (((PortalBlock)BlockRegistry.PORTAL_BLOCK.get()).trySpawnPortal((Level)serverLevel, pos, data, displayName)) {
                ANCriteriaTriggers.rewardNearbyPlayers((PlayerTrigger)((PlayerTrigger)Triggers.FIND_RUINED_PORTAL.get()), (ServerLevel)serverLevel, (BlockPos)pos, (int)10);
                ANCriteriaTriggers.rewardNearbyPlayers((PlayerTrigger)((PlayerTrigger)Triggers.CREATE_RUINED_PORTAL.get()), (ServerLevel)serverLevel, (BlockPos)pos, (int)10);
                TeleportUtil.createTeleportDecoration(serverLevel, pos, stack);
                return true;
            }
        }
        return false;
    }

    public void inventoryTick(ItemStack stack, Level level, Entity entity, int slotId, boolean isSelected) {
        if (!(level instanceof ServerLevel)) {
            return;
        }
        ServerLevel serverLevel = (ServerLevel)level;
        if (LocateUtil.isPending(stack)) {
            LocateUtil.resolveUUID(serverLevel, entity.position(), stack, entity);
        }
    }

    public void appendHoverText(ItemStack stack, Item.TooltipContext context, List<Component> tooltipComponents, TooltipFlag tooltipFlag) {
        super.appendHoverText(stack, context, tooltipComponents, tooltipFlag);
        tooltipComponents.add((Component)Component.translatable((String)"tooltip.ars_additions.exploration_warp_scroll.desc"));
        if (LocateUtil.isPending(stack)) {
            tooltipComponents.add((Component)Component.translatable((String)"tooltip.ars_additions.exploration_warp_scroll.locating"));
        }
        if (tooltipFlag.hasShiftDown()) {
            tooltipComponents.add((Component)Component.translatable((String)"tooltip.ars_additions.exploration_warp_scroll.use", (Object[])new Object[]{Minecraft.getInstance().options.keyUse.getKey().getDisplayName()}));
        } else {
            tooltipComponents.add((Component)Component.translatable((String)"tooltip.ars_nouveau.hold_shift", (Object[])new Object[]{Minecraft.getInstance().options.keyShift.getKey().getDisplayName()}));
        }
    }

    public InteractionResultHolder<ItemStack> use(Level level, Player player, InteractionHand usedHand) {
        ItemStack stack = player.getItemInHand(usedHand);
        if (usedHand == InteractionHand.OFF_HAND) {
            return new InteractionResultHolder(InteractionResult.SUCCESS, (Object)stack);
        }
        if (!(level instanceof ServerLevel)) {
            return new InteractionResultHolder(InteractionResult.SUCCESS, (Object)stack);
        }
        ServerLevel serverLevel = (ServerLevel)level;
        WarpScrollData data = (WarpScrollData)stack.getOrDefault((Supplier)DataComponentRegistry.WARP_SCROLL, (Object)new WarpScrollData(null, null, null, true));
        if (LocateUtil.isPending(stack)) {
            PortUtil.sendMessageNoSpam((Entity)player, (Component)Component.translatable((String)"tooltip.ars_additions.exploration_warp_scroll.locating"));
            return new InteractionResultHolder(InteractionResult.SUCCESS, (Object)stack);
        }
        if (!data.isValid()) {
            PortUtil.sendMessageNoSpam((Entity)player, (Component)Component.translatable((String)"tooltip.ars_additions.exploration_warp_scroll.locating"));
            LocateUtil.locateFromStack(serverLevel, player.position(), stack);
            return new InteractionResultHolder(InteractionResult.SUCCESS, (Object)stack);
        }
        TeleportUtil.teleport(serverLevel, data, (Entity)player, stack);
        return InteractionResultHolder.pass((Object)stack);
    }
}

