/*
 * Decompiled with CFR 0.152.
 */
package com.github.jarva.arsadditions.common.item.data.mark;

import com.github.jarva.arsadditions.common.item.UnstableReliquary;
import com.github.jarva.arsadditions.common.item.data.mark.MarkData;
import com.github.jarva.arsadditions.setup.config.ServerConfig;
import com.github.jarva.arsadditions.setup.registry.AddonEffectRegistry;
import com.hollingsworth.arsnouveau.api.spell.CastResolveType;
import com.hollingsworth.arsnouveau.api.spell.SpellContext;
import com.hollingsworth.arsnouveau.api.spell.SpellResolver;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.List;
import java.util.Optional;
import java.util.UUID;
import net.minecraft.core.Holder;
import net.minecraft.core.UUIDUtil;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.ComponentSerialization;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;
import org.jetbrains.annotations.Nullable;

public record EntityMarkData(UUID uuid, Holder<EntityType<?>> entityType, Optional<Component> entityName) implements MarkData
{
    public static final MapCodec<EntityMarkData> CODEC = RecordCodecBuilder.mapCodec(inst -> inst.group((App)UUIDUtil.CODEC.fieldOf("entity_uuid").forGetter(EntityMarkData::uuid), (App)BuiltInRegistries.ENTITY_TYPE.holderByNameCodec().fieldOf("entity_type").forGetter(EntityMarkData::entityType), (App)ComponentSerialization.CODEC.optionalFieldOf("entity_name").forGetter(EntityMarkData::entityName)).apply((Applicative)inst, EntityMarkData::new));

    @Override
    public void inventoryTick(ItemStack stack, Level level, Entity entity, int slotId, boolean isSelected) {
        if (level instanceof ServerLevel) {
            ServerPlayer player;
            ServerLevel serverLevel = (ServerLevel)level;
            Entity found = serverLevel.getEntity(this.uuid);
            if (found == null || !found.isAlive()) {
                UnstableReliquary.breakReliquary(stack);
                return;
            }
            if (found instanceof ServerPlayer && !(player = (ServerPlayer)found).hasEffect(AddonEffectRegistry.MARKED_EFFECT)) {
                UnstableReliquary.breakReliquary(stack);
            }
        }
    }

    @Override
    public void appendHoverText(ItemStack stack, Item.TooltipContext context, List<Component> tooltipComponents, TooltipFlag tooltipFlag) {
        if (this.entityType.isBound()) {
            EntityType type = (EntityType)this.entityType.value();
            MutableComponent marked = Component.translatable((String)"tooltip.ars_additions.reliquary.marked", (Object[])new Object[]{Component.translatable((String)type.getDescriptionId())});
            if (this.entityName.isPresent()) {
                tooltipComponents.add((Component)Component.translatable((String)"tooltip.ars_additions.reliquary.marked.name", (Object[])new Object[]{marked, this.entityName.get()}));
            } else {
                tooltipComponents.add((Component)marked);
            }
        }
    }

    @Override
    public CastResolveType cast(SpellContext context, ItemStack reliquary, ServerLevel level, LivingEntity caster, SpellResolver resolver) {
        Entity found = level.getEntity(this.uuid);
        if (found == null) {
            UnstableReliquary.breakReliquary(reliquary);
            return CastResolveType.FAILURE;
        }
        resolver.onResolveEffect((Level)level, (HitResult)new EntityHitResult(found));
        UnstableReliquary.damage(this, reliquary, caster, found);
        return CastResolveType.SUCCESS;
    }

    @Override
    public int damageAmount(ItemStack stack, LivingEntity entity, @Nullable Entity target) {
        return target instanceof Player ? (Integer)ServerConfig.SERVER.reliquary_cost_player.get() : (Integer)ServerConfig.SERVER.reliquary_cost_entity.get();
    }

    @Override
    public MapCodec<? extends MarkData> codec() {
        return CODEC;
    }
}

