/*
 * Decompiled with CFR 0.152.
 */
package com.github.jarva.arsadditions.mixin.spellweave;

import com.github.jarva.arsadditions.datagen.EnchantmentDatagen;
import com.github.jarva.arsadditions.datagen.tags.ItemTagDatagen;
import com.hollingsworth.arsnouveau.setup.registry.DataComponentRegistry;
import java.util.function.Supplier;
import net.minecraft.core.Holder;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.Enchantment;
import net.neoforged.neoforge.common.CommonHooks;
import org.jetbrains.annotations.Nullable;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={Enchantment.class})
public abstract class EnchantmentMixin {
    @Inject(method={"isSupportedItem"}, at={@At(value="HEAD")}, cancellable=true)
    private void isSupportedItem(ItemStack item, CallbackInfoReturnable<Boolean> cir) {
        // Could not load outer class - annotation placement on inner may be incorrect
         @Nullable HolderLookup.RegistryLookup enchantmentRegistry = CommonHooks.resolveLookup((ResourceKey)Registries.ENCHANTMENT);
        if (enchantmentRegistry == null) {
            return;
        }
        Holder.Reference enchantment = enchantmentRegistry.get(EnchantmentDatagen.SPELLWEAVE_ENCHANTMENT).orElse(null);
        if (enchantment != null && ((Enchantment)enchantment.value()).equals((Object)this) && (item.has((Supplier)DataComponentRegistry.ARMOR_PERKS) || item.is(ItemTagDatagen.SPELLWEAVE_INCOMPATIBLE))) {
            cir.setReturnValue((Object)false);
        }
    }
}

