/*
 * Decompiled with CFR 0.152.
 */
package com.github.jarva.arsadditions.setup.config;

import java.util.HashMap;
import java.util.function.Function;
import net.neoforged.neoforge.common.ModConfigSpec;
import org.apache.commons.lang3.tuple.Pair;

public class ServerConfig {
    public final HashMap<String, ModConfigSpec.ConfigValue<?>> config = new HashMap();
    public final ModConfigSpec.IntValue chunkloading_cost;
    public final ModConfigSpec.BooleanValue chunkloading_has_cost;
    public final ModConfigSpec.BooleanValue chunkloading_repeat_cost;
    public final ModConfigSpec.IntValue chunkloading_cost_interval;
    public final ModConfigSpec.BooleanValue chunkloading_require_online;
    public final ModConfigSpec.IntValue chunkloading_initial_radius;
    public final ModConfigSpec.BooleanValue chunkloading_radius_incremental;
    public final ModConfigSpec.ConfigValue<String> chunkloading_radius_increment_item;
    public final ModConfigSpec.IntValue chunkloading_radius_increment_max;
    public final ModConfigSpec.IntValue chunkloading_player_limit;
    public final ModConfigSpec.BooleanValue chunkloading_log_loading;
    public final ModConfigSpec.IntValue reliquary_cost_player;
    public final ModConfigSpec.IntValue reliquary_cost_entity;
    public final ModConfigSpec.IntValue reliquary_cost_location;
    public final ModConfigSpec.IntValue reliquary_effect_duration;
    public final ModConfigSpec.IntValue locating_threads;
    public static final ServerConfig SERVER;
    public static final ModConfigSpec SERVER_SPEC;

    ServerConfig(ModConfigSpec.Builder builder) {
        builder.comment("Ritual of Arcane Permanence").push("chunkloading");
        this.chunkloading_has_cost = this.addConfig("has_cost", name -> builder.comment("Should the ritual cost source?").define(name, true));
        this.chunkloading_repeat_cost = this.addConfig("repeat_cost", name -> builder.comment("Should the ritual cost be continuous?").define(name, true));
        this.chunkloading_cost = this.addConfig("cost", name -> builder.comment("How much source should it cost to run the ritual?").defineInRange(name, 10000, 1, 10000));
        this.chunkloading_cost_interval = this.addConfig("interval", name -> builder.comment("How often should the ritual cost source? (in ticks, defaults to 1 in-game day)").defineInRange(name, 24000, 1, Integer.MAX_VALUE));
        this.chunkloading_initial_radius = this.addConfig("initial_radius", name -> builder.comment("How far should the ritual chunk-load? (in chunks, 0 = 1x1, 1 = 3x3, 2 = 5x5, 3 = 7x7, 4 = 9x9)").defineInRange(name, 0, 0, Integer.MAX_VALUE));
        this.chunkloading_radius_incremental = this.addConfig("radius_incremental", name -> builder.comment("Should the radius be able to be increased with an item?").define(name, false));
        this.chunkloading_radius_increment_item = this.addConfig("radius_increment_item", name -> builder.comment("What item is required to increase the chunk-loading radius?").define(name, (Object)"ars_nouveau:source_gem_block"));
        this.chunkloading_radius_increment_max = this.addConfig("radius_increment_max", name -> builder.comment("What's the maximum amount of augmented increases the ritual should accept?").defineInRange(name, 1, 1, Integer.MAX_VALUE));
        this.chunkloading_require_online = this.addConfig("require_online", name -> builder.comment("Should the ritual require the player who started it to be online?").define(name, true));
        this.chunkloading_player_limit = this.addConfig("max_rituals", name -> builder.comment("How many rituals should players be able to run?").defineInRange(name, Integer.MAX_VALUE, 1, Integer.MAX_VALUE));
        this.chunkloading_log_loading = this.addConfig("log_chunkloading", name -> builder.comment("Should the server log when a chunk is loaded/unloaded?").define(name, false));
        builder.pop();
        builder.comment("Ritual of Locate Structure").push("locator");
        this.locating_threads = this.addConfig("threads", name -> builder.worldRestart().comment(new String[]{"The maximum number of threads in the async locator thread pool.", "There's no upper bound to this, however this should only be increased if you're experiencing", "simultaneous location lookups causing issues AND you have the hardware capable of handling", "the extra possible threads.", "The default of 1 should be suitable for most users."}).defineInRange(name, 1, 1, Integer.MAX_VALUE));
        builder.pop();
        builder.comment("Reliquary").push("mark_and_recall");
        this.reliquary_cost_player = this.addConfig("cost_player", name -> builder.comment("How much durability should targeting a player with Recall cost?").defineInRange(name, 1000, 0, 1000));
        this.reliquary_cost_entity = this.addConfig("cost_entity", name -> builder.comment("How much durability should targeting an entity with Recall cost?").defineInRange(name, 250, 0, 1000));
        this.reliquary_cost_location = this.addConfig("cost_location", name -> builder.comment("How much durability should targeting a location with Recall cost?").defineInRange(name, 50, 0, 1000));
        this.reliquary_effect_duration = this.addConfig("effect_duration", name -> builder.comment("How long should the Marked effect last (in seconds) when Mark is cast on a player?").defineInRange(name, 300, 0, 900));
    }

    public <T extends ModConfigSpec.ConfigValue<?>> T addConfig(String name, Function<String, T> consumer) {
        ModConfigSpec.ConfigValue value = (ModConfigSpec.ConfigValue)consumer.apply(name);
        this.config.put(name, value);
        return (T)value;
    }

    static {
        Pair pair = new ModConfigSpec.Builder().configure(ServerConfig::new);
        SERVER_SPEC = (ModConfigSpec)pair.getRight();
        SERVER = (ServerConfig)pair.getLeft();
    }
}

