/*
 * Decompiled with CFR 0.152.
 */
package com.github.jarva.arsadditions.setup.registry;

import com.github.jarva.arsadditions.ArsAdditions;
import com.github.jarva.arsadditions.common.glyph.EffectMark;
import com.github.jarva.arsadditions.common.glyph.MethodRecall;
import com.github.jarva.arsadditions.datagen.Setup;
import com.github.jarva.arsadditions.setup.registry.AddonBlockRegistry;
import com.github.jarva.arsadditions.setup.registry.AddonItemRegistry;
import com.github.jarva.arsadditions.setup.registry.ArsNouveauRegistry;
import com.github.jarva.arsadditions.setup.registry.CharmRegistry;
import com.hollingsworth.arsnouveau.api.documentation.DocCategory;
import com.hollingsworth.arsnouveau.api.documentation.ReloadDocumentationEvent;
import com.hollingsworth.arsnouveau.api.documentation.builder.DocEntryBuilder;
import com.hollingsworth.arsnouveau.api.documentation.entry.DocEntry;
import com.hollingsworth.arsnouveau.api.documentation.entry.TextEntry;
import com.hollingsworth.arsnouveau.api.registry.DocumentationRegistry;
import com.hollingsworth.arsnouveau.api.registry.RitualRegistry;
import com.hollingsworth.arsnouveau.api.ritual.AbstractRitual;
import com.hollingsworth.arsnouveau.api.spell.AbstractSpellPart;
import com.hollingsworth.arsnouveau.api.spell.SpellSchool;
import com.hollingsworth.arsnouveau.api.spell.SpellTier;
import com.hollingsworth.arsnouveau.setup.registry.BlockRegistry;
import com.hollingsworth.arsnouveau.setup.registry.BlockRegistryWrapper;
import com.hollingsworth.arsnouveau.setup.registry.Documentation;
import com.hollingsworth.arsnouveau.setup.registry.ItemRegistryWrapper;
import com.hollingsworth.arsnouveau.setup.registry.ItemsRegistry;
import java.util.Comparator;
import java.util.Map;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;

@EventBusSubscriber(modid="ars_additions")
public class AddonDocumentation {
    @SubscribeEvent
    public static void addPages(ReloadDocumentationEvent.AddEntries event) {
        for (AbstractSpellPart glyph : ArsNouveauRegistry.GLYPHS) {
            DocEntry entry2 = AddonDocumentation.addPage(EntryBuilder.of(glyph).withName(Setup.root + ".glyph_name." + glyph.getRegistryName().getPath()).withIcon((ItemLike)glyph.glyphItem).withCraftingPages((ItemLike)glyph.glyphItem));
            entry2.withSearchTag((Component)Component.translatable((String)"ars_nouveau.keyword.glyph"));
            for (SpellSchool school : glyph.spellSchools) {
                entry2.withSearchTag(school.getTextComponent());
                for (SpellSchool subschool : school.getSubSchools()) {
                    entry2.withSearchTag(subschool.getTextComponent());
                }
            }
        }
        for (AbstractRitual ritual : ArsNouveauRegistry.RITUALS) {
            Item tablet = (Item)RitualRegistry.getRitualItemMap().get(ritual.getRegistryName());
            AddonDocumentation.addPage(EntryBuilder.of(ritual).withName(ritual.getLangName()).withIcon((ItemLike)tablet).withCraftingPages(Setup.root + ":tablet_" + ritual.getRegistryName().getPath(), (ItemLike)tablet));
        }
        DocCategory MACHINES = DocumentationRegistry.CRAFTING;
        DocCategory GETTING_STARTED = DocumentationRegistry.GETTING_STARTED;
        DocCategory SPELL_CASTING = DocumentationRegistry.SPELL_CASTING;
        DocCategory EQUIPMENT = DocumentationRegistry.ITEMS;
        DocCategory AUTOMATION = DocumentationRegistry.CRAFTING;
        DocCategory RESOURCES = DocumentationRegistry.FIELD_GUIDE;
        DocCategory STRUCTURES = DocumentationRegistry.FIELD_GUIDE;
        DocCategory SOURCE = DocumentationRegistry.SOURCE;
        DocCategory ARMOR = DocumentationRegistry.ARMOR;
        DocCategory RITUALS = DocumentationRegistry.RITUAL_INDEX;
        DocCategory ENCHANTMENTS = DocumentationRegistry.ENCHANTING;
        DocCategory FAMILIARS = DocumentationRegistry.FAMILIARS;
        DocCategory MOD_NEWS = DocumentationRegistry.GETTING_STARTED;
        AddonDocumentation.addPage(EntryBuilder.of(MACHINES, AddonItemRegistry.ADVANCED_LECTERN_REMOTE).withName("ars_additions.page.warp_indexes").withIcon(AddonItemRegistry.ADVANCED_LECTERN_REMOTE).withTextPage("ars_additions.page1.warp_indexes").withCraftingPages(AddonItemRegistry.LECTERN_REMOTE).withCraftingPages(AddonItemRegistry.ADVANCED_LECTERN_REMOTE)).withRelation(AddonDocumentation.block((BlockRegistryWrapper<? extends Block>)BlockRegistry.CRAFTING_LECTERN)).withRelation(AddonDocumentation.item((ItemRegistryWrapper<? extends Item>)ItemsRegistry.BOOKWYRM_CHARM));
        AddonDocumentation.addPage(EntryBuilder.of(STRUCTURES, (ItemLike)AddonBlockRegistry.getBlock("sourcestone_lantern")).withName("ars_additions.page.ruined_warp_portals").withIcon((ItemLike)AddonBlockRegistry.getBlock("sourcestone_lantern")).withTextPage("ars_additions.page1.ruined_warp_portals").withPage(TextEntry.create((Component)Component.empty(), (Component)Component.translatable((String)"item.ars_additions.exploration_warp_scroll"), AddonItemRegistry.EXPLORATION_WARP_SCROLL)).addConnectedSearch((ItemLike)AddonItemRegistry.EXPLORATION_WARP_SCROLL.get()));
        DocEntry nexusTower = AddonDocumentation.addPage(EntryBuilder.of(STRUCTURES, AddonBlockRegistry.WARP_NEXUS).withName("ars_additions.page.nexus_tower").withIcon(AddonBlockRegistry.WARP_NEXUS).withTextPage("ars_additions.page1.nexus_tower").withPage(TextEntry.create((Component)Component.translatable((String)"ars_additions.spotlight.warp_nexus"), (Component)Component.translatable((String)"block.ars_additions.warp_nexus"), AddonBlockRegistry.WARP_NEXUS))).withRelation(BuiltInRegistries.BLOCK.getKey((Object)((Block)AddonBlockRegistry.WARP_NEXUS.get())));
        AddonDocumentation.addPage(EntryBuilder.of(MACHINES, AddonBlockRegistry.WARP_NEXUS).withIcon((ItemLike)AddonBlockRegistry.WARP_NEXUS).withTextPage("ars_additions.page1.warp_nexus").withTextPage("ars_additions.page2.warp_nexus")).withRelation(nexusTower);
        AddonDocumentation.addPage(EntryBuilder.of(STRUCTURES, (BlockRegistryWrapper<? extends Block>)BlockRegistry.FLOURISHING_WOOD).withName("ars_nouveau.page.wilden_dens").withIcon((ItemLike)BlockRegistry.FLOURISHING_WOOD).withTextPage("ars_nouveau.page1.wilden_dens"));
        AddonDocumentation.addPage(EntryBuilder.of(EQUIPMENT, AddonItemRegistry.UNSTABLE_RELIQUARY).withIcon((ItemLike)AddonItemRegistry.UNSTABLE_RELIQUARY).withTextPage("ars_additions.page.unstable_reliquary")).withRelation(AddonDocumentation.glyph((AbstractSpellPart)EffectMark.INSTANCE)).withRelation(AddonDocumentation.glyph((AbstractSpellPart)MethodRecall.INSTANCE));
        AddonDocumentation.addPage(EntryBuilder.of(MACHINES, AddonBlockRegistry.ENDER_SOURCE_JAR).withIcon((ItemLike)AddonBlockRegistry.ENDER_SOURCE_JAR).withTextPage("ars_additions.page.ender_source_jar").withCraftingPages(AddonBlockRegistry.ENDER_SOURCE_JAR));
        AddonDocumentation.addPage(EntryBuilder.of(EQUIPMENT, AddonItemRegistry.XP_JAR).withIcon((ItemLike)AddonItemRegistry.XP_JAR).withTextPage("ars_additions.page.ender_source_jar").withCraftingPages(AddonItemRegistry.XP_JAR));
        AddonDocumentation.addPage(EntryBuilder.of(EQUIPMENT, AddonItemRegistry.HANDY_HAVERSACK).withIcon((ItemLike)AddonItemRegistry.HANDY_HAVERSACK).withTextPage("ars_additions.page.handy_haversack").withCraftingPages(AddonItemRegistry.HANDY_HAVERSACK));
        DocEntryBuilder charmBuilder = EntryBuilder.of(EQUIPMENT, AddonItemRegistry.CHARMS.get((Object)CharmRegistry.CharmType.FIRE_RESISTANCE)).withName("ars_additions.page.charms").withIcon((ItemLike)AddonItemRegistry.CHARMS.get((Object)CharmRegistry.CharmType.FIRE_RESISTANCE)).withTextPage("ars_additions.page1.charms");
        for (Map.Entry entry3 : AddonItemRegistry.CHARMS.entrySet().stream().sorted(Comparator.comparing(entry -> ((CharmRegistry.CharmType)((Object)((Object)entry.getKey()))).getName())).toList()) {
            CharmRegistry.CharmType charmType = (CharmRegistry.CharmType)((Object)entry3.getKey());
            Item charm = (Item)((ItemRegistryWrapper)entry3.getValue()).get();
            String name = "page.ars_additions." + charmType.getSerializedName() + ".title";
            String desc = "page.ars_additions." + charmType.getSerializedName() + ".desc";
            charmBuilder = charmBuilder.withPage(TextEntry.create((Component)Component.translatable((String)desc), (Component)Component.translatable((String)name), (ItemLike)charm)).withCraftingPages((ItemLike)charm);
        }
        AddonDocumentation.addPage(charmBuilder);
        AddonDocumentation.addPage(EntryBuilder.of(EQUIPMENT, AddonItemRegistry.IMBUED_SPELL_PARCHMENT).withIcon((ItemLike)AddonItemRegistry.IMBUED_SPELL_PARCHMENT).withTextPage("ars_additions.page.imbued_spell_parchment").withCraftingPages(AddonItemRegistry.IMBUED_SPELL_PARCHMENT));
        AddonDocumentation.addPage(EntryBuilder.of(STRUCTURES, (ItemLike)Blocks.BOOKSHELF).withName("ars_additions.page.arcane_library").withIcon((ItemLike)Blocks.BOOKSHELF).withTextPage("ars_additions.page1.arcane_library"));
    }

    @SubscribeEvent
    public static void editPages(ReloadDocumentationEvent.Post event) {
    }

    private static DocEntry block(BlockRegistryWrapper<? extends Block> block) {
        return DocumentationRegistry.getEntry((ResourceLocation)BuiltInRegistries.BLOCK.getKey((Object)((Block)block.get())));
    }

    private static DocEntry item(ItemRegistryWrapper<? extends Item> item) {
        return DocumentationRegistry.getEntry((ResourceLocation)BuiltInRegistries.ITEM.getKey((Object)((Item)item.get())));
    }

    private static DocEntry glyph(AbstractSpellPart item) {
        return DocumentationRegistry.getEntry((ResourceLocation)item.getRegistryName());
    }

    private static DocEntry addPage(DocEntryBuilder builder) {
        return DocumentationRegistry.registerEntry((DocCategory)builder.category, (DocEntry)builder.build());
    }

    static class EntryBuilder
    extends DocEntryBuilder {
        public static EntryBuilder of(DocCategory category, String name) {
            return EntryBuilder.of(category, name, ArsAdditions.prefix(name));
        }

        public static EntryBuilder of(DocCategory category, String name, ResourceLocation entryId) {
            return new EntryBuilder(category, (String)(name.contains(".") ? name : Setup.root + ".page." + name), entryId);
        }

        public static EntryBuilder of(DocCategory category, ItemRegistryWrapper<? extends Item> item) {
            return EntryBuilder.of(category, ((Item)item.get()).getDescriptionId());
        }

        public static EntryBuilder of(DocCategory category, ItemLike item) {
            return EntryBuilder.of(category, item.asItem().getDescriptionId());
        }

        public static EntryBuilder of(AbstractSpellPart glyph) {
            return EntryBuilder.of(Documentation.glyphCategory((SpellTier)glyph.getConfigTier()), glyph.getRegistryName().getPath());
        }

        public static EntryBuilder of(AbstractRitual glyph) {
            return EntryBuilder.of(DocumentationRegistry.RITUAL_INDEX, glyph.getRegistryName().getPath());
        }

        public static EntryBuilder of(DocCategory category, BlockRegistryWrapper<? extends Block> block) {
            return EntryBuilder.of(category, ((Block)block.get()).getDescriptionId());
        }

        private EntryBuilder(DocCategory category, String name, ResourceLocation entryId) {
            super(category, (String)(name.contains(".") ? name : Setup.root + ".page." + name), entryId);
        }

        private EntryBuilder(DocCategory category, ItemLike itemLike) {
            super(category, itemLike);
        }
    }
}

