/*
 * Decompiled with CFR 0.152.
 */
package com.hollingsworth.ars_creo.common.block;

import com.hollingsworth.ars_creo.common.block.StarbuncleWheelTile;
import com.hollingsworth.ars_creo.common.registry.ModBlockRegistry;
import com.simibubi.create.content.kinetics.base.DirectionalKineticBlock;
import com.simibubi.create.content.kinetics.base.GeneratingKineticBlockEntity;
import com.simibubi.create.content.kinetics.base.IRotate;
import com.simibubi.create.foundation.block.IBE;
import net.createmod.catnip.levelWrappers.WrappedLevel;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;

public class StarbuncleWheelBlock
extends DirectionalKineticBlock
implements IBE<StarbuncleWheelTile> {
    public StarbuncleWheelBlock(BlockBehaviour.Properties p_i48440_1_) {
        super(p_i48440_1_);
        this.registerDefaultState((BlockState)((BlockState)this.stateDefinition.any()).setValue((Property)FACING, (Comparable)Direction.NORTH));
    }

    public BlockState getStateForPlacement(BlockPlaceContext context) {
        Direction face = context.getClickedFace();
        Direction horizontalFacing = context.getHorizontalDirection();
        BlockPos pos = context.getClickedPos();
        Level world = context.getLevel();
        Player player = context.getPlayer();
        BlockState placedOn = world.getBlockState(pos.relative(face.getOpposite()));
        if (placedOn.is((Block)ModBlockRegistry.STARBY_WHEEL.get())) {
            return (BlockState)this.defaultBlockState().setValue((Property)FACING, (Comparable)((Direction)placedOn.getValue((Property)FACING)));
        }
        Direction facing = face;
        boolean sneaking = player != null && player.isShiftKeyDown();
        facing = horizontalFacing;
        return (BlockState)this.defaultBlockState().setValue((Property)FACING, (Comparable)(sneaking ? facing.getOpposite() : facing));
    }

    private void updateWheelSpeed(LevelAccessor world, BlockPos pos) {
        this.withBlockEntityDo((BlockGetter)world, pos, GeneratingKineticBlockEntity::updateGeneratedRotation);
        this.withBlockEntityDo((BlockGetter)world, pos, te -> te.setChanged());
    }

    public void updateAllSides(BlockState state, Level worldIn, BlockPos pos) {
        this.updateWheelSpeed((LevelAccessor)worldIn, pos);
    }

    public BlockState updateShape(BlockState stateIn, Direction facing, BlockState facingState, LevelAccessor worldIn, BlockPos currentPos, BlockPos facingPos) {
        if (worldIn instanceof WrappedLevel) {
            return stateIn;
        }
        this.updateWheelSpeed(worldIn, currentPos);
        return stateIn;
    }

    public void onPlace(BlockState state, Level worldIn, BlockPos pos, BlockState oldState, boolean isMoving) {
        super.onPlace(state, worldIn, pos, oldState, isMoving);
        this.updateAllSides(state, worldIn, pos);
    }

    public RenderShape getRenderShape(BlockState p_149645_1_) {
        return RenderShape.ENTITYBLOCK_ANIMATED;
    }

    public boolean hasShaftTowards(LevelReader world, BlockPos pos, BlockState state, Direction face) {
        return ((Direction)state.getValue((Property)FACING)).getAxis() == face.getAxis();
    }

    public Direction.Axis getRotationAxis(BlockState state) {
        return ((Direction)state.getValue((Property)FACING)).getAxis();
    }

    public float getParticleTargetRadius() {
        return 1.125f;
    }

    public float getParticleInitialRadius() {
        return 1.0f;
    }

    public IRotate.SpeedLevel getMinimumRequiredSpeedLevel() {
        return super.getMinimumRequiredSpeedLevel();
    }

    public boolean hideStressImpact() {
        return true;
    }

    public Class<StarbuncleWheelTile> getBlockEntityClass() {
        return StarbuncleWheelTile.class;
    }

    public BlockEntityType<? extends StarbuncleWheelTile> getBlockEntityType() {
        return (BlockEntityType)ModBlockRegistry.STARBY_TILE.get();
    }
}

