/*
 * Decompiled with CFR 0.152.
 */
package com.hollingsworth.arsnouveau.api.particle.configurations;

import com.hollingsworth.arsnouveau.api.particle.PropertyParticleOptions;
import com.hollingsworth.arsnouveau.api.particle.configurations.IParticleMotionType;
import com.hollingsworth.arsnouveau.api.particle.configurations.ParticleMotion;
import com.hollingsworth.arsnouveau.api.particle.configurations.properties.BaseProperty;
import com.hollingsworth.arsnouveau.api.particle.configurations.properties.ParticleDensityProperty;
import com.hollingsworth.arsnouveau.api.particle.configurations.properties.ParticleTypeProperty;
import com.hollingsworth.arsnouveau.api.particle.configurations.properties.PropMap;
import com.hollingsworth.arsnouveau.api.registry.ParticleMotionRegistry;
import com.hollingsworth.arsnouveau.client.particle.ParticleUtil;
import com.mojang.serialization.MapCodec;
import java.util.List;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import org.joml.Vector3f;

public class ZigZagMotion
extends ParticleMotion {
    public static MapCodec<ZigZagMotion> CODEC = ZigZagMotion.buildPropCodec(ZigZagMotion::new);
    public static StreamCodec<RegistryFriendlyByteBuf, ZigZagMotion> STREAM = ZigZagMotion.buildStreamCodec(ZigZagMotion::new);

    public ZigZagMotion(PropMap propMap) {
        super(propMap);
    }

    @Override
    public void tick(PropertyParticleOptions particleOptions, Level level, double x, double y, double z, double prevX, double prevY, double prevZ) {
        int age = this.emitter.age;
        if (age == 0) {
            return;
        }
        ParticleDensityProperty density = this.getDensity(particleOptions, 100, 0.3f);
        int totalParticles = this.getNumParticles(density.density());
        float randomScale = 0.0f;
        double radius = density.radius();
        for (int step = 0; step <= totalParticles; ++step) {
            double t = (double)step / (double)totalParticles;
            double interpolatedX = prevX + t * (x - prevX);
            double interpolatedY = prevY + t * (y - prevY);
            double interpolatedZ = prevZ + t * (z - prevZ);
            double motionProgress = (double)age + t;
            Vec3 local = this.getZigzag3D(motionProgress, 8.0, radius, 12.0, radius - radius * 0.3, 0.1);
            Vector3f transformed = this.toEmitterSpace((float)interpolatedX, (float)interpolatedY, (float)interpolatedZ, (float)local.x(), (float)local.y(), (float)local.z);
            level.addParticle((ParticleOptions)particleOptions, (double)transformed.x, (double)transformed.y, (double)transformed.z, ParticleUtil.inRange(-randomScale, randomScale), ParticleUtil.inRange(-randomScale, randomScale), ParticleUtil.inRange(-randomScale, randomScale));
        }
    }

    public Vec3 getZigzag3D(double age, double freqXZ, double ampXZ, double freqY, double ampY, double forwardSpeed) {
        double t = age * forwardSpeed;
        double offsetX = Math.sin(t * freqXZ) * ampXZ;
        double offsetY = Math.sin(t * freqY) * ampY;
        return new Vec3(offsetX, offsetY, 0.0);
    }

    @Override
    public IParticleMotionType<?> getType() {
        return (IParticleMotionType)ParticleMotionRegistry.ZIGZAG_TYPE.get();
    }

    @Override
    public List<BaseProperty<?>> getProperties(PropMap propMap) {
        return List.of(propMap.createIfMissing(new ParticleTypeProperty()), propMap.createIfMissing(new ParticleDensityProperty(100, (double)0.3f, ParticleMotion.SpawnType.SPHERE).maxDensity(200).minDensity(20).densityStepSize(5).supportsShapes(false).supportsRadius(true)));
    }
}

