/*
 * Decompiled with CFR 0.152.
 */
package com.hollingsworth.arsnouveau.api.particle.configurations.properties;

import com.hollingsworth.arsnouveau.api.documentation.DocAssets;
import com.hollingsworth.arsnouveau.api.documentation.DocClientUtils;
import com.hollingsworth.arsnouveau.api.particle.configurations.ParticleConfigWidgetProvider;
import com.hollingsworth.arsnouveau.api.particle.configurations.properties.BaseProperty;
import com.hollingsworth.arsnouveau.api.particle.configurations.properties.IPropertyType;
import com.hollingsworth.arsnouveau.api.registry.ParticlePropertyRegistry;
import com.hollingsworth.arsnouveau.client.gui.HorizontalSlider;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.List;
import java.util.Objects;
import java.util.function.Consumer;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;

public class SpeedProperty
extends BaseProperty<SpeedProperty> {
    public static MapCodec<SpeedProperty> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)Codec.DOUBLE.fieldOf("yMinSpeed").forGetter(i -> i.yMinSpeed), (App)Codec.DOUBLE.fieldOf("yMaxSpeed").forGetter(i -> i.yMaxSpeed), (App)Codec.DOUBLE.fieldOf("xzMinSpeed").forGetter(i -> i.xzMinSpeed), (App)Codec.DOUBLE.fieldOf("xzMaxSpeed").forGetter(i -> i.xzMaxSpeed)).apply((Applicative)instance, SpeedProperty::new));
    public static StreamCodec<RegistryFriendlyByteBuf, SpeedProperty> STREAM_CODEC = StreamCodec.composite((StreamCodec)ByteBufCodecs.DOUBLE, SpeedProperty::minY, (StreamCodec)ByteBufCodecs.DOUBLE, SpeedProperty::maxY, (StreamCodec)ByteBufCodecs.DOUBLE, SpeedProperty::minXZ, (StreamCodec)ByteBufCodecs.DOUBLE, SpeedProperty::maxXZ, SpeedProperty::new);
    private double yMinSpeed = 0.0;
    private double xzMinSpeed = 0.0;
    private double yMaxSpeed = 0.0;
    private double xzMaxSpeed = 0.0;

    public SpeedProperty() {
    }

    public SpeedProperty(double yMinSpeed, double yMaxSpeed, double minXZ, double xzMaxSpeed) {
        this.yMinSpeed = yMinSpeed;
        this.xzMinSpeed = minXZ;
        this.yMaxSpeed = yMaxSpeed;
        this.xzMaxSpeed = xzMaxSpeed;
    }

    public SpeedProperty yRange(double yMinSpeed, double yMaxSpeed) {
        this.yMinSpeed = yMinSpeed;
        this.yMaxSpeed = yMaxSpeed;
        return this;
    }

    public SpeedProperty xzRange(double xzMinSpeed, double xzMaxSpeed) {
        this.xzMinSpeed = xzMinSpeed;
        this.xzMaxSpeed = xzMaxSpeed;
        return this;
    }

    public double minY() {
        return this.yMinSpeed;
    }

    public double minXZ() {
        return this.xzMinSpeed;
    }

    public double maxY() {
        return this.yMaxSpeed;
    }

    public double maxXZ() {
        return this.xzMaxSpeed;
    }

    @Override
    public ParticleConfigWidgetProvider buildWidgets(int x, int y, int width, int height) {
        return new ParticleConfigWidgetProvider(x, y, width, height){
            HorizontalSlider minYSpeedSlider;
            HorizontalSlider yMaxSpeedSlider;
            HorizontalSlider xzMaxSpeedSlider;

            @Override
            public void render(GuiGraphics graphics, int mouseX, int mouseY, float partialTicks) {
                DocClientUtils.drawHeader(SpeedProperty.this.getName(), graphics, this.x, this.y, this.width, mouseX, mouseY, partialTicks);
                int yOffset = 20;
                int sliderSpacing = 25;
                DocClientUtils.drawHeaderNoUnderline((Component)Component.translatable((String)"ars_nouveau.yspeed_slider", (Object[])new Object[]{this.minYSpeedSlider.getValueString()}), graphics, this.x, this.y + yOffset, this.width, mouseX, mouseY, partialTicks);
                DocClientUtils.drawHeaderNoUnderline((Component)Component.translatable((String)"ars_nouveau.ymaxspeed_slider", (Object[])new Object[]{this.yMaxSpeedSlider.getValueString()}), graphics, this.x, this.y + (yOffset += sliderSpacing), this.width, mouseX, mouseY, partialTicks);
                DocClientUtils.drawHeaderNoUnderline((Component)Component.translatable((String)"ars_nouveau.xzmaxspeed_slider", (Object[])new Object[]{this.xzMaxSpeedSlider.getValueString()}), graphics, this.x, this.y + (yOffset += sliderSpacing), this.width, mouseX, mouseY, partialTicks);
            }

            @Override
            public void addWidgets(List<AbstractWidget> widgets) {
                int yOffset = 30;
                int xSliderOffset = this.x + 4;
                int sliderSpacing = 25;
                double min = -0.2;
                double max = 0.2;
                double stepSize = 0.02;
                this.minYSpeedSlider = this.buildSlider(xSliderOffset, this.y + (yOffset += 4), min, max, stepSize, 1, (Component)Component.translatable((String)"ars_nouveau.yspeed_slider"), (Component)Component.empty(), 0.0, value -> {
                    SpeedProperty.this.yMinSpeed = this.minYSpeedSlider.getValue();
                    SpeedProperty.this.yMaxSpeed = Math.max(SpeedProperty.this.yMaxSpeed, SpeedProperty.this.yMinSpeed);
                    this.clampSliders();
                });
                this.yMaxSpeedSlider = this.buildSlider(xSliderOffset, this.y + (yOffset += sliderSpacing), min, max, stepSize, 1, (Component)Component.translatable((String)"ars_nouveau.ymaxspeed_slider"), (Component)Component.empty(), 0.0, value -> {
                    SpeedProperty.this.yMaxSpeed = this.yMaxSpeedSlider.getValue();
                    SpeedProperty.this.yMinSpeed = Math.min(SpeedProperty.this.yMaxSpeed, SpeedProperty.this.yMinSpeed);
                    this.clampSliders();
                });
                this.xzMaxSpeedSlider = this.buildSlider(xSliderOffset, this.y + (yOffset += sliderSpacing), 0.0, max, stepSize, 1, (Component)Component.translatable((String)"ars_nouveau.xzmaxspeed_slider"), (Component)Component.empty(), 0.0, value -> {
                    SpeedProperty.this.xzMaxSpeed = this.xzMaxSpeedSlider.getValue();
                    SpeedProperty.this.xzMinSpeed = -this.xzMaxSpeedSlider.getValue();
                    this.clampSliders();
                });
                this.clampSliders();
                widgets.add((AbstractWidget)this.minYSpeedSlider);
                widgets.add((AbstractWidget)this.yMaxSpeedSlider);
                widgets.add((AbstractWidget)this.xzMaxSpeedSlider);
            }

            private void clampSliders() {
                this.yMaxSpeedSlider.setValue(SpeedProperty.this.yMaxSpeed);
                this.minYSpeedSlider.setValue(SpeedProperty.this.yMinSpeed);
                this.xzMaxSpeedSlider.setValue(SpeedProperty.this.xzMaxSpeed);
            }

            public HorizontalSlider buildSlider(int x, int y, double min, double max, double stepSize, int precision, Component prefix, Component suffix, double currentVal, Consumer<Double> onValueChange) {
                return new HorizontalSlider(x, y, DocAssets.SLIDER_BAR_FILLED, DocAssets.SLIDER, prefix, suffix, min, max, currentVal, stepSize, precision, false, onValueChange);
            }

            @Override
            public void renderIcon(GuiGraphics graphics, int x, int y, int mouseX, int mouseY, float partialTicks) {
                DocClientUtils.blit(graphics, DocAssets.SPEED_ICON, x, y);
            }

            @Override
            public Component getButtonTitle() {
                return SpeedProperty.this.getName();
            }

            @Override
            public void getButtonTooltips(List<Component> tooltip) {
                super.getButtonTooltips(tooltip);
                tooltip.add((Component)Component.translatable((String)"ars_nouveau.speed_tooltip"));
            }
        };
    }

    @Override
    public IPropertyType<SpeedProperty> getType() {
        return (IPropertyType)ParticlePropertyRegistry.SPEED_PROPERTY.get();
    }

    public boolean equals(Object o) {
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SpeedProperty that = (SpeedProperty)o;
        return Double.compare(that.yMinSpeed, this.yMinSpeed) == 0 && Double.compare(that.xzMinSpeed, this.xzMinSpeed) == 0 && Double.compare(that.yMaxSpeed, this.yMaxSpeed) == 0 && Double.compare(that.xzMaxSpeed, this.xzMaxSpeed) == 0;
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.yMinSpeed, this.xzMinSpeed, this.yMaxSpeed, this.xzMaxSpeed);
    }

    @Override
    public boolean survivesMotionChange() {
        return false;
    }
}

