/*
 * Decompiled with CFR 0.152.
 */
package com.hollingsworth.arsnouveau.client.gui.book;

import com.hollingsworth.arsnouveau.ArsNouveau;
import com.hollingsworth.arsnouveau.api.documentation.DocAssets;
import com.hollingsworth.arsnouveau.api.spell.AbstractAugment;
import com.hollingsworth.arsnouveau.api.spell.AbstractCastMethod;
import com.hollingsworth.arsnouveau.api.spell.AbstractEffect;
import com.hollingsworth.arsnouveau.api.spell.AbstractFilter;
import com.hollingsworth.arsnouveau.api.spell.AbstractSpellPart;
import com.hollingsworth.arsnouveau.api.spell.IFilter;
import com.hollingsworth.arsnouveau.client.gui.buttons.ANButton;
import com.hollingsworth.arsnouveau.client.gui.buttons.GlyphButton;
import com.hollingsworth.arsnouveau.client.gui.buttons.GuiImageButton;
import java.lang.runtime.SwitchBootstraps;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.function.Consumer;
import java.util.function.Predicate;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.components.Button;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;

public class GlyphFormatter {
    int perRow = 7;
    int maxRows = 7;
    int bookLeft;
    int bookTop;
    Button.OnPress onGlyphClick;
    public List<GlyphButton> glyphButtons = new ArrayList<GlyphButton>();
    List<AbstractWidget> addedWidgets = new ArrayList<AbstractWidget>();
    Consumer<List<? extends AbstractWidget>> clearButtons;
    Consumer<AbstractWidget> addRenderableWidget;
    List<ANButton> sortedWidgets = new ArrayList<ANButton>();
    public static List<Category> CATEGORIES = new ArrayList<Category>();
    Set<ResourceLocation> addedCategories = new HashSet<ResourceLocation>();

    public GlyphFormatter(int bookLeft, int bookTop, Button.OnPress onGlyphClick, Consumer<List<? extends AbstractWidget>> clearButtons, Consumer<AbstractWidget> addRenderableWidget) {
        this.bookLeft = bookLeft;
        this.bookTop = bookTop;
        this.onGlyphClick = onGlyphClick;
        this.clearButtons = clearButtons;
        this.addRenderableWidget = addRenderableWidget;
    }

    private void buildSortedWidgets(List<AbstractSpellPart> displayedGlyphs) {
        ArrayList<AbstractSpellPart> sorted = new ArrayList<AbstractSpellPart>(displayedGlyphs);
        sorted.sort(Comparator.comparingInt(p -> {
            AbstractSpellPart abstractSpellPart = p;
            Objects.requireNonNull(abstractSpellPart);
            AbstractSpellPart selector0$temp = abstractSpellPart;
            int index$1 = 0;
            return switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{AbstractAugment.class}, (Object)selector0$temp, index$1)) {
                case 0 -> {
                    AbstractAugment ignored = (AbstractAugment)selector0$temp;
                    yield 3;
                }
                default -> p.getTypeIndex();
            };
        }).thenComparing(AbstractSpellPart::getLocaleName));
        ArrayList<ANButton> buttons = new ArrayList<ANButton>();
        this.addedCategories = new HashSet<ResourceLocation>();
        for (AbstractSpellPart abstractSpellPart : sorted) {
            for (Category category : CATEGORIES) {
                if (this.addedCategories.contains(category.id) || !category.filter.test(abstractSpellPart)) continue;
                this.addedCategories.add(category.id);
                buttons.add(new GuiImageButton(0, 0, category.blitInfo(), b -> {}).withTooltip(category.tooltip));
            }
            buttons.add(new GlyphButton(0, 0, abstractSpellPart, this.onGlyphClick));
        }
        this.sortedWidgets = new ArrayList<ANButton>(buttons);
    }

    public void layoutAllGlyphs(int page, List<AbstractSpellPart> displayedGlyphs) {
        List<ANButton> buttons;
        this.clearButtons.accept(this.addedWidgets);
        int fromIndex = 84 * page;
        if (page == 0) {
            this.buildSortedWidgets(displayedGlyphs);
        }
        if (fromIndex < (buttons = new ArrayList<ANButton>(this.sortedWidgets)).size()) {
            buttons = buttons.subList(fromIndex, buttons.size());
        }
        int count = 0;
        for (ANButton part : buttons) {
            if (count > 84) break;
            if (count != 0 && !(part instanceof GlyphButton) && count % this.perRow != 0) {
                count += this.perRow - count % this.perRow;
            }
            boolean isNextPage = count >= this.perRow * this.maxRows;
            int numRows = count / this.perRow;
            if (isNextPage) {
                numRows = (count - this.perRow * this.maxRows) / this.perRow;
            }
            part.x = this.bookLeft + 16 + (isNextPage ? 134 : 0) + count % this.perRow * 18;
            part.y = numRows * 18 + this.bookTop + 18;
            this.addRenderableWidget.accept((AbstractWidget)part);
            if (part instanceof GlyphButton) {
                GlyphButton glyphButton = (GlyphButton)part;
                this.glyphButtons.add(glyphButton);
            }
            this.addedWidgets.add((AbstractWidget)part);
            ++count;
        }
    }

    static {
        CATEGORIES.add(new Category(ArsNouveau.prefix("form"), p -> p instanceof AbstractCastMethod, (Component)Component.translatable((String)"ars_nouveau.form_icon_tooltip"), DocAssets.FORM_ICON_CRAFTING));
        CATEGORIES.add(new Category(ArsNouveau.prefix("effect"), p -> p instanceof AbstractEffect && !(p instanceof AbstractFilter), (Component)Component.translatable((String)"ars_nouveau.effect_icon_tooltip"), DocAssets.EFFECT_ICON_CRAFTING));
        CATEGORIES.add(new Category(ArsNouveau.prefix("augment"), p -> p instanceof AbstractAugment, (Component)Component.translatable((String)"ars_nouveau.augment_icon_tooltip"), DocAssets.AUGMENT_ICON_CRAFTING));
        CATEGORIES.add(new Category(ArsNouveau.prefix("filter"), p -> p instanceof IFilter, (Component)Component.translatable((String)"ars_nouveau.augment_icon_tooltip"), DocAssets.FILTER_ICON_CRAFTING));
    }

    public record Category(ResourceLocation id, Predicate<AbstractSpellPart> filter, Component tooltip, DocAssets.BlitInfo blitInfo) {
        @Override
        public boolean equals(Object o) {
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Category category = (Category)o;
            return Objects.equals(this.id, category.id);
        }

        @Override
        public int hashCode() {
            return Objects.hashCode(this.id);
        }
    }
}

