/*
 * Decompiled with CFR 0.152.
 */
package com.hollingsworth.arsnouveau.client.jei;

import com.hollingsworth.arsnouveau.api.registry.AlakarkinosConversionRegistry;
import com.hollingsworth.arsnouveau.client.jei.JEIArsNouveauPlugin;
import com.hollingsworth.arsnouveau.common.crafting.recipes.AlakarkinosRecipe;
import com.hollingsworth.arsnouveau.setup.registry.ItemsRegistry;
import java.text.DecimalFormat;
import java.util.Locale;
import java.util.Optional;
import mezz.jei.api.constants.VanillaTypes;
import mezz.jei.api.gui.builder.IRecipeLayoutBuilder;
import mezz.jei.api.gui.builder.IRecipeSlotBuilder;
import mezz.jei.api.gui.drawable.IDrawable;
import mezz.jei.api.gui.ingredient.IRecipeSlotsView;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.ingredients.IIngredientType;
import mezz.jei.api.recipe.IFocusGroup;
import mezz.jei.api.recipe.RecipeIngredientRole;
import mezz.jei.api.recipe.RecipeType;
import mezz.jei.api.recipe.category.IRecipeCategory;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.world.item.crafting.RecipeHolder;
import org.apache.commons.lang3.text.WordUtils;

public class AlakarkinosRecipeCategory
implements IRecipeCategory<RecipeHolder<AlakarkinosRecipe>> {
    public static float ITEMS_PER_ROW = 7.0f;
    public IDrawable background;
    public IDrawable icon;

    public AlakarkinosRecipeCategory(IGuiHelper helper) {
        this.background = helper.createBlankDrawable(126, 140);
        this.icon = helper.createDrawableIngredient((IIngredientType)VanillaTypes.ITEM_STACK, (Object)ItemsRegistry.ALAKARKINOS_CHARM.asItem().getDefaultInstance());
    }

    public RecipeType<RecipeHolder<AlakarkinosRecipe>> getRecipeType() {
        return JEIArsNouveauPlugin.ALAKARKINOS_RECIPE_TYPE.get();
    }

    public Component getTitle() {
        return Component.translatable((String)"ars_nouveau.alakarkinos_recipe");
    }

    public IDrawable getBackground() {
        return this.background;
    }

    public IDrawable getIcon() {
        return this.icon;
    }

    public void draw(RecipeHolder<AlakarkinosRecipe> recipeHolder, IRecipeSlotsView recipeSlotsView, GuiGraphics guiGraphics, double mouseX, double mouseY) {
        AlakarkinosRecipe recipe = (AlakarkinosRecipe)recipeHolder.value();
        Minecraft minecraft = Minecraft.getInstance();
        String prepared = recipe.table().location().getPath().replace("archaeology/", "").replaceAll("_[0-9]", "").replaceAll("_", " ").toLowerCase(Locale.ROOT);
        String name = WordUtils.capitalizeFully((String)prepared);
        guiGraphics.drawString(minecraft.font, (Component)Component.literal((String)name), 22, 4, -16777216, false);
    }

    public void setRecipe(IRecipeLayoutBuilder builder, RecipeHolder<AlakarkinosRecipe> recipeHolder, IFocusGroup focuses) {
        AlakarkinosRecipe recipe = (AlakarkinosRecipe)recipeHolder.value();
        DecimalFormat df = new DecimalFormat("##.##%");
        Optional<AlakarkinosConversionRegistry.LootDrops> lootDrops = recipe.drops();
        if (lootDrops.isEmpty()) {
            return;
        }
        AlakarkinosConversionRegistry.LootDrops drops = lootDrops.get();
        String recipeChance = df.format((float)recipe.weight() / (float)drops.weight());
        ((IRecipeSlotBuilder)builder.addSlot(RecipeIngredientRole.INPUT, 0, 0).addIngredient((IIngredientType)VanillaTypes.ITEM_STACK, (Object)recipe.input().asItem().getDefaultInstance())).addRichTooltipCallback((view, tooltip) -> tooltip.add((FormattedText)Component.translatable((String)"ars_nouveau.alakarkinos_recipe.chance", (Object[])new Object[]{recipeChance})));
        int yOffset = 9;
        int i = (int)ITEMS_PER_ROW;
        for (AlakarkinosConversionRegistry.LootDrop drop : drops.list()) {
            int row = (int)Math.floor((float)i / ITEMS_PER_ROW);
            int x = (int)(((float)i - (float)row * ITEMS_PER_ROW) * 18.0f);
            int y = row * 18 + yOffset;
            String chance = df.format(drop.chance());
            ((IRecipeSlotBuilder)builder.addSlot(RecipeIngredientRole.OUTPUT, x, y).addItemStack(drop.item())).addRichTooltipCallback((view, tooltip) -> tooltip.add((FormattedText)Component.translatable((String)"ars_nouveau.alakarkinos_recipe.chance", (Object[])new Object[]{chance})));
            ++i;
        }
    }
}

