/*
 * Decompiled with CFR 0.152.
 */
package com.hollingsworth.arsnouveau.common.block.tile;

import com.hollingsworth.arsnouveau.api.client.ITooltipProvider;
import com.hollingsworth.arsnouveau.api.util.NBTUtil;
import com.hollingsworth.arsnouveau.common.block.ITickable;
import com.hollingsworth.arsnouveau.common.block.PortalBlock;
import com.hollingsworth.arsnouveau.common.block.tile.ModdedTile;
import com.hollingsworth.arsnouveau.common.entity.EntityFollowProjectile;
import com.hollingsworth.arsnouveau.common.items.data.WarpScrollData;
import com.hollingsworth.arsnouveau.common.network.Networking;
import com.hollingsworth.arsnouveau.common.network.PacketWarpPosition;
import com.hollingsworth.arsnouveau.setup.registry.BlockRegistry;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.network.protocol.game.ClientboundMoveVehiclePacket;
import net.minecraft.network.protocol.game.ClientboundSetPassengersPacket;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerChunkCache;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.level.portal.DimensionTransition;
import net.minecraft.world.phys.Vec2;
import net.minecraft.world.phys.Vec3;
import net.neoforged.neoforge.common.util.FakePlayer;

public class PortalTile
extends ModdedTile
implements ITickable,
ITooltipProvider {
    public BlockPos warpPos;
    public String dimID;
    public Vec2 rotationVec;
    @Nullable
    public String displayName;
    public boolean isHorizontal;
    public Set<Entity> entityQueue = new HashSet<Entity>();

    public PortalTile(BlockPos pos, BlockState state) {
        super(BlockRegistry.PORTAL_TILE_TYPE, pos, state);
    }

    public void warp(Entity e) {
        Level level = this.level;
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            if (this.warpPos != null && this.dimID != null && PortalTile.teleportEntityTo(e, (Level)PortalTile.getServerLevel(this.dimID, serverLevel), this.warpPos, this.rotationVec) != null) {
                ServerLevel serverWorld = PortalTile.getServerLevel(this.dimID, serverLevel);
                if (serverWorld == null) {
                    return;
                }
                Vec3 vec3 = e.position;
                Networking.sendToNearbyClient((Level)serverWorld, e, (CustomPacketPayload)new PacketWarpPosition(e.getId(), e.getX() + 0.5, e.getY(), e.getZ() + 0.5, this.rotationVec.x, this.rotationVec.y));
                serverLevel.sendParticles((ParticleOptions)ParticleTypes.PORTAL, (double)this.warpPos.getX(), (double)(this.warpPos.getY() + 1), (double)this.warpPos.getZ(), 4, (serverWorld.random.nextDouble() - 0.5) * 2.0, -serverWorld.random.nextDouble(), (serverWorld.random.nextDouble() - 0.5) * 2.0, (double)0.1f);
                e.placePortalTicket(this.warpPos);
                e.level().gameEvent((Holder)GameEvent.TELEPORT, vec3, GameEvent.Context.of((Entity)e));
            }
        }
    }

    public void setFromScroll(WarpScrollData scrollData) {
        this.warpPos = scrollData.pos().orElse(null);
        this.dimID = scrollData.dimension();
        this.rotationVec = scrollData.rotation();
    }

    protected void loadAdditional(CompoundTag compound, HolderLookup.Provider pRegistries) {
        super.loadAdditional(compound, pRegistries);
        this.dimID = compound.getString("dim");
        this.warpPos = NBTUtil.getBlockPos(compound, "warp");
        this.rotationVec = new Vec2(compound.getFloat("xRot"), compound.getFloat("yRot"));
        this.displayName = compound.getString("display");
        this.isHorizontal = compound.getBoolean("horizontal");
    }

    public void saveAdditional(CompoundTag compound, HolderLookup.Provider pRegistries) {
        super.saveAdditional(compound, pRegistries);
        if (this.warpPos != null) {
            NBTUtil.storeBlockPos(compound, "warp", this.warpPos);
        }
        if (this.dimID != null) {
            compound.putString("dim", this.dimID);
        }
        if (this.rotationVec != null) {
            compound.putFloat("xRot", this.rotationVec.x);
            compound.putFloat("yRot", this.rotationVec.y);
        }
        if (this.displayName != null) {
            compound.putString("display", this.displayName);
        }
        compound.putBoolean("horizontal", this.isHorizontal);
    }

    @Override
    public void tick() {
        Level level;
        if (this.level != null && (level = this.level) instanceof ServerLevel) {
            Set<Entity> entities;
            ServerLevel serverLevel = (ServerLevel)level;
            if (this.warpPos != null && !(entities = this.entityQueue).isEmpty()) {
                for (Entity e : entities) {
                    if (e instanceof EntityFollowProjectile || this.dimID == null || PortalTile.teleportEntityTo(e, (Level)PortalTile.getServerLevel(this.dimID, serverLevel), this.warpPos, this.rotationVec) == null) continue;
                    this.level.playSound(null, this.warpPos, SoundEvents.ILLUSIONER_MIRROR_MOVE, SoundSource.NEUTRAL, 1.0f, 1.0f);
                    serverLevel.sendParticles((ParticleOptions)ParticleTypes.PORTAL, (double)this.warpPos.getX(), (double)(this.warpPos.getY() + 1), (double)this.warpPos.getZ(), 4, (this.level.random.nextDouble() - 0.5) * 2.0, -this.level.random.nextDouble(), (this.level.random.nextDouble() - 0.5) * 2.0, (double)0.1f);
                }
                this.entityQueue.clear();
            }
        }
    }

    @Nullable
    public static ServerLevel getServerLevel(String dimID, ServerLevel level) {
        if (dimID != null && level != null) {
            ResourceKey resourcekey = ResourceKey.create((ResourceKey)Registries.DIMENSION, (ResourceLocation)ResourceLocation.tryParse((String)dimID));
            return level.getServer().getLevel(resourcekey);
        }
        return null;
    }

    @Nullable
    public static Entity teleportEntityTo(Entity entity, @Nullable Level targetWorld, BlockPos target, Vec2 rotationVec) {
        if (targetWorld == null) {
            return entity;
        }
        if (entity.getCommandSenderWorld().dimension() == targetWorld.dimension()) {
            if (targetWorld.getBlockState(target).getBlock() instanceof PortalBlock) {
                return entity;
            }
            float rotX = rotationVec != null ? rotationVec.x : entity.getXRot();
            float rotY = rotationVec != null ? rotationVec.y : entity.getYRot();
            Networking.sendToNearbyClient(targetWorld, entity, (CustomPacketPayload)new PacketWarpPosition(entity.getId(), (double)target.getX() + 0.5, target.getY(), (double)target.getZ() + 0.5, rotX, rotY));
            entity.teleportTo((double)target.getX() + 0.5, (double)target.getY(), (double)target.getZ() + 0.5);
            entity.setXRot(rotX);
            entity.setYRot(rotY);
            if (!entity.getPassengers().isEmpty()) {
                ((ServerChunkCache)entity.getCommandSenderWorld().getChunkSource()).broadcast(entity, (Packet)new ClientboundSetPassengersPacket(entity));
                LivingEntity controller = entity.getControllingPassenger();
                if (controller != entity && controller instanceof ServerPlayer) {
                    ServerPlayer player = (ServerPlayer)controller;
                    if (!(controller instanceof FakePlayer) && player.connection != null) {
                        player.connection.send((Packet)new ClientboundMoveVehiclePacket(entity));
                    }
                }
            }
            return entity;
        }
        Vec3 destination = new Vec3((double)target.getX() + 0.5, (double)target.getY(), (double)target.getZ() + 0.5);
        List passengers = entity.getPassengers();
        return entity.changeDimension(new DimensionTransition((ServerLevel)targetWorld, destination, new Vec3(0.0, 0.0, 0.0), rotationVec.y, rotationVec.x, false, DimensionTransition.DO_NOTHING));
    }

    @Override
    public void getTooltip(List<Component> tooltip) {
        if (this.displayName != null) {
            tooltip.add((Component)Component.literal((String)this.displayName));
        }
    }
}

