/*
 * Decompiled with CFR 0.152.
 */
package com.hollingsworth.arsnouveau.common.block.tile;

import com.hollingsworth.arsnouveau.common.block.ITickable;
import com.hollingsworth.arsnouveau.common.block.tile.MirrorWeaveTile;
import com.hollingsworth.arsnouveau.setup.registry.BlockRegistry;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;

public class TemporaryTile
extends MirrorWeaveTile
implements ITickable {
    public int tickDuration;
    public Long gameTime = null;

    public TemporaryTile(BlockPos pos, BlockState state) {
        this((BlockEntityType)BlockRegistry.TEMPORARY_TILE.get(), pos, state);
    }

    public TemporaryTile(BlockEntityType type, BlockPos pos, BlockState state) {
        super(type, pos, state);
        this.mimicState = this.getDefaultBlockState();
    }

    @Override
    public void tick() {
        if (this.level == null || this.level.isClientSide) {
            return;
        }
        if (this.gameTime == null) {
            this.gameTime = this.level.getGameTime();
        }
        if (this.level.getGameTime() < this.gameTime + (long)this.tickDuration) {
            return;
        }
        this.level.setBlock(this.worldPosition, Blocks.AIR.defaultBlockState(), 2);
        this.level.updateNeighborsAt(this.worldPosition, this.level.getBlockState(this.worldPosition).getBlock());
        for (Direction d : Direction.values()) {
            this.level.updateNeighborsAt(this.worldPosition.relative(d), this.getBlockState().getBlock());
        }
    }

    @Override
    public void saveAdditional(CompoundTag tag, HolderLookup.Provider pRegistries) {
        super.saveAdditional(tag, pRegistries);
        if (this.gameTime != null) {
            tag.putLong("gameTime", this.gameTime.longValue());
        }
        tag.putInt("tickDuration", this.tickDuration);
    }

    @Override
    protected void loadAdditional(CompoundTag pTag, HolderLookup.Provider pRegistries) {
        super.loadAdditional(pTag, pRegistries);
        this.tickDuration = pTag.getInt("tickDuration");
        if (pTag.contains("gameTime")) {
            this.gameTime = pTag.getLong("gameTime");
        }
    }

    @Override
    public BlockState getDefaultBlockState() {
        return Blocks.AIR.defaultBlockState();
    }
}

