/*
 * Decompiled with CFR 0.152.
 */
package com.hollingsworth.arsnouveau.common.command;

import com.hollingsworth.arsnouveau.ArsNouveau;
import com.hollingsworth.arsnouveau.client.particle.ParticleColor;
import com.hollingsworth.arsnouveau.common.entity.AnimBlockSummon;
import com.hollingsworth.arsnouveau.common.entity.AnimHeadSummon;
import com.hollingsworth.arsnouveau.common.util.ANCodecs;
import com.mojang.authlib.properties.PropertyMap;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.BoolArgumentType;
import com.mojang.brigadier.arguments.IntegerArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import java.util.Optional;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.commands.arguments.CompoundTagArgument;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.item.component.ResolvableProfile;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;

public class SummonAnimHeadCommand {
    public static void register(CommandDispatcher<CommandSourceStack> dispatcher) {
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal((String)"ars-skull").requires(sender -> sender.hasPermission(4))).then(Commands.argument((String)"player_name", (ArgumentType)StringArgumentType.word()).then(Commands.argument((String)"duration", (ArgumentType)IntegerArgumentType.integer()).then(Commands.argument((String)"nbt", (ArgumentType)CompoundTagArgument.compoundTag()).then(Commands.argument((String)"dropBlock", (ArgumentType)BoolArgumentType.bool()).executes(context -> SummonAnimHeadCommand.summonSkull((CommandSourceStack)context.getSource(), String.valueOf(StringArgumentType.getString((CommandContext)context, (String)"player_name")), IntegerArgumentType.getInteger((CommandContext)context, (String)"duration"), CompoundTagArgument.getCompoundTag((CommandContext)context, (String)"nbt"), BoolArgumentType.getBool((CommandContext)context, (String)"dropBlock"))))))));
    }

    private static int summonSkull(CommandSourceStack source, String player_name, int duration, CompoundTag compoundTag, boolean dropSkull) {
        try {
            compoundTag.putString("id", ArsNouveau.prefix("animated_head").toString());
            Entity entity = EntityType.loadEntityRecursive((CompoundTag)compoundTag, (Level)source.getLevel(), p_138828_ -> {
                p_138828_.moveTo(source.getPosition().x, source.getPosition().y, source.getPosition().z, p_138828_.getYRot(), p_138828_.getXRot());
                return p_138828_;
            });
            AnimHeadSummon animHeadSummon = (AnimHeadSummon)entity;
            animHeadSummon.blockState = Blocks.PLAYER_HEAD.defaultBlockState();
            CompoundTag compoundtag = new CompoundTag();
            ResolvableProfile resolvableProfile = new ResolvableProfile(Optional.of(player_name), Optional.empty(), new PropertyMap());
            resolvableProfile.resolve().thenApply(profile -> {
                compoundtag.put("profile", ANCodecs.encode(ResolvableProfile.CODEC, profile));
                animHeadSummon.head_data = compoundtag;
                animHeadSummon.setPos(source.getPosition());
                animHeadSummon.setTicksLeft(duration);
                animHeadSummon.getEntityData().set(AnimBlockSummon.CAN_WALK, (Object)true);
                animHeadSummon.getEntityData().set(AnimBlockSummon.AGE, (Object)21);
                animHeadSummon.dropItem = dropSkull;
                animHeadSummon.setColor(ParticleColor.defaultParticleColor().getColor());
                source.getLevel().addFreshEntity((Entity)animHeadSummon);
                return resolvableProfile;
            });
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return 1;
    }
}

