/*
 * Decompiled with CFR 0.152.
 */
package com.hollingsworth.arsnouveau.common.entity.goal;

import com.hollingsworth.arsnouveau.api.util.BlockUtil;
import com.hollingsworth.arsnouveau.common.network.Networking;
import com.hollingsworth.arsnouveau.common.network.PacketAnimEntity;
import java.util.EnumSet;
import java.util.function.Supplier;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.pathfinder.Node;
import net.minecraft.world.level.pathfinder.Path;

public class AnimatedAttackGoal
extends Goal {
    protected final Mob mob;
    private final double speedModifier;
    private final boolean followingTargetEvenIfNotSeen;
    private Path path;
    private double pathedTargetX;
    private double pathedTargetY;
    private double pathedTargetZ;
    private int ticksUntilNextPathRecalculation;
    private int ticksUntilNextAttack;
    private final int attackInterval = 20;
    private long lastCanUseCheck;
    private int failedPathFindingPenalty = 0;
    private boolean canPenalize = false;
    public int timeAnimating = 0;
    public boolean arrived = false;
    public boolean done = false;
    public Supplier<Boolean> canAttack;
    int animationID;
    int animationLength;
    int attackRange;

    public AnimatedAttackGoal(Mob entity, boolean followUnseen, Supplier<Boolean> canAttack, int animationID, int animationLength, int attackRange, double speedModifier) {
        this.mob = entity;
        this.speedModifier = speedModifier;
        this.followingTargetEvenIfNotSeen = followUnseen;
        this.canAttack = canAttack;
        this.animationID = animationID;
        this.animationLength = animationLength;
        this.attackRange = attackRange;
        this.setFlags(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.LOOK));
    }

    public boolean isInterruptable() {
        return true;
    }

    public boolean canUse() {
        long i = this.mob.level.getGameTime();
        if (!this.canAttack.get().booleanValue()) {
            return false;
        }
        if (i - this.lastCanUseCheck < 20L) {
            return false;
        }
        this.lastCanUseCheck = i;
        LivingEntity livingentity = this.mob.getTarget();
        if (livingentity == null) {
            return false;
        }
        if (!livingentity.isAlive()) {
            return false;
        }
        if (this.canPenalize) {
            if (--this.ticksUntilNextPathRecalculation <= 0) {
                this.path = this.mob.getNavigation().createPath((Entity)livingentity, 0);
                this.ticksUntilNextPathRecalculation = 4 + this.mob.getRandom().nextInt(7);
                return this.path != null;
            }
            return true;
        }
        this.path = this.mob.getNavigation().createPath((Entity)livingentity, 0);
        if (this.path != null) {
            return true;
        }
        return this.getAttackReachSqr(livingentity) >= this.mob.distanceToSqr(livingentity.getX(), livingentity.getY(), livingentity.getZ());
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean canContinueToUse() {
        LivingEntity livingentity = this.mob.getTarget();
        if (!this.canAttack.get().booleanValue()) {
            return false;
        }
        if (livingentity == null) return false;
        if (this.done) {
            return false;
        }
        if (!livingentity.isAlive()) {
            return false;
        }
        if (!this.followingTargetEvenIfNotSeen) {
            if (this.mob.getNavigation().isDone()) return false;
            return true;
        }
        if (!this.mob.isWithinRestriction(livingentity.blockPosition())) {
            return false;
        }
        if (!(livingentity instanceof Player)) return true;
        Player player = (Player)livingentity;
        if (livingentity.isSpectator()) return false;
        if (player.isCreative()) return false;
        return true;
    }

    public void start() {
        this.mob.getNavigation().moveTo(this.path, this.speedModifier);
        this.mob.setAggressive(true);
        this.ticksUntilNextPathRecalculation = 0;
        this.ticksUntilNextAttack = 0;
        this.timeAnimating = 0;
        this.arrived = false;
        this.done = false;
    }

    public void stop() {
    }

    public void arrivedTick() {
        ++this.timeAnimating;
        if (this.timeAnimating >= this.animationLength) {
            if (this.mob.getTarget() != null) {
                this.attack(this.mob.getTarget());
            }
            this.done = true;
        }
    }

    public void look(LivingEntity entity) {
        if (entity != null) {
            this.mob.getLookControl().setLookAt((Entity)entity, 30.0f, 30.0f);
        }
    }

    public void onArrive() {
        this.arrived = true;
        Networking.sendToNearbyClient(this.mob.level, (Entity)this.mob, (CustomPacketPayload)new PacketAnimEntity(this.mob.getId(), this.animationID));
    }

    public void tick() {
        LivingEntity livingentity = this.mob.getTarget();
        this.look(livingentity);
        if (this.arrived) {
            this.arrivedTick();
            return;
        }
        double d0 = this.mob.distanceToSqr(livingentity.getX(), livingentity.getY(), livingentity.getZ());
        this.ticksUntilNextPathRecalculation = Math.max(this.ticksUntilNextPathRecalculation - 1, 0);
        if (BlockUtil.distanceFrom(this.mob.position, livingentity.position) <= (double)this.attackRange) {
            this.onArrive();
        }
        if ((this.followingTargetEvenIfNotSeen || this.mob.getSensing().hasLineOfSight((Entity)livingentity)) && this.ticksUntilNextPathRecalculation <= 0 && (this.pathedTargetX == 0.0 && this.pathedTargetY == 0.0 && this.pathedTargetZ == 0.0 || livingentity.distanceToSqr(this.pathedTargetX, this.pathedTargetY, this.pathedTargetZ) >= 1.0 || this.mob.getRandom().nextFloat() < 0.05f)) {
            this.pathedTargetX = livingentity.getX();
            this.pathedTargetY = livingentity.getY();
            this.pathedTargetZ = livingentity.getZ();
            this.ticksUntilNextPathRecalculation = 4 + this.mob.getRandom().nextInt(7);
            if (this.canPenalize) {
                Node finalPathPoint;
                this.ticksUntilNextPathRecalculation += this.failedPathFindingPenalty;
                this.failedPathFindingPenalty = this.mob.getNavigation().getPath() != null ? ((finalPathPoint = this.mob.getNavigation().getPath().getEndNode()) != null && livingentity.distanceToSqr((double)finalPathPoint.x, (double)finalPathPoint.y, (double)finalPathPoint.z) < 1.0 ? 0 : (this.failedPathFindingPenalty += 10)) : (this.failedPathFindingPenalty += 10);
            }
            if (d0 > 1024.0) {
                this.ticksUntilNextPathRecalculation += 10;
            } else if (d0 > 256.0) {
                this.ticksUntilNextPathRecalculation += 5;
            }
            if (!this.mob.getNavigation().moveTo((Entity)livingentity, this.speedModifier)) {
                this.ticksUntilNextPathRecalculation += 15;
            }
        }
        this.ticksUntilNextAttack = Math.max(this.ticksUntilNextAttack - 1, 0);
    }

    protected void attack(LivingEntity target) {
        if (BlockUtil.distanceFrom(target.position, this.mob.position) <= (double)this.attackRange) {
            this.ticksUntilNextAttack = 20;
            this.mob.doHurtTarget((Entity)target);
        }
    }

    protected double getAttackReachSqr(LivingEntity p_179512_1_) {
        return this.mob.getBbWidth() * 2.0f * this.mob.getBbWidth() * 2.0f + p_179512_1_.getBbWidth();
    }
}

