/*
 * Decompiled with CFR 0.152.
 */
package com.hollingsworth.arsnouveau.common.network;

import com.hollingsworth.arsnouveau.ArsNouveau;
import com.hollingsworth.arsnouveau.common.block.tile.ScribesTile;
import com.hollingsworth.arsnouveau.common.crafting.recipes.GlyphRecipe;
import com.hollingsworth.arsnouveau.common.network.AbstractPacket;
import com.hollingsworth.arsnouveau.setup.registry.RecipeRegistry;
import net.minecraft.core.BlockPos;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.block.entity.BlockEntity;

public class PacketSetScribeRecipe
extends AbstractPacket {
    public static final CustomPacketPayload.Type<PacketSetScribeRecipe> TYPE = new CustomPacketPayload.Type(ArsNouveau.prefix("set_scribe_recipe"));
    public static final StreamCodec<RegistryFriendlyByteBuf, PacketSetScribeRecipe> CODEC = StreamCodec.ofMember(PacketSetScribeRecipe::toBytes, PacketSetScribeRecipe::new);
    BlockPos scribePos;
    ResourceLocation recipeID;

    public PacketSetScribeRecipe(RegistryFriendlyByteBuf buf) {
        this.scribePos = buf.readBlockPos();
        this.recipeID = buf.readResourceLocation();
    }

    @Override
    public void toBytes(RegistryFriendlyByteBuf buf) {
        buf.writeBlockPos(this.scribePos);
        buf.writeResourceLocation(this.recipeID);
    }

    public PacketSetScribeRecipe(BlockPos scribesPos, ResourceLocation resourceLocation) {
        this.scribePos = scribesPos;
        this.recipeID = resourceLocation;
    }

    @Override
    public void onServerReceived(MinecraftServer minecraftServer, ServerPlayer player) {
        BlockEntity blockEntity = player.level.getBlockEntity(this.scribePos);
        if (blockEntity instanceof ScribesTile) {
            ScribesTile scribesTile = (ScribesTile)blockEntity;
            RecipeHolder recipe = player.level.getRecipeManager().byKeyTyped((RecipeType)RecipeRegistry.GLYPH_TYPE.get(), this.recipeID);
            scribesTile.setRecipe((RecipeHolder<GlyphRecipe>)recipe, (Player)player);
        }
    }

    public CustomPacketPayload.Type<? extends CustomPacketPayload> type() {
        return TYPE;
    }
}

