/*
 * Decompiled with CFR 0.152.
 */
package com.hollingsworth.arsnouveau.common.network;

import com.hollingsworth.arsnouveau.ArsNouveau;
import com.hollingsworth.arsnouveau.api.event.FamiliarSummonEvent;
import com.hollingsworth.arsnouveau.api.familiar.IFamiliar;
import com.hollingsworth.arsnouveau.client.particle.ParticleUtil;
import com.hollingsworth.arsnouveau.common.capability.ANPlayerDataCap;
import com.hollingsworth.arsnouveau.common.network.AbstractPacket;
import com.hollingsworth.arsnouveau.setup.registry.CapabilityRegistry;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.neoforged.bus.api.Event;
import net.neoforged.neoforge.common.NeoForge;

public class PacketSummonFamiliar
extends AbstractPacket {
    public static final CustomPacketPayload.Type<PacketSummonFamiliar> TYPE = new CustomPacketPayload.Type(ArsNouveau.prefix("summon_familiar"));
    public static final StreamCodec<RegistryFriendlyByteBuf, PacketSummonFamiliar> CODEC = StreamCodec.ofMember(PacketSummonFamiliar::toBytes, PacketSummonFamiliar::new);
    ResourceLocation familiarID;

    public PacketSummonFamiliar(ResourceLocation id) {
        this.familiarID = id;
    }

    public PacketSummonFamiliar(RegistryFriendlyByteBuf buf) {
        this.familiarID = buf.readResourceLocation();
    }

    @Override
    public void toBytes(RegistryFriendlyByteBuf buf) {
        buf.writeResourceLocation(this.familiarID);
    }

    @Override
    public void onServerReceived(MinecraftServer minecraftServer, ServerPlayer owner) {
        ANPlayerDataCap cap = CapabilityRegistry.getPlayerDataCap((LivingEntity)owner);
        if (cap == null) {
            return;
        }
        if (owner == null) {
            return;
        }
        IFamiliar familiarEntity = cap.getFamiliarData(this.familiarID).getEntity(owner.level);
        familiarEntity.setOwnerID(owner.getUUID());
        familiarEntity.getThisEntity().setPos(owner.getX(), owner.getY(), owner.getZ());
        FamiliarSummonEvent summonEvent = new FamiliarSummonEvent(familiarEntity.getThisEntity(), (Entity)owner);
        NeoForge.EVENT_BUS.post((Event)summonEvent);
        if (!summonEvent.isCanceled()) {
            owner.level.addFreshEntity(familiarEntity.getThisEntity());
            ParticleUtil.spawnPoof((ServerLevel)owner.level, familiarEntity.getThisEntity().blockPosition());
            cap.setLastSummonedFamiliar(this.familiarID);
        }
    }

    public CustomPacketPayload.Type<? extends CustomPacketPayload> type() {
        return TYPE;
    }
}

