/*
 * Decompiled with CFR 0.152.
 */
package com.hollingsworth.arsnouveau.setup.registry;

import com.hollingsworth.arsnouveau.api.spell.Spell;
import com.hollingsworth.arsnouveau.client.particle.ParticleColor;
import com.hollingsworth.arsnouveau.common.entity.Alakarkinos;
import com.hollingsworth.arsnouveau.common.entity.AmethystGolem;
import com.hollingsworth.arsnouveau.common.entity.AnimBlockSummon;
import com.hollingsworth.arsnouveau.common.entity.AnimHeadSummon;
import com.hollingsworth.arsnouveau.common.entity.BubbleEntity;
import com.hollingsworth.arsnouveau.common.entity.Cinder;
import com.hollingsworth.arsnouveau.common.entity.EnchantedFallingBlock;
import com.hollingsworth.arsnouveau.common.entity.EnchantedHook;
import com.hollingsworth.arsnouveau.common.entity.EnchantedMageblock;
import com.hollingsworth.arsnouveau.common.entity.EnchantedSkull;
import com.hollingsworth.arsnouveau.common.entity.EntityAllyVex;
import com.hollingsworth.arsnouveau.common.entity.EntityBookwyrm;
import com.hollingsworth.arsnouveau.common.entity.EntityChimeraProjectile;
import com.hollingsworth.arsnouveau.common.entity.EntityDrygmy;
import com.hollingsworth.arsnouveau.common.entity.EntityDummy;
import com.hollingsworth.arsnouveau.common.entity.EntityEvokerFangs;
import com.hollingsworth.arsnouveau.common.entity.EntityFlyingItem;
import com.hollingsworth.arsnouveau.common.entity.EntityFollowProjectile;
import com.hollingsworth.arsnouveau.common.entity.EntityHomingProjectileSpell;
import com.hollingsworth.arsnouveau.common.entity.EntityLingeringSpell;
import com.hollingsworth.arsnouveau.common.entity.EntityOrbitProjectile;
import com.hollingsworth.arsnouveau.common.entity.EntityProjectileSpell;
import com.hollingsworth.arsnouveau.common.entity.EntityRitualProjectile;
import com.hollingsworth.arsnouveau.common.entity.EntitySpellArrow;
import com.hollingsworth.arsnouveau.common.entity.EntityWallSpell;
import com.hollingsworth.arsnouveau.common.entity.EntityWixie;
import com.hollingsworth.arsnouveau.common.entity.GiftStarbuncle;
import com.hollingsworth.arsnouveau.common.entity.IceShardEntity;
import com.hollingsworth.arsnouveau.common.entity.LightningEntity;
import com.hollingsworth.arsnouveau.common.entity.Lily;
import com.hollingsworth.arsnouveau.common.entity.Nook;
import com.hollingsworth.arsnouveau.common.entity.ScryerCamera;
import com.hollingsworth.arsnouveau.common.entity.Starbuncle;
import com.hollingsworth.arsnouveau.common.entity.SummonHorse;
import com.hollingsworth.arsnouveau.common.entity.SummonSkeleton;
import com.hollingsworth.arsnouveau.common.entity.SummonWolf;
import com.hollingsworth.arsnouveau.common.entity.WealdWalker;
import com.hollingsworth.arsnouveau.common.entity.Whirlisprig;
import com.hollingsworth.arsnouveau.common.entity.WildenChimera;
import com.hollingsworth.arsnouveau.common.entity.WildenGuardian;
import com.hollingsworth.arsnouveau.common.entity.WildenHunter;
import com.hollingsworth.arsnouveau.common.entity.WildenStalker;
import com.hollingsworth.arsnouveau.common.entity.familiar.FamiliarAmethystGolem;
import com.hollingsworth.arsnouveau.common.entity.familiar.FamiliarBookwyrm;
import com.hollingsworth.arsnouveau.common.entity.familiar.FamiliarDrygmy;
import com.hollingsworth.arsnouveau.common.entity.familiar.FamiliarEntity;
import com.hollingsworth.arsnouveau.common.entity.familiar.FamiliarStarbuncle;
import com.hollingsworth.arsnouveau.common.entity.familiar.FamiliarWhirlisprig;
import com.hollingsworth.arsnouveau.common.entity.familiar.FamiliarWixie;
import com.hollingsworth.arsnouveau.common.lib.LibEntityNames;
import com.hollingsworth.arsnouveau.common.light.LightManager;
import com.hollingsworth.arsnouveau.common.spell.augment.AugmentAmplify;
import com.hollingsworth.arsnouveau.common.spell.augment.AugmentSensitive;
import com.hollingsworth.arsnouveau.common.spell.effect.EffectColdSnap;
import com.hollingsworth.arsnouveau.common.spell.effect.EffectFlare;
import com.hollingsworth.arsnouveau.common.spell.effect.EffectFreeze;
import com.hollingsworth.arsnouveau.common.spell.effect.EffectHarm;
import com.hollingsworth.arsnouveau.common.spell.effect.EffectHex;
import com.hollingsworth.arsnouveau.common.spell.effect.EffectIgnite;
import com.hollingsworth.arsnouveau.common.spell.effect.EffectSnare;
import com.hollingsworth.arsnouveau.common.spell.effect.EffectWither;
import com.hollingsworth.arsnouveau.common.spell.method.MethodProjectile;
import com.hollingsworth.arsnouveau.setup.config.Config;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Registry;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.util.RandomSource;
import net.minecraft.world.Difficulty;
import net.minecraft.world.entity.AgeableMob;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobCategory;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.SpawnPlacementTypes;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.animal.Wolf;
import net.minecraft.world.entity.animal.horse.AbstractHorse;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.monster.Vex;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.levelgen.Heightmap;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.event.entity.EntityAttributeCreationEvent;
import net.neoforged.neoforge.event.entity.RegisterSpawnPlacementsEvent;
import net.neoforged.neoforge.registries.DeferredHolder;
import net.neoforged.neoforge.registries.DeferredRegister;

public class ModEntities {
    public static final DeferredRegister<EntityType<?>> ENTITIES = DeferredRegister.create((Registry)BuiltInRegistries.ENTITY_TYPE, (String)"ars_nouveau");
    public static final DeferredHolder<EntityType<?>, EntityType<EntityProjectileSpell>> SPELL_PROJ = ModEntities.registerEntity("spell_proj", EntityType.Builder.of(EntityProjectileSpell::new, (MobCategory)MobCategory.MISC).noSave().sized(0.5f, 0.5f).eyeHeight(0.13f).clientTrackingRange(4).updateInterval(20).fireImmune());
    public static final DeferredHolder<EntityType<?>, EntityType<EntityProjectileSpell>> SPELL_PROJ_ARC = ModEntities.registerEntity("arcing_spell_proj", EntityType.Builder.of((entityType, world) -> new EntityProjectileSpell(entityType, world){

        @Override
        public EntityType<?> getType() {
            return (EntityType)SPELL_PROJ_ARC.get();
        }

        @Override
        public boolean isNoGravity() {
            return false;
        }
    }, (MobCategory)MobCategory.MISC).sized(0.5f, 0.5f).noSave().setTrackingRange(20).fireImmune().setShouldReceiveVelocityUpdates(true));
    public static final DeferredHolder<EntityType<?>, EntityType<EntityProjectileSpell>> SPELL_PROJ_HOM = ModEntities.registerEntity("homing_spell_proj", EntityType.Builder.of(EntityHomingProjectileSpell::new, (MobCategory)MobCategory.MISC).sized(0.5f, 0.5f).noSave().setTrackingRange(20).fireImmune().setShouldReceiveVelocityUpdates(true));
    public static final DeferredHolder<EntityType<?>, EntityType<EntityAllyVex>> ALLY_VEX = ModEntities.registerEntity("ally_vex", EntityType.Builder.of(EntityAllyVex::new, (MobCategory)MobCategory.MISC).sized(0.4f, 0.8f).fireImmune());
    public static final DeferredHolder<EntityType<?>, EntityType<EntityEvokerFangs>> ENTITY_EVOKER_FANGS_ENTITY_TYPE = ModEntities.registerEntity("fangs", EntityType.Builder.of(EntityEvokerFangs::new, (MobCategory)MobCategory.MISC).sized(0.5f, 0.8f).setUpdateInterval(60));
    public static final DeferredHolder<EntityType<?>, EntityType<EntityBookwyrm>> ENTITY_BOOKWYRM_TYPE = ModEntities.registerEntity("bookwyrm", EntityType.Builder.of(EntityBookwyrm::new, (MobCategory)MobCategory.MISC).sized(0.4f, 0.6f).setTrackingRange(10).setShouldReceiveVelocityUpdates(true));
    public static final DeferredHolder<EntityType<?>, EntityType<Starbuncle>> STARBUNCLE_TYPE = ModEntities.registerEntity("starbuncle", EntityType.Builder.of(Starbuncle::new, (MobCategory)MobCategory.CREATURE).sized(0.6f, 0.63f).setTrackingRange(10).setShouldReceiveVelocityUpdates(true));
    public static final DeferredHolder<EntityType<?>, EntityType<Alakarkinos>> ALAKARKINOS_TYPE = ModEntities.registerEntity("alakarkinos", EntityType.Builder.of(Alakarkinos::new, (MobCategory)MobCategory.CREATURE).sized(0.75f, 0.8f).setTrackingRange(10).setShouldReceiveVelocityUpdates(true));
    public static final DeferredHolder<EntityType<?>, EntityType<EntityFollowProjectile>> ENTITY_FOLLOW_PROJ = ModEntities.registerEntity("follow_proj", EntityType.Builder.of(EntityFollowProjectile::new, (MobCategory)MobCategory.MISC).sized(0.5f, 0.5f).noSave().fireImmune().setTrackingRange(10).setShouldReceiveVelocityUpdates(true));
    public static final DeferredHolder<EntityType<?>, EntityType<Whirlisprig>> WHIRLISPRIG_TYPE = ModEntities.registerEntity("whirlisprig", EntityType.Builder.of(Whirlisprig::new, (MobCategory)MobCategory.CREATURE).sized(0.6f, 0.98f).setTrackingRange(10).setShouldReceiveVelocityUpdates(true));
    public static final DeferredHolder<EntityType<?>, EntityType<EntityWixie>> ENTITY_WIXIE_TYPE = ModEntities.registerEntity("wixie", EntityType.Builder.of(EntityWixie::new, (MobCategory)MobCategory.MISC).sized(0.6f, 0.98f).setTrackingRange(10).setShouldReceiveVelocityUpdates(true));
    public static final DeferredHolder<EntityType<?>, EntityType<EntityFlyingItem>> ENTITY_FLYING_ITEM = ModEntities.registerEntity("flying_item", EntityType.Builder.of(EntityFlyingItem::new, (MobCategory)MobCategory.MISC).sized(0.5f, 0.5f).fireImmune().setTrackingRange(10).setUpdateInterval(60).setShouldReceiveVelocityUpdates(true).noSave());
    public static final DeferredHolder<EntityType<?>, EntityType<EntityRitualProjectile>> ENTITY_RITUAL = ModEntities.registerEntity("ritual", EntityType.Builder.of(EntityRitualProjectile::new, (MobCategory)MobCategory.MISC).sized(0.5f, 0.5f).setTrackingRange(10).setUpdateInterval(60).setShouldReceiveVelocityUpdates(true));
    public static final DeferredHolder<EntityType<?>, EntityType<WildenHunter>> WILDEN_HUNTER = ModEntities.registerEntity("wilden_hunter", EntityType.Builder.of(WildenHunter::new, (MobCategory)MobCategory.MONSTER).sized(1.2f, 1.2f).setTrackingRange(10).setShouldReceiveVelocityUpdates(true));
    public static final DeferredHolder<EntityType<?>, EntityType<EntitySpellArrow>> ENTITY_SPELL_ARROW = ModEntities.registerEntity("spell_arrow", EntityType.Builder.of(EntitySpellArrow::new, (MobCategory)MobCategory.MISC).sized(0.5f, 0.5f).eyeHeight(0.13f).clientTrackingRange(4).updateInterval(20));
    public static final DeferredHolder<EntityType<?>, EntityType<Cinder>> CINDER = ModEntities.registerEntity("cinder", EntityType.Builder.of(Cinder::new, (MobCategory)MobCategory.MISC).sized(0.5f, 0.5f).setShouldReceiveVelocityUpdates(true).fireImmune().setTrackingRange(256));
    public static final DeferredHolder<EntityType<?>, EntityType<SummonWolf>> SUMMON_WOLF = ModEntities.registerEntity("summon_wolf", EntityType.Builder.of(SummonWolf::new, (MobCategory)MobCategory.CREATURE).sized(0.6f, 0.85f).clientTrackingRange(10));
    public static final DeferredHolder<EntityType<?>, EntityType<WildenStalker>> WILDEN_STALKER = ModEntities.registerEntity("wilden_stalker", EntityType.Builder.of(WildenStalker::new, (MobCategory)MobCategory.MONSTER).sized(0.95f, 1.0f).setTrackingRange(10).setShouldReceiveVelocityUpdates(true));
    public static final DeferredHolder<EntityType<?>, EntityType<SummonHorse>> SUMMON_HORSE = ModEntities.registerEntity("summon_horse", EntityType.Builder.of(SummonHorse::new, (MobCategory)MobCategory.CREATURE).sized(1.3964844f, 1.6f).clientTrackingRange(10));
    public static final DeferredHolder<EntityType<?>, EntityType<SummonSkeleton>> SUMMON_SKELETON = ModEntities.registerEntity("summon_skeleton", EntityType.Builder.of(SummonSkeleton::new, (MobCategory)MobCategory.CREATURE).sized(1.0f, 1.8f).clientTrackingRange(10));
    public static final DeferredHolder<EntityType<?>, EntityType<WildenGuardian>> WILDEN_GUARDIAN = ModEntities.registerEntity("wilden_guardian", EntityType.Builder.of(WildenGuardian::new, (MobCategory)MobCategory.MONSTER).sized(1.15f, 1.15f).setTrackingRange(10).setShouldReceiveVelocityUpdates(true));
    public static final DeferredHolder<EntityType<?>, EntityType<WildenChimera>> WILDEN_BOSS = ModEntities.registerEntity("wilden_boss", EntityType.Builder.of(WildenChimera::new, (MobCategory)MobCategory.MONSTER).sized(2.5f, 2.25f).setTrackingRange(10).setShouldReceiveVelocityUpdates(true));
    public static final DeferredHolder<EntityType<?>, EntityType<LightningEntity>> LIGHTNING_ENTITY = ModEntities.registerEntity("an_lightning", EntityType.Builder.of(LightningEntity::new, (MobCategory)MobCategory.MISC).sized(0.0f, 0.0f).clientTrackingRange(16).updateInterval(Integer.MAX_VALUE).setShouldReceiveVelocityUpdates(true).setUpdateInterval(60));
    public static final DeferredHolder<EntityType<?>, EntityType<EntityDummy>> ENTITY_DUMMY = ModEntities.registerEntity("dummy", EntityType.Builder.of(EntityDummy::new, (MobCategory)MobCategory.MISC).sized(1.0f, 2.0f).setTrackingRange(10).setShouldReceiveVelocityUpdates(true));
    public static final DeferredHolder<EntityType<?>, EntityType<EntityDrygmy>> ENTITY_DRYGMY = ModEntities.registerEntity("drygmy", EntityType.Builder.of(EntityDrygmy::new, (MobCategory)MobCategory.CREATURE).sized(0.6f, 0.85f).clientTrackingRange(10));
    public static final DeferredHolder<EntityType<?>, EntityType<EntityOrbitProjectile>> ORBIT_SPELL = ModEntities.registerEntity("orbit", EntityType.Builder.of(EntityOrbitProjectile::new, (MobCategory)MobCategory.MISC).sized(0.5f, 0.5f).fireImmune().noSave().clientTrackingRange(20).setShouldReceiveVelocityUpdates(true));
    public static final DeferredHolder<EntityType<?>, EntityType<EntityChimeraProjectile>> ENTITY_CHIMERA_SPIKE = ModEntities.registerEntity("spike", EntityType.Builder.of(EntityChimeraProjectile::new, (MobCategory)MobCategory.MISC).sized(0.5f, 0.5f).eyeHeight(0.13f).clientTrackingRange(4).updateInterval(20));
    public static final DeferredHolder<EntityType<?>, EntityType<FamiliarStarbuncle>> ENTITY_FAMILIAR_STARBUNCLE = ModEntities.registerEntity(LibEntityNames.FAMILIAR_STARBUNCLE, EntityType.Builder.of(FamiliarStarbuncle::new, (MobCategory)MobCategory.CREATURE).sized(0.5f, 0.5f).setTrackingRange(10));
    public static final DeferredHolder<EntityType<?>, EntityType<FamiliarWixie>> ENTITY_FAMILIAR_WIXIE = ModEntities.registerEntity(LibEntityNames.FAMILIAR_WIXIE, EntityType.Builder.of(FamiliarWixie::new, (MobCategory)MobCategory.CREATURE).sized(0.5f, 0.5f).setTrackingRange(10));
    public static final DeferredHolder<EntityType<?>, EntityType<FamiliarBookwyrm>> ENTITY_FAMILIAR_BOOKWYRM = ModEntities.registerEntity(LibEntityNames.FAMILIAR_BOOKWYRM, EntityType.Builder.of(FamiliarBookwyrm::new, (MobCategory)MobCategory.CREATURE).sized(0.5f, 0.5f).setTrackingRange(10));
    public static final DeferredHolder<EntityType<?>, EntityType<FamiliarDrygmy>> ENTITY_FAMILIAR_DRYGMY = ModEntities.registerEntity(LibEntityNames.FAMILIAR_DRYGMY, EntityType.Builder.of(FamiliarDrygmy::new, (MobCategory)MobCategory.CREATURE).sized(0.5f, 0.5f).setTrackingRange(10));
    public static final DeferredHolder<EntityType<?>, EntityType<FamiliarWhirlisprig>> ENTITY_FAMILIAR_SYLPH = ModEntities.registerEntity(LibEntityNames.FAMILIAR_WHIRLISPRIG, EntityType.Builder.of(FamiliarWhirlisprig::new, (MobCategory)MobCategory.CREATURE).sized(0.5f, 0.5f).setTrackingRange(10));
    public static final DeferredHolder<EntityType<?>, EntityType<FamiliarAmethystGolem>> FAMILIAR_AMETHYST_GOLEM = ModEntities.registerEntity(LibEntityNames.FAMILIAR_AMETHYST_GOLEM, EntityType.Builder.of(FamiliarAmethystGolem::new, (MobCategory)MobCategory.CREATURE).sized(1.0f, 1.0f).setTrackingRange(10));
    public static final DeferredHolder<EntityType<?>, EntityType<EntityLingeringSpell>> LINGER_SPELL = ModEntities.registerEntity("linger", EntityType.Builder.of(EntityLingeringSpell::new, (MobCategory)MobCategory.MISC).sized(0.5f, 0.5f).setTrackingRange(20).setShouldReceiveVelocityUpdates(true).noSave());
    public static final DeferredHolder<EntityType<?>, EntityType<EntityWallSpell>> WALL_SPELL = ModEntities.registerEntity("wall", EntityType.Builder.of(EntityWallSpell::new, (MobCategory)MobCategory.MISC).sized(0.5f, 0.5f).setTrackingRange(20).setShouldReceiveVelocityUpdates(true).noSave());
    public static final DeferredHolder<EntityType<?>, EntityType<WealdWalker>> ENTITY_CASCADING_WEALD = ModEntities.registerEntity(LibEntityNames.CASCADING_WEALD_WALKER, EntityType.Builder.of((type, world) -> {
        WealdWalker walker = new WealdWalker((EntityType<? extends AgeableMob>)type, world);
        walker.spell = new Spell(MethodProjectile.INSTANCE, EffectFreeze.INSTANCE, EffectColdSnap.INSTANCE);
        walker.color = new ParticleColor(50, 50, 250);
        return walker;
    }, (MobCategory)MobCategory.CREATURE).sized(1.4f, 3.0f).setTrackingRange(10));
    public static final DeferredHolder<EntityType<?>, EntityType<WealdWalker>> ENTITY_FLOURISHING_WEALD = ModEntities.registerEntity(LibEntityNames.FLOURISHING_WEALD_WALKER, EntityType.Builder.of((type, world) -> {
        WealdWalker walker = new WealdWalker((EntityType<? extends AgeableMob>)type, world);
        walker.spell = new Spell(MethodProjectile.INSTANCE, EffectHarm.INSTANCE, AugmentAmplify.INSTANCE, AugmentAmplify.INSTANCE, EffectSnare.INSTANCE);
        walker.color = new ParticleColor(50, 250, 55);
        return walker;
    }, (MobCategory)MobCategory.CREATURE).sized(1.4f, 3.0f).setTrackingRange(10));
    public static final DeferredHolder<EntityType<?>, EntityType<WealdWalker>> ENTITY_BLAZING_WEALD = ModEntities.registerEntity(LibEntityNames.BLAZING_WEALD_WALKER, EntityType.Builder.of((type, world) -> {
        WealdWalker walker = new WealdWalker((EntityType<? extends AgeableMob>)type, world);
        walker.spell = new Spell(MethodProjectile.INSTANCE, EffectIgnite.INSTANCE, AugmentSensitive.INSTANCE, EffectFlare.INSTANCE);
        walker.color = new ParticleColor(250, 15, 15);
        return walker;
    }, (MobCategory)MobCategory.CREATURE).sized(1.4f, 3.0f).setTrackingRange(10));
    public static final DeferredHolder<EntityType<?>, EntityType<WealdWalker>> ENTITY_VEXING_WEALD = ModEntities.registerEntity(LibEntityNames.VEXING_WEALD_WALKER, EntityType.Builder.of((type, world) -> {
        WealdWalker walker = new WealdWalker((EntityType<? extends AgeableMob>)type, world);
        walker.spell = new Spell(MethodProjectile.INSTANCE, EffectHex.INSTANCE, EffectWither.INSTANCE, AugmentAmplify.INSTANCE, AugmentAmplify.INSTANCE);
        walker.color = new ParticleColor(250, 50, 250);
        return walker;
    }, (MobCategory)MobCategory.CREATURE).sized(1.4f, 3.0f).setTrackingRange(10));
    public static final DeferredHolder<EntityType<?>, EntityType<AmethystGolem>> AMETHYST_GOLEM = ModEntities.registerEntity("amethyst_golem", EntityType.Builder.of(AmethystGolem::new, (MobCategory)MobCategory.CREATURE).sized(1.0f, 1.0f).setTrackingRange(10));
    public static final DeferredHolder<EntityType<?>, EntityType<ScryerCamera>> SCRYER_CAMERA = ModEntities.registerEntity("scryer_camera", EntityType.Builder.of(ScryerCamera::new, (MobCategory)MobCategory.MISC).sized(1.0E-4f, 1.0E-4f).setTrackingRange(256).setUpdateInterval(20).setShouldReceiveVelocityUpdates(true));
    public static final DeferredHolder<EntityType<?>, EntityType<EnchantedFallingBlock>> ENCHANTED_FALLING_BLOCK = ModEntities.registerEntity("enchanted_falling_block", EntityType.Builder.of(EnchantedFallingBlock::new, (MobCategory)MobCategory.MISC).sized(0.98f, 0.98f).setShouldReceiveVelocityUpdates(true).setTrackingRange(256));
    public static final DeferredHolder<EntityType<?>, EntityType<IceShardEntity>> ICE_SHARD = ModEntities.registerEntity("ice_shard", EntityType.Builder.of(IceShardEntity::new, (MobCategory)MobCategory.MISC).sized(0.98f, 0.98f).setShouldReceiveVelocityUpdates(true).setTrackingRange(256));
    public static final DeferredHolder<EntityType<?>, EntityType<EnchantedMageblock>> ENCHANTED_MAGE_BLOCK = ModEntities.registerEntity("enchanted_mage_block", EntityType.Builder.of(EnchantedMageblock::new, (MobCategory)MobCategory.MISC).sized(0.98f, 0.98f).setShouldReceiveVelocityUpdates(true).setTrackingRange(256));
    public static final DeferredHolder<EntityType<?>, EntityType<EnchantedSkull>> ENCHANTED_HEAD_BLOCK = ModEntities.registerEntity("enchanted_head_block", EntityType.Builder.of(EnchantedSkull::new, (MobCategory)MobCategory.MISC).sized(0.98f, 0.98f).setShouldReceiveVelocityUpdates(true).setTrackingRange(256));
    public static final DeferredHolder<EntityType<?>, EntityType<GiftStarbuncle>> GIFT_STARBY = ModEntities.registerEntity("gift_starby", EntityType.Builder.of(GiftStarbuncle::new, (MobCategory)MobCategory.CREATURE).sized(0.6f, 0.63f).setTrackingRange(10).setShouldReceiveVelocityUpdates(true));
    public static final DeferredHolder<EntityType<?>, EntityType<AnimBlockSummon>> ANIMATED_BLOCK = ModEntities.registerEntity("animated_block", EntityType.Builder.of(AnimBlockSummon::new, (MobCategory)MobCategory.MISC).sized(1.0f, 1.5f).setTrackingRange(10));
    public static final DeferredHolder<EntityType<?>, EntityType<AnimHeadSummon>> ANIMATED_HEAD = ModEntities.registerEntity("animated_head", EntityType.Builder.of(AnimHeadSummon::new, (MobCategory)MobCategory.MISC).sized(1.0f, 1.5f).setTrackingRange(10));
    public static final DeferredHolder<EntityType<?>, EntityType<Lily>> LILY = ModEntities.registerEntity("lily", EntityType.Builder.of(Lily::new, (MobCategory)MobCategory.MISC).sized(0.5f, 0.75f).setTrackingRange(10));
    public static final DeferredHolder<EntityType<?>, EntityType<Nook>> NOOK = ModEntities.registerEntity("nook", EntityType.Builder.of(Nook::new, (MobCategory)MobCategory.MISC).sized(0.5f, 0.75f).setTrackingRange(10));
    public static final DeferredHolder<EntityType<?>, EntityType<BubbleEntity>> BUBBLE = ModEntities.registerEntity("bubble", EntityType.Builder.of(BubbleEntity::new, (MobCategory)MobCategory.MISC).sized(0.5f, 0.5f).setTrackingRange(10));
    public static final DeferredHolder<EntityType<?>, EntityType<EnchantedHook>> ENCHANTED_HOOK = ModEntities.registerEntity("enchanters_hook", EntityType.Builder.of(EnchantedHook::new, (MobCategory)MobCategory.MISC).noSave().noSummon().sized(0.25f, 0.25f).clientTrackingRange(4).updateInterval(5));

    static <T extends Entity> DeferredHolder<EntityType<?>, EntityType<T>> registerEntity(String name, EntityType.Builder<T> builder) {
        return ENTITIES.register(name, () -> builder.build("ars_nouveau:" + name));
    }

    @SubscribeEvent
    public static void registerPlacements(RegisterSpawnPlacementsEvent event) {
        event.register((EntityType)STARBUNCLE_TYPE.get(), SpawnPlacementTypes.ON_GROUND, Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, ModEntities::genericGroundSpawn, RegisterSpawnPlacementsEvent.Operation.AND);
        event.register((EntityType)GIFT_STARBY.get(), SpawnPlacementTypes.ON_GROUND, Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, ModEntities::genericGroundSpawn, RegisterSpawnPlacementsEvent.Operation.AND);
        event.register((EntityType)WHIRLISPRIG_TYPE.get(), SpawnPlacementTypes.ON_GROUND, Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, ModEntities::genericGroundSpawn, RegisterSpawnPlacementsEvent.Operation.AND);
        event.register((EntityType)ENTITY_DRYGMY.get(), SpawnPlacementTypes.ON_GROUND, Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, ModEntities::genericGroundSpawn, RegisterSpawnPlacementsEvent.Operation.AND);
        event.register((EntityType)WILDEN_GUARDIAN.get(), SpawnPlacementTypes.ON_GROUND, Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, ModEntities::wildenSpawnRules, RegisterSpawnPlacementsEvent.Operation.AND);
        event.register((EntityType)WILDEN_HUNTER.get(), SpawnPlacementTypes.ON_GROUND, Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, ModEntities::wildenSpawnRules, RegisterSpawnPlacementsEvent.Operation.AND);
        event.register((EntityType)WILDEN_STALKER.get(), SpawnPlacementTypes.ON_GROUND, Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, ModEntities::wildenSpawnRules, RegisterSpawnPlacementsEvent.Operation.AND);
        event.register((EntityType)ENTITY_BLAZING_WEALD.get(), SpawnPlacementTypes.ON_GROUND, Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, ModEntities::genericGroundSpawn, RegisterSpawnPlacementsEvent.Operation.AND);
        event.register((EntityType)ENTITY_CASCADING_WEALD.get(), SpawnPlacementTypes.ON_GROUND, Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, ModEntities::genericGroundSpawn, RegisterSpawnPlacementsEvent.Operation.AND);
        event.register((EntityType)ENTITY_FLOURISHING_WEALD.get(), SpawnPlacementTypes.ON_GROUND, Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, ModEntities::genericGroundSpawn, RegisterSpawnPlacementsEvent.Operation.AND);
        event.register((EntityType)ENTITY_VEXING_WEALD.get(), SpawnPlacementTypes.ON_GROUND, Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, ModEntities::genericGroundSpawn, RegisterSpawnPlacementsEvent.Operation.AND);
        event.register((EntityType)ALAKARKINOS_TYPE.get(), SpawnPlacementTypes.ON_GROUND, Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, ModEntities::beachSpawn, RegisterSpawnPlacementsEvent.Operation.AND);
        LightManager.init();
    }

    public static boolean wildenSpawnRules(EntityType<? extends Monster> type, ServerLevelAccessor worldIn, MobSpawnType reason, BlockPos pos, RandomSource randomIn) {
        return worldIn.getDifficulty() != Difficulty.PEACEFUL && Monster.checkMonsterSpawnRules(type, (ServerLevelAccessor)worldIn, (MobSpawnType)reason, (BlockPos)pos, (RandomSource)randomIn) && !((List)Config.DIMENSION_BLACKLIST.get()).contains(worldIn.getLevel().dimension().location().toString());
    }

    public static boolean genericGroundSpawn(EntityType<? extends Entity> animal, LevelAccessor worldIn, MobSpawnType reason, BlockPos pos, RandomSource random) {
        return worldIn.getBlockState(pos.below()).is(Blocks.GRASS_BLOCK) && worldIn.getRawBrightness(pos, 0) > 8;
    }

    public static boolean beachSpawn(EntityType<? extends Entity> animal, LevelAccessor worldIn, MobSpawnType reason, BlockPos pos, RandomSource random) {
        return (worldIn.getBlockState(pos.below()).is(Blocks.GRASS_BLOCK) || worldIn.getBlockState(pos.below()).is(Blocks.SAND) || worldIn.getBlockState(pos.below()).is(Blocks.SANDSTONE)) && worldIn.getRawBrightness(pos, 0) > 8;
    }

    @EventBusSubscriber(modid="ars_nouveau", bus=EventBusSubscriber.Bus.MOD)
    public static class RegistrationHandler {
        @SubscribeEvent
        public static void registerEntityAttributes(EntityAttributeCreationEvent event) {
            event.put((EntityType)ENTITY_BOOKWYRM_TYPE.get(), EntityBookwyrm.attributes().build());
            event.put((EntityType)ALLY_VEX.get(), Vex.createAttributes().build());
            event.put((EntityType)STARBUNCLE_TYPE.get(), Starbuncle.attributes().build());
            event.put((EntityType)WHIRLISPRIG_TYPE.get(), Whirlisprig.attributes().build());
            event.put((EntityType)ENTITY_DRYGMY.get(), Whirlisprig.attributes().build());
            event.put((EntityType)ENTITY_WIXIE_TYPE.get(), EntityWixie.attributes().build());
            event.put((EntityType)WILDEN_HUNTER.get(), WildenHunter.getModdedAttributes().build());
            event.put((EntityType)WILDEN_STALKER.get(), WildenStalker.getModdedAttributes().build());
            event.put((EntityType)SUMMON_WOLF.get(), Wolf.createAttributes().build());
            event.put((EntityType)SUMMON_HORSE.get(), AbstractHorse.createBaseHorseAttributes().build());
            event.put((EntityType)WILDEN_GUARDIAN.get(), WildenGuardian.getModdedAttributes().build());
            event.put((EntityType)ENTITY_DUMMY.get(), Mob.createMobAttributes().add(Attributes.MAX_HEALTH, 20.0).add(Attributes.MOVEMENT_SPEED, 0.25).build());
            event.put((EntityType)WILDEN_BOSS.get(), WildenChimera.getModdedAttributes().build());
            event.put((EntityType)ENTITY_FAMILIAR_STARBUNCLE.get(), FamiliarEntity.attributes().build());
            event.put((EntityType)ENTITY_FAMILIAR_BOOKWYRM.get(), FamiliarEntity.attributes().build());
            event.put((EntityType)ENTITY_FAMILIAR_WIXIE.get(), FamiliarEntity.attributes().build());
            event.put((EntityType)ENTITY_FAMILIAR_SYLPH.get(), FamiliarEntity.attributes().build());
            event.put((EntityType)ENTITY_FAMILIAR_DRYGMY.get(), FamiliarEntity.attributes().build());
            event.put((EntityType)FAMILIAR_AMETHYST_GOLEM.get(), FamiliarEntity.attributes().build());
            event.put((EntityType)ENTITY_CASCADING_WEALD.get(), WealdWalker.attributes().build());
            event.put((EntityType)ENTITY_BLAZING_WEALD.get(), WealdWalker.attributes().build());
            event.put((EntityType)ENTITY_FLOURISHING_WEALD.get(), WealdWalker.attributes().build());
            event.put((EntityType)ENTITY_VEXING_WEALD.get(), WealdWalker.attributes().build());
            event.put((EntityType)AMETHYST_GOLEM.get(), AmethystGolem.attributes().build());
            event.put((EntityType)SUMMON_SKELETON.get(), SummonSkeleton.createAttributes().build());
            event.put((EntityType)GIFT_STARBY.get(), GiftStarbuncle.attributes().build());
            event.put((EntityType)ANIMATED_BLOCK.get(), AnimBlockSummon.createAttributes().build());
            event.put((EntityType)ANIMATED_HEAD.get(), AnimBlockSummon.createAttributes().build());
            event.put((EntityType)LILY.get(), Lily.createAttributes().build());
            event.put((EntityType)NOOK.get(), Nook.createAttributes().build());
            event.put((EntityType)ALAKARKINOS_TYPE.get(), Starbuncle.attributes().build());
        }
    }
}

