/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.ars_nouveau.analysis.synonym.word2vec;

import java.io.IOException;
import java.util.Locale;
import java.util.Map;
import org.apache.lucene.ars_nouveau.analysis.TokenFilterFactory;
import org.apache.lucene.ars_nouveau.analysis.TokenStream;
import org.apache.lucene.ars_nouveau.analysis.synonym.word2vec.Word2VecSynonymFilter;
import org.apache.lucene.ars_nouveau.analysis.synonym.word2vec.Word2VecSynonymProvider;
import org.apache.lucene.ars_nouveau.analysis.synonym.word2vec.Word2VecSynonymProviderFactory;
import org.apache.lucene.ars_nouveau.util.ResourceLoader;
import org.apache.lucene.ars_nouveau.util.ResourceLoaderAware;

public class Word2VecSynonymFilterFactory
extends TokenFilterFactory
implements ResourceLoaderAware {
    public static final String NAME = "Word2VecSynonym";
    public static final int DEFAULT_MAX_SYNONYMS_PER_TERM = 5;
    public static final float DEFAULT_MIN_ACCEPTED_SIMILARITY = 0.8f;
    private final int maxSynonymsPerTerm;
    private final float minAcceptedSimilarity;
    private final Word2VecSynonymProviderFactory.Word2VecSupportedFormats format;
    private final String word2vecModelFileName;
    private Word2VecSynonymProvider synonymProvider;

    public Word2VecSynonymFilterFactory(Map<String, String> args) {
        super(args);
        this.maxSynonymsPerTerm = this.getInt(args, "maxSynonymsPerTerm", 5);
        this.minAcceptedSimilarity = this.getFloat(args, "minAcceptedSimilarity", 0.8f);
        this.word2vecModelFileName = this.require(args, "model");
        String modelFormat = this.get(args, "format", "dl4j").toUpperCase(Locale.ROOT);
        try {
            this.format = Word2VecSynonymProviderFactory.Word2VecSupportedFormats.valueOf(modelFormat);
        }
        catch (IllegalArgumentException exc) {
            throw new IllegalArgumentException("Model format '" + modelFormat + "' not supported", exc);
        }
        if (!args.isEmpty()) {
            throw new IllegalArgumentException("Unknown parameters: " + String.valueOf(args));
        }
        if (this.minAcceptedSimilarity <= 0.0f || this.minAcceptedSimilarity > 1.0f) {
            throw new IllegalArgumentException("minAcceptedSimilarity must be in the range (0, 1]. Found: " + this.minAcceptedSimilarity);
        }
        if (this.maxSynonymsPerTerm <= 0) {
            throw new IllegalArgumentException("maxSynonymsPerTerm must be a positive integer greater than 0. Found: " + this.maxSynonymsPerTerm);
        }
    }

    public Word2VecSynonymFilterFactory() {
        throw Word2VecSynonymFilterFactory.defaultCtorException();
    }

    Word2VecSynonymProvider getSynonymProvider() {
        return this.synonymProvider;
    }

    @Override
    public TokenStream create(TokenStream input) {
        return this.synonymProvider == null ? input : new Word2VecSynonymFilter(input, this.synonymProvider, this.maxSynonymsPerTerm, this.minAcceptedSimilarity);
    }

    @Override
    public void inform(ResourceLoader loader) throws IOException {
        this.synonymProvider = Word2VecSynonymProviderFactory.getSynonymProvider(loader, this.word2vecModelFileName, this.format);
    }
}

