/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.ars_nouveau.facet.sortedset;

import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import org.apache.lucene.ars_nouveau.facet.FacetUtils;
import org.apache.lucene.ars_nouveau.facet.FacetsCollector;
import org.apache.lucene.ars_nouveau.facet.sortedset.AbstractSortedSetDocValueFacetCounts;
import org.apache.lucene.ars_nouveau.facet.sortedset.SortedSetDocValuesReaderState;
import org.apache.lucene.ars_nouveau.index.DocValues;
import org.apache.lucene.ars_nouveau.index.DocValuesIterator;
import org.apache.lucene.ars_nouveau.index.IndexReader;
import org.apache.lucene.ars_nouveau.index.LeafReader;
import org.apache.lucene.ars_nouveau.index.LeafReaderContext;
import org.apache.lucene.ars_nouveau.index.MultiDocValues;
import org.apache.lucene.ars_nouveau.index.OrdinalMap;
import org.apache.lucene.ars_nouveau.index.ReaderUtil;
import org.apache.lucene.ars_nouveau.index.SortedDocValues;
import org.apache.lucene.ars_nouveau.index.SortedSetDocValues;
import org.apache.lucene.ars_nouveau.search.ConjunctionUtils;
import org.apache.lucene.ars_nouveau.search.DocIdSetIterator;
import org.apache.lucene.ars_nouveau.util.Bits;
import org.apache.lucene.ars_nouveau.util.LongValues;

public class SortedSetDocValuesFacetCounts
extends AbstractSortedSetDocValueFacetCounts {
    private final SortedSetDocValuesReaderState state;
    int[] counts;

    public SortedSetDocValuesFacetCounts(SortedSetDocValuesReaderState state) throws IOException {
        this(state, null);
    }

    public SortedSetDocValuesFacetCounts(SortedSetDocValuesReaderState state, FacetsCollector hits) throws IOException {
        super(state);
        this.state = state;
        if (hits == null) {
            this.countAll();
        } else {
            this.count(hits.getMatchingDocs());
        }
    }

    private void initializeCounts() {
        if (this.counts == null) {
            this.counts = new int[this.state.getSize()];
        }
    }

    @Override
    boolean hasCounts() {
        return this.counts != null;
    }

    @Override
    int getCount(int ord) {
        return this.counts[ord];
    }

    private void countOneSegmentNHLD(OrdinalMap ordinalMap, LeafReader reader, int segOrd) throws IOException {
        SortedSetDocValues multiValues = DocValues.getSortedSet(reader, this.field);
        if (multiValues == null) {
            return;
        }
        this.initializeCounts();
        SortedDocValues singleValues = DocValues.unwrapSingleton(multiValues);
        if (ordinalMap != null) {
            LongValues ordMap = ordinalMap.getGlobalOrds(segOrd);
            int numSegOrds = (int)multiValues.getValueCount();
            int[] segCounts = new int[numSegOrds];
            if (singleValues != null) {
                doc = singleValues.nextDoc();
                while (doc != Integer.MAX_VALUE) {
                    int n = singleValues.ordValue();
                    segCounts[n] = segCounts[n] + 1;
                    doc = singleValues.nextDoc();
                }
            } else {
                doc = multiValues.nextDoc();
                while (doc != Integer.MAX_VALUE) {
                    for (int i = 0; i < multiValues.docValueCount(); ++i) {
                        int term;
                        int n = term = (int)multiValues.nextOrd();
                        segCounts[n] = segCounts[n] + 1;
                    }
                    doc = multiValues.nextDoc();
                }
            }
            for (int ord = 0; ord < numSegOrds; ++ord) {
                int count = segCounts[ord];
                if (count == 0) continue;
                int n = (int)ordMap.get(ord);
                this.counts[n] = this.counts[n] + count;
            }
        } else if (singleValues != null) {
            int doc = singleValues.nextDoc();
            while (doc != Integer.MAX_VALUE) {
                int n = singleValues.ordValue();
                this.counts[n] = this.counts[n] + 1;
                doc = singleValues.nextDoc();
            }
        } else {
            int doc = multiValues.nextDoc();
            while (doc != Integer.MAX_VALUE) {
                for (int i = 0; i < multiValues.docValueCount(); ++i) {
                    int term;
                    int n = term = (int)multiValues.nextOrd();
                    this.counts[n] = this.counts[n] + 1;
                }
                doc = multiValues.nextDoc();
            }
        }
    }

    private void countOneSegment(OrdinalMap ordinalMap, LeafReader reader, int segOrd, FacetsCollector.MatchingDocs hits, Bits liveDocs) throws IOException {
        DocIdSetIterator it;
        DocValuesIterator valuesIt;
        if (hits != null && hits.totalHits() == 0) {
            return;
        }
        SortedSetDocValues multiValues = DocValues.getSortedSet(reader, this.field);
        if (multiValues == null) {
            return;
        }
        this.initializeCounts();
        SortedDocValues singleValues = DocValues.unwrapSingleton(multiValues);
        DocValuesIterator docValuesIterator = valuesIt = singleValues != null ? singleValues : multiValues;
        if (hits == null) {
            assert (liveDocs != null);
            it = FacetUtils.liveDocsDISI(valuesIt, liveDocs);
        } else {
            it = ConjunctionUtils.intersectIterators(Arrays.asList(hits.bits().iterator(), valuesIt));
        }
        if (ordinalMap != null) {
            LongValues ordMap = ordinalMap.getGlobalOrds(segOrd);
            int numSegOrds = (int)multiValues.getValueCount();
            if (hits != null && hits.totalHits() < numSegOrds / 10) {
                if (singleValues != null) {
                    int doc = it.nextDoc();
                    while (doc != Integer.MAX_VALUE) {
                        int n = (int)ordMap.get(singleValues.ordValue());
                        this.counts[n] = this.counts[n] + 1;
                        doc = it.nextDoc();
                    }
                } else {
                    int doc = it.nextDoc();
                    while (doc != Integer.MAX_VALUE) {
                        for (int i = 0; i < multiValues.docValueCount(); ++i) {
                            int term = (int)multiValues.nextOrd();
                            int n = (int)ordMap.get(term);
                            this.counts[n] = this.counts[n] + 1;
                        }
                        doc = it.nextDoc();
                    }
                }
            } else {
                int[] segCounts = new int[numSegOrds];
                if (singleValues != null) {
                    doc = it.nextDoc();
                    while (doc != Integer.MAX_VALUE) {
                        int n = singleValues.ordValue();
                        segCounts[n] = segCounts[n] + 1;
                        doc = it.nextDoc();
                    }
                } else {
                    doc = it.nextDoc();
                    while (doc != Integer.MAX_VALUE) {
                        for (int i = 0; i < multiValues.docValueCount(); ++i) {
                            int term;
                            int n = term = (int)multiValues.nextOrd();
                            segCounts[n] = segCounts[n] + 1;
                        }
                        doc = it.nextDoc();
                    }
                }
                for (int ord = 0; ord < numSegOrds; ++ord) {
                    int count = segCounts[ord];
                    if (count == 0) continue;
                    int n = (int)ordMap.get(ord);
                    this.counts[n] = this.counts[n] + count;
                }
            }
        } else if (singleValues != null) {
            int doc = it.nextDoc();
            while (doc != Integer.MAX_VALUE) {
                int n = singleValues.ordValue();
                this.counts[n] = this.counts[n] + 1;
                doc = it.nextDoc();
            }
        } else {
            int doc = it.nextDoc();
            while (doc != Integer.MAX_VALUE) {
                for (int i = 0; i < multiValues.docValueCount(); ++i) {
                    int term;
                    int n = term = (int)multiValues.nextOrd();
                    this.counts[n] = this.counts[n] + 1;
                }
                doc = it.nextDoc();
            }
        }
    }

    private void count(List<FacetsCollector.MatchingDocs> matchingDocs) throws IOException {
        OrdinalMap ordinalMap = this.dv instanceof MultiDocValues.MultiSortedSetDocValues && matchingDocs.size() > 1 ? ((MultiDocValues.MultiSortedSetDocValues)this.dv).mapping : null;
        IndexReader reader = this.state.getReader();
        for (FacetsCollector.MatchingDocs hits : matchingDocs) {
            if (ReaderUtil.getTopLevelContext(hits.context()).reader() != reader) {
                throw new IllegalStateException("the SortedSetDocValuesReaderState provided to this class does not match the reader being searched; you must create a new SortedSetDocValuesReaderState every time you open a new IndexReader");
            }
            this.countOneSegment(ordinalMap, hits.context().reader(), hits.context().ord, hits, null);
        }
    }

    private void countAll() throws IOException {
        OrdinalMap ordinalMap = this.dv instanceof MultiDocValues.MultiSortedSetDocValues ? ((MultiDocValues.MultiSortedSetDocValues)this.dv).mapping : null;
        for (LeafReaderContext context : this.state.getReader().leaves()) {
            Bits liveDocs = context.reader().getLiveDocs();
            if (liveDocs == null) {
                this.countOneSegmentNHLD(ordinalMap, context.reader(), context.ord);
                continue;
            }
            this.countOneSegment(ordinalMap, context.reader(), context.ord, null, liveDocs);
        }
    }
}

