/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.ars_nouveau.geo;

import org.apache.lucene.ars_nouveau.geo.Rectangle;
import org.apache.lucene.ars_nouveau.index.PointValues;
import org.apache.lucene.ars_nouveau.util.SloppyMath;

public final class GeoUtils {
    public static final double MIN_LON_INCL = -180.0;
    public static final double MAX_LON_INCL = 180.0;
    public static final double MIN_LAT_INCL = -90.0;
    public static final double MAX_LAT_INCL = 90.0;
    public static final double MIN_LON_RADIANS = Math.toRadians(-180.0);
    public static final double MIN_LAT_RADIANS = Math.toRadians(-90.0);
    public static final double MAX_LON_RADIANS = Math.toRadians(180.0);
    public static final double MAX_LAT_RADIANS = Math.toRadians(90.0);
    public static final double EARTH_MEAN_RADIUS_METERS = 6371008.7714;
    private static final double PIO2 = 1.5707963267948966;

    private GeoUtils() {
    }

    public static void checkLatitude(double latitude) {
        if (Double.isNaN(latitude) || latitude < -90.0 || latitude > 90.0) {
            throw new IllegalArgumentException("invalid latitude " + latitude + "; must be between -90.0 and 90.0");
        }
    }

    public static void checkLongitude(double longitude) {
        if (Double.isNaN(longitude) || longitude < -180.0 || longitude > 180.0) {
            throw new IllegalArgumentException("invalid longitude " + longitude + "; must be between -180.0 and 180.0");
        }
    }

    public static double sloppySin(double a) {
        return SloppyMath.cos(a - 1.5707963267948966);
    }

    public static double distanceQuerySortKey(double radius) {
        if (radius >= SloppyMath.haversinMeters(Double.MAX_VALUE)) {
            return SloppyMath.haversinMeters(Double.MAX_VALUE);
        }
        long lo = 0L;
        long hi = Double.doubleToRawLongBits(Double.MAX_VALUE);
        while (lo <= hi) {
            long mid = lo + hi >>> 1;
            double sortKey = Double.longBitsToDouble(mid);
            double midRadius = SloppyMath.haversinMeters(sortKey);
            if (midRadius == radius) {
                return sortKey;
            }
            if (midRadius > radius) {
                hi = mid - 1L;
                continue;
            }
            lo = mid + 1L;
        }
        double ceil = Double.longBitsToDouble(lo);
        assert (SloppyMath.haversinMeters(ceil) > radius);
        return ceil;
    }

    public static PointValues.Relation relate(double minLat, double maxLat, double minLon, double maxLon, double lat, double lon, double distanceSortKey, double axisLat) {
        if (minLon > maxLon) {
            throw new IllegalArgumentException("Box crosses the dateline");
        }
        if ((lon < minLon || lon > maxLon) && (axisLat + Rectangle.AXISLAT_ERROR < minLat || axisLat - Rectangle.AXISLAT_ERROR > maxLat) && SloppyMath.haversinSortKey(lat, lon, minLat, minLon) > distanceSortKey && SloppyMath.haversinSortKey(lat, lon, minLat, maxLon) > distanceSortKey && SloppyMath.haversinSortKey(lat, lon, maxLat, minLon) > distanceSortKey && SloppyMath.haversinSortKey(lat, lon, maxLat, maxLon) > distanceSortKey) {
            return PointValues.Relation.CELL_OUTSIDE_QUERY;
        }
        if (GeoUtils.within90LonDegrees(lon, minLon, maxLon) && SloppyMath.haversinSortKey(lat, lon, minLat, minLon) <= distanceSortKey && SloppyMath.haversinSortKey(lat, lon, minLat, maxLon) <= distanceSortKey && SloppyMath.haversinSortKey(lat, lon, maxLat, minLon) <= distanceSortKey && SloppyMath.haversinSortKey(lat, lon, maxLat, maxLon) <= distanceSortKey) {
            return PointValues.Relation.CELL_INSIDE_QUERY;
        }
        return PointValues.Relation.CELL_CROSSES_QUERY;
    }

    static boolean within90LonDegrees(double lon, double minLon, double maxLon) {
        if (maxLon <= lon - 180.0) {
            lon -= 360.0;
        } else if (minLon >= lon + 180.0) {
            lon += 360.0;
        }
        return maxLon - lon < 90.0 && lon - minLon < 90.0;
    }

    public static int orient(double ax, double ay, double bx, double by, double cx, double cy) {
        double v1 = (bx - ax) * (cy - ay);
        double v2 = (cx - ax) * (by - ay);
        if (v1 > v2) {
            return 1;
        }
        if (v1 < v2) {
            return -1;
        }
        return 0;
    }

    public static boolean lineCrossesLine(double a1x, double a1y, double b1x, double b1y, double a2x, double a2y, double b2x, double b2y) {
        return GeoUtils.orient(a2x, a2y, b2x, b2y, a1x, a1y) * GeoUtils.orient(a2x, a2y, b2x, b2y, b1x, b1y) < 0 && GeoUtils.orient(a1x, a1y, b1x, b1y, a2x, a2y) * GeoUtils.orient(a1x, a1y, b1x, b1y, b2x, b2y) < 0;
    }

    public static boolean lineOverlapLine(double a1x, double a1y, double b1x, double b1y, double a2x, double a2y, double b2x, double b2y) {
        return GeoUtils.orient(a2x, a2y, b2x, b2y, a1x, a1y) == 0 && GeoUtils.orient(a2x, a2y, b2x, b2y, b1x, b1y) == 0 && GeoUtils.orient(a1x, a1y, b1x, b1y, a2x, a2y) == 0 && GeoUtils.orient(a1x, a1y, b1x, b1y, b2x, b2y) == 0;
    }

    public static boolean lineCrossesLineWithBoundary(double a1x, double a1y, double b1x, double b1y, double a2x, double a2y, double b2x, double b2y) {
        return GeoUtils.orient(a2x, a2y, b2x, b2y, a1x, a1y) * GeoUtils.orient(a2x, a2y, b2x, b2y, b1x, b1y) <= 0 && GeoUtils.orient(a1x, a1y, b1x, b1y, a2x, a2y) * GeoUtils.orient(a1x, a1y, b1x, b1y, b2x, b2y) <= 0;
    }

    public static enum WindingOrder {
        CW(-1),
        COLINEAR(0),
        CCW(1);

        private final int sign;

        private WindingOrder(int sign) {
            this.sign = sign;
        }

        public int sign() {
            return this.sign;
        }

        public static WindingOrder fromSign(int sign) {
            if (sign == WindingOrder.CW.sign) {
                return CW;
            }
            if (sign == WindingOrder.COLINEAR.sign) {
                return COLINEAR;
            }
            if (sign == WindingOrder.CCW.sign) {
                return CCW;
            }
            throw new IllegalArgumentException("Invalid WindingOrder sign: " + sign);
        }
    }
}

