/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.ars_nouveau.search.similarities;

import java.util.List;
import java.util.Locale;
import org.apache.lucene.ars_nouveau.search.CollectionStatistics;
import org.apache.lucene.ars_nouveau.search.Explanation;
import org.apache.lucene.ars_nouveau.search.TermStatistics;
import org.apache.lucene.ars_nouveau.search.similarities.BasicStats;
import org.apache.lucene.ars_nouveau.search.similarities.SimilarityBase;

public abstract class LMSimilarity
extends SimilarityBase {
    protected final CollectionModel collectionModel;

    public LMSimilarity(CollectionModel collectionModel) {
        this(collectionModel, true);
    }

    public LMSimilarity(CollectionModel collectionModel, boolean discountOverlaps) {
        super(discountOverlaps);
        this.collectionModel = collectionModel;
    }

    public LMSimilarity() {
        this(new DefaultCollectionModel());
    }

    @Override
    protected BasicStats newStats(String field, double boost) {
        return new LMStats(field, boost);
    }

    @Override
    protected void fillBasicStats(BasicStats stats, CollectionStatistics collectionStats, TermStatistics termStats) {
        super.fillBasicStats(stats, collectionStats, termStats);
        LMStats lmStats = (LMStats)stats;
        lmStats.setCollectionProbability(this.collectionModel.computeProbability(stats));
    }

    @Override
    protected void explain(List<Explanation> subExpls, BasicStats stats, double freq, double docLen) {
        subExpls.add(Explanation.match((Number)Float.valueOf((float)this.collectionModel.computeProbability(stats)), "collection probability", new Explanation[0]));
    }

    public abstract String getName();

    @Override
    public String toString() {
        String coll = this.collectionModel.getName();
        if (coll != null) {
            return String.format(Locale.ROOT, "LM %s - %s", this.getName(), coll);
        }
        return String.format(Locale.ROOT, "LM %s", this.getName());
    }

    public static interface CollectionModel {
        public double computeProbability(BasicStats var1);

        public String getName();
    }

    public static class DefaultCollectionModel
    implements CollectionModel {
        @Override
        public double computeProbability(BasicStats stats) {
            return ((double)stats.getTotalTermFreq() + 1.0) / ((double)stats.getNumberOfFieldTokens() + 1.0);
        }

        @Override
        public String getName() {
            return null;
        }
    }

    public static class LMStats
    extends BasicStats {
        private double collectionProbability;

        public LMStats(String field, double boost) {
            super(field, boost);
        }

        public final double getCollectionProbability() {
            return this.collectionProbability;
        }

        public final void setCollectionProbability(double collectionProbability) {
            this.collectionProbability = collectionProbability;
        }
    }
}

