/*
 * Decompiled with CFR 0.152.
 */
package dev.xkmc.arsdelight.content.item;

import com.hollingsworth.arsnouveau.common.items.ModItem;
import dev.xkmc.arsdelight.init.data.ADLangData;
import dev.xkmc.arsdelight.init.food.FoodType;
import java.util.List;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffectUtil;
import net.minecraft.world.food.FoodProperties;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.UseAnim;
import vectorwing.farmersdelight.common.Configuration;

public class ADFoodItem
extends ModItem {
    private final FoodType type;

    private static Component getTooltip(MobEffectInstance eff) {
        MutableComponent ans = Component.translatable((String)eff.getDescriptionId());
        MobEffect mobeffect = (MobEffect)eff.getEffect().value();
        if (eff.getAmplifier() > 0) {
            ans = Component.translatable((String)"potion.withAmplifier", (Object[])new Object[]{ans, Component.translatable((String)("potion.potency." + eff.getAmplifier()))});
        }
        if (eff.getDuration() > 20) {
            ans = Component.translatable((String)"potion.withDuration", (Object[])new Object[]{ans, MobEffectUtil.formatDuration((MobEffectInstance)eff, (float)1.0f, (float)20.0f)});
        }
        return ans.withStyle(mobeffect.getCategory().getTooltipFormatting());
    }

    public static void getFoodEffects(ItemStack stack, List<Component> list) {
        FoodProperties food = stack.getFoodProperties(null);
        if (food == null) {
            return;
        }
        ADFoodItem.getFoodEffects(food, list);
    }

    public static void getFoodEffects(FoodProperties food, List<Component> list) {
        for (FoodProperties.PossibleEffect eff : food.effects()) {
            int chance = Math.round(eff.probability() * 100.0f);
            if (eff.effect() == null) continue;
            Component ans = ADFoodItem.getTooltip(eff.effect());
            if (chance == 100) {
                list.add(ans);
                continue;
            }
            list.add((Component)ADLangData.CHANCE_EFFECT.get(ans, chance));
        }
    }

    public ADFoodItem(Item.Properties props, FoodType type) {
        super(props);
        this.type = type;
    }

    public UseAnim getUseAnimation(ItemStack stack) {
        return this.type == FoodType.DRINK || this.type == FoodType.HORNED_DRINK || this.type == FoodType.JELLY ? UseAnim.DRINK : UseAnim.EAT;
    }

    public SoundEvent getDrinkingSound() {
        if (this.type == FoodType.JELLY) {
            return SoundEvents.HONEY_DRINK;
        }
        return SoundEvents.GENERIC_DRINK;
    }

    public void appendHoverText(ItemStack stack, Item.TooltipContext level, List<Component> list, TooltipFlag flag) {
        super.appendHoverText(stack, level, list, flag);
        if (((Boolean)Configuration.FOOD_EFFECT_TOOLTIP.get()).booleanValue()) {
            ADFoodItem.getFoodEffects(stack, list);
        }
    }
}

