/*
 * Decompiled with CFR 0.152.
 */
package mod.azure.azurelib.common.animation.controller.state.impl;

import java.util.Map;
import mod.azure.azurelib.common.animation.AzAnimationContext;
import mod.azure.azurelib.common.animation.cache.AzBoneCache;
import mod.azure.azurelib.common.animation.controller.AzAnimationController;
import mod.azure.azurelib.common.animation.controller.AzAnimationControllerTimer;
import mod.azure.azurelib.common.animation.controller.AzBoneSnapshotCache;
import mod.azure.azurelib.common.animation.controller.keyframe.AzKeyframeTransitioner;
import mod.azure.azurelib.common.animation.controller.state.AzAnimationState;
import mod.azure.azurelib.common.animation.controller.state.machine.AzAnimationControllerStateMachine;
import mod.azure.azurelib.common.animation.primitive.AzQueuedAnimation;
import mod.azure.azurelib.common.model.AzBone;
import mod.azure.azurelib.common.model.AzBoneSnapshot;

public final class AzAnimationTransitionState<T>
extends AzAnimationState<T> {
    @Override
    public void onEnter(AzAnimationControllerStateMachine.Context<T> context) {
        super.onEnter(context);
        this.prepareTransition(context);
    }

    @Override
    public void onUpdate(AzAnimationControllerStateMachine.Context<T> context) {
        boolean hasFinishedTransitioning;
        AzAnimationController<T> controller = context.animationController();
        AzAnimationControllerTimer<T> controllerTimer = controller.controllerTimer();
        AzAnimationContext<T> animContext = context.animationContext();
        AzAnimationControllerStateMachine<T> stateMachine = context.stateMachine();
        AzBoneCache boneCache = animContext.boneCache();
        float transitionLength = controller.animationProperties().transitionLength();
        boolean bl = hasFinishedTransitioning = controllerTimer.getAdjustedTick() >= (double)transitionLength;
        if (hasFinishedTransitioning) {
            stateMachine.play();
            return;
        }
        if (controller.currentAnimation() != null) {
            Map<String, AzBone> bones = boneCache.getBakedModel().getBonesByName();
            boolean crashWhenCantFindBone = animContext.config().crashIfBoneMissing();
            AzKeyframeTransitioner<T> keyframeTransitioner = controller.keyframeManager().keyframeTransitioner();
            keyframeTransitioner.transition(bones, crashWhenCantFindBone, controllerTimer.getAdjustedTick());
        }
    }

    private void prepareTransition(AzAnimationControllerStateMachine.Context<?> context) {
        AzAnimationContext<?> animContext = context.animationContext();
        AzBoneCache boneCache = animContext.boneCache();
        AzAnimationController<?> controller = context.animationController();
        AzBoneSnapshotCache boneSnapshotCache = controller.boneSnapshotCache();
        AzAnimationControllerTimer<?> controllerTimer = controller.controllerTimer();
        controllerTimer.reset();
        controller.keyframeManager().keyframeCallbackHandler().reset();
        AzQueuedAnimation nextAnimation = controller.animationQueue().next();
        if (nextAnimation == null) {
            return;
        }
        controller.setCurrentAnimation(nextAnimation);
        Map<String, AzBoneSnapshot> snapshots = boneCache.getBoneSnapshotsByName();
        boneSnapshotCache.put(nextAnimation, snapshots.values());
    }
}

