/*
 * Decompiled with CFR 0.152.
 */
package mod.azure.azurelib.common.config.value;

import mod.azure.azurelib.common.config.adapter.TypeAdapter;
import mod.azure.azurelib.common.config.exception.ConfigValueMissingException;
import mod.azure.azurelib.common.config.format.IConfigFormat;
import mod.azure.azurelib.common.config.value.ConfigValue;
import mod.azure.azurelib.common.config.value.ValueData;
import net.minecraft.network.FriendlyByteBuf;

public class EnumValue<E extends Enum<E>>
extends ConfigValue<E> {
    public EnumValue(ValueData<E> valueData) {
        super(valueData);
    }

    @Override
    protected void serialize(IConfigFormat format) {
        format.writeEnum(this.getId(), (Enum)this.get());
    }

    @Override
    protected void deserialize(IConfigFormat format) throws ConfigValueMissingException {
        this.set(format.readEnum(this.getId(), this.getValueType()));
    }

    public static final class Adapter<E extends Enum<E>>
    extends TypeAdapter {
        @Override
        public ConfigValue<?> serialize(String name, String[] comments, Object value, TypeAdapter.TypeSerializer serializer, TypeAdapter.AdapterContext context) throws IllegalAccessException {
            return new EnumValue<Enum>(ValueData.of(name, (Enum)value, context, comments));
        }

        @Override
        public void encodeToBuffer(ConfigValue<?> value, FriendlyByteBuf buffer) {
            buffer.writeEnum((Enum)value.get());
        }

        @Override
        public Object decodeFromBuffer(ConfigValue<?> value, FriendlyByteBuf buffer) {
            Class<?> type = value.getValueType();
            return buffer.readEnum(type);
        }
    }
}

