/*
 * Decompiled with CFR 0.152.
 */
package mod.azure.azurelib.common.render.armor;

import java.util.UUID;
import mod.azure.azurelib.common.render.AzRendererPipeline;
import mod.azure.azurelib.common.render.AzRendererPipelineContext;
import mod.azure.azurelib.common.render.armor.bone.AzArmorBoneContext;
import mod.azure.azurelib.core.object.Color;
import net.minecraft.client.model.HumanoidModel;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.ItemTags;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.component.DyedItemColor;
import org.jetbrains.annotations.Nullable;

public class AzArmorRendererPipelineContext
extends AzRendererPipelineContext<UUID, ItemStack> {
    private final AzArmorBoneContext boneContext = new AzArmorBoneContext();
    private HumanoidModel<?> baseModel = null;
    private EquipmentSlot currentSlot;
    private ItemStack currentStack;
    private boolean translucent = false;

    public AzArmorRendererPipelineContext(AzRendererPipeline<UUID, ItemStack> rendererPipeline) {
        super(rendererPipeline);
        this.currentEntity = null;
        this.currentSlot = null;
        this.currentStack = null;
    }

    @Override
    public RenderType getDefaultRenderType(ItemStack animatable, ResourceLocation texture, @Nullable MultiBufferSource bufferSource, float partialTick, RenderType defaultRenderType, float alpha) {
        return this.translucent ? RenderType.itemEntityTranslucentCull((ResourceLocation)texture) : defaultRenderType;
    }

    public void prepare(@Nullable Entity entity, ItemStack stack, @Nullable EquipmentSlot slot, @Nullable HumanoidModel<?> baseModel) {
        this.baseModel = baseModel;
        this.currentEntity = entity;
        this.currentStack = stack;
        this.animatable = stack;
        this.currentSlot = slot;
    }

    public void setTranslucent(boolean translucent) {
        this.translucent = translucent;
    }

    @Override
    public Color getRenderColor(ItemStack animatable, float partialTick, int packedLight) {
        return this.currentStack.is(ItemTags.DYEABLE) ? Color.ofOpaque(DyedItemColor.getOrDefault((ItemStack)this.currentStack, (int)-6265536)) : Color.WHITE;
    }

    public HumanoidModel<?> baseModel() {
        return this.baseModel;
    }

    public AzArmorBoneContext boneContext() {
        return this.boneContext;
    }

    @Override
    public Entity currentEntity() {
        return this.currentEntity;
    }

    public EquipmentSlot currentSlot() {
        return this.currentSlot;
    }

    public ItemStack currentStack() {
        return this.currentStack;
    }
}

