/*
 * Decompiled with CFR 0.152.
 */
package mod.azure.azurelib.common.render.item;

import com.mojang.blaze3d.vertex.PoseStack;
import java.util.UUID;
import java.util.stream.Stream;
import mod.azure.azurelib.common.cache.texture.AnimatableTexture;
import mod.azure.azurelib.common.render.AzLayerRenderer;
import mod.azure.azurelib.common.render.AzRendererConfig;
import mod.azure.azurelib.common.render.AzRendererPipeline;
import mod.azure.azurelib.common.render.AzRendererPipelineContext;
import mod.azure.azurelib.common.render.item.AzItemModelRenderer;
import mod.azure.azurelib.common.render.item.AzItemRenderer;
import mod.azure.azurelib.common.render.item.AzItemRendererConfig;
import mod.azure.azurelib.common.render.item.AzItemRendererPipelineContext;
import net.minecraft.world.item.ItemStack;
import org.joml.Matrix4f;
import org.joml.Matrix4fc;

public class AzItemRendererPipeline
extends AzRendererPipeline<UUID, ItemStack> {
    private final AzItemRenderer itemRenderer;
    protected Matrix4f itemRenderTranslations = new Matrix4f();
    protected Matrix4f modelRenderTranslations = new Matrix4f();

    public AzItemRendererPipeline(AzItemRendererConfig config, AzItemRenderer itemRenderer) {
        super(config);
        this.itemRenderer = itemRenderer;
    }

    @Override
    protected AzRendererPipelineContext<UUID, ItemStack> createContext(AzRendererPipeline<UUID, ItemStack> rendererPipeline) {
        return this.config.pipelineContext(this);
    }

    protected AzItemModelRenderer createModelRenderer(AzLayerRenderer<UUID, ItemStack> layerRenderer) {
        return (AzItemModelRenderer)this.config.modelRendererProvider(this, layerRenderer);
    }

    @Override
    protected AzLayerRenderer<UUID, ItemStack> createLayerRenderer(AzRendererConfig<UUID, ItemStack> config) {
        return new AzLayerRenderer<UUID, ItemStack>(config::renderLayers);
    }

    @Override
    public void preRender(AzRendererPipelineContext<UUID, ItemStack> context, boolean isReRender) {
        AzItemRendererPipelineContext itemContext = (AzItemRendererPipelineContext)context;
        PoseStack poseStack = itemContext.poseStack();
        this.itemRenderTranslations = new Matrix4f((Matrix4fc)poseStack.last().pose());
        AzItemRendererConfig config = this.itemRenderer.config();
        float scaleWidth = config.scaleWidth(context.animatable());
        float scaleHeight = config.scaleHeight(context.animatable());
        this.scaleModelForRender(itemContext, scaleWidth, scaleHeight, isReRender);
        if (!isReRender) {
            boolean useNewOffset = config.useNewOffset();
            poseStack.translate(0.5f, useNewOffset ? 0.0f : 0.51f, 0.5f);
        }
        Stream.of("leftArm", "rightArm").forEach(boneName -> context.bakedModel().getBone((String)boneName).ifPresent(bone -> {
            bone.setHidden(true);
            bone.setChildrenHidden(false);
        }));
        if (config.alpha(context.animatable()) < 1.0f) {
            int alpha = (int)(config.alpha(context.animatable()) * 255.0f) << 24;
            int color = itemContext.renderColor() & 0xFFFFFF | alpha;
            itemContext.setRenderColor(color);
            itemContext.setTranslucent(true);
        }
        config.preRenderEntry(context);
    }

    @Override
    public void postRender(AzRendererPipelineContext<UUID, ItemStack> context, boolean isReRender) {
        this.config.postRenderEntry(context);
        context.setTextureOverride(null);
    }

    @Override
    public void updateAnimatedTextureFrame(ItemStack animatable) {
        AnimatableTexture.setAndUpdate(this.config.textureLocation(this.context().currentEntity(), animatable));
    }

    public AzItemRenderer getRenderer() {
        return this.itemRenderer;
    }
}

