/*
 * Decompiled with CFR 0.152.
 */
package mod.azure.azurelib.common.render.layer;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import java.util.UUID;
import mod.azure.azurelib.common.cache.object.GeoCube;
import mod.azure.azurelib.common.model.AzBone;
import mod.azure.azurelib.common.render.AzRendererPipelineContext;
import mod.azure.azurelib.common.render.armor.AzArmorModel;
import mod.azure.azurelib.common.render.armor.AzArmorRenderer;
import mod.azure.azurelib.common.render.armor.AzArmorRendererRegistry;
import mod.azure.azurelib.common.render.armor.bone.AzArmorBoneContext;
import mod.azure.azurelib.common.render.layer.AzRenderLayer;
import mod.azure.azurelib.common.util.client.RenderUtils;
import mod.azure.azurelib.core.object.Color;
import net.minecraft.client.Minecraft;
import net.minecraft.client.model.HumanoidModel;
import net.minecraft.client.model.SkullModelBase;
import net.minecraft.client.model.geom.EntityModelSet;
import net.minecraft.client.model.geom.ModelLayers;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.Sheets;
import net.minecraft.client.renderer.blockentity.SkullBlockRenderer;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.core.Holder;
import net.minecraft.core.component.DataComponents;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.ItemTags;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ArmorItem;
import net.minecraft.world.item.ArmorMaterial;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.armortrim.ArmorTrim;
import net.minecraft.world.item.armortrim.TrimPattern;
import net.minecraft.world.item.component.DyedItemColor;
import net.minecraft.world.item.component.ResolvableProfile;
import net.minecraft.world.level.block.AbstractSkullBlock;
import net.minecraft.world.level.block.SkullBlock;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AzArmorLayer<T extends LivingEntity>
implements AzRenderLayer<UUID, T> {
    protected static final HumanoidModel<LivingEntity> INNER_ARMOR_MODEL = new HumanoidModel(Minecraft.getInstance().getEntityModels().bakeLayer(ModelLayers.PLAYER_INNER_ARMOR));
    protected static final HumanoidModel<LivingEntity> OUTER_ARMOR_MODEL = new HumanoidModel(Minecraft.getInstance().getEntityModels().bakeLayer(ModelLayers.PLAYER_OUTER_ARMOR));
    @Nullable
    protected ItemStack mainHandStack;
    @Nullable
    protected ItemStack offhandStack;
    @Nullable
    protected ItemStack helmetStack;
    @Nullable
    protected ItemStack chestplateStack;
    @Nullable
    protected ItemStack leggingsStack;
    @Nullable
    protected ItemStack bootsStack;

    @Override
    public void preRender(AzRendererPipelineContext<UUID, T> context) {
        LivingEntity animatable = (LivingEntity)context.animatable();
        this.mainHandStack = animatable.getItemBySlot(EquipmentSlot.MAINHAND);
        this.offhandStack = animatable.getItemBySlot(EquipmentSlot.OFFHAND);
        this.helmetStack = animatable.getItemBySlot(EquipmentSlot.HEAD);
        this.chestplateStack = animatable.getItemBySlot(EquipmentSlot.CHEST);
        this.leggingsStack = animatable.getItemBySlot(EquipmentSlot.LEGS);
        this.bootsStack = animatable.getItemBySlot(EquipmentSlot.FEET);
    }

    @Override
    public void render(AzRendererPipelineContext<UUID, T> context) {
    }

    @Override
    public void renderForBone(AzRendererPipelineContext<UUID, T> context, AzBone bone) {
        BlockItem blockItem;
        ItemStack armorStack = this.getArmorItemForBone(context, bone);
        if (armorStack == null) {
            return;
        }
        context.poseStack().pushPose();
        Item item = armorStack.getItem();
        if (item instanceof BlockItem && (item = (blockItem = (BlockItem)item).getBlock()) instanceof AbstractSkullBlock) {
            AbstractSkullBlock skullBlock = (AbstractSkullBlock)item;
            this.renderSkullAsArmor(context, bone, armorStack, skullBlock);
        } else {
            this.renderArmor(context, bone, armorStack);
        }
        context.setVertexConsumer(context.multiBufferSource().getBuffer(context.renderType()));
        context.poseStack().popPose();
    }

    public void renderArmor(AzRendererPipelineContext<UUID, T> context, AzBone bone, ItemStack armorStack) {
        EquipmentSlot slot = this.getEquipmentSlotForBone(context, bone, armorStack);
        HumanoidModel<T> model = this.getModelForItem(slot);
        ModelPart modelPart = this.getModelPartForBone(context, bone, model);
        AzArmorRenderer renderer = AzArmorRendererRegistry.getOrNull(armorStack);
        if (!modelPart.cubes.isEmpty()) {
            context.poseStack().pushPose();
            context.poseStack().scale(-1.0f, -1.0f, 1.0f);
            if (armorStack.getItem() instanceof ArmorItem) {
                this.prepModelPartForRender(context, bone, modelPart);
                if (renderer != null) {
                    this.renderAzArmorPiece(renderer, context, bone, slot, armorStack, modelPart, model);
                } else {
                    this.renderArmorPiece(context, bone, slot, armorStack, modelPart);
                }
            }
            context.poseStack().popPose();
        }
    }

    @NotNull
    protected EquipmentSlot getEquipmentSlotForBone(AzRendererPipelineContext<UUID, T> context, AzBone bone, ItemStack stack) {
        LivingEntity animatable = (LivingEntity)context.animatable();
        for (EquipmentSlot slot : EquipmentSlot.values()) {
            boolean isHumanoidArmorSlotType;
            boolean bl = isHumanoidArmorSlotType = slot.getType() == EquipmentSlot.Type.HUMANOID_ARMOR;
            if (!isHumanoidArmorSlotType || stack != animatable.getItemBySlot(slot)) continue;
            return slot;
        }
        return EquipmentSlot.CHEST;
    }

    @NotNull
    protected ModelPart getModelPartForBone(AzRendererPipelineContext<UUID, T> context, AzBone bone, HumanoidModel<?> baseModel) {
        return baseModel.body;
    }

    @Nullable
    protected ItemStack getArmorItemForBone(AzRendererPipelineContext<UUID, T> context, AzBone bone) {
        return null;
    }

    protected <I extends Item> void renderAzArmorPiece(AzArmorRenderer renderer, AzRendererPipelineContext<UUID, T> context, AzBone bone, EquipmentSlot slot, ItemStack armorStack, ModelPart modelPart, HumanoidModel<T> baseModel) {
        AzArmorModel armorModel = renderer.rendererPipeline().armorModel();
        AzArmorBoneContext boneContext = renderer.rendererPipeline().context().boneContext();
        int color = armorStack.is(ItemTags.DYEABLE) ? DyedItemColor.getOrDefault((ItemStack)armorStack, (int)-6265536) : -1;
        renderer.prepForRender((Entity)context.animatable(), armorStack, slot, baseModel);
        boneContext.applyBoneVisibilityByPart(slot, modelPart, baseModel);
        armorModel.renderToBuffer(context.poseStack(), null, context.packedLight(), OverlayTexture.NO_OVERLAY, color);
    }

    protected <I extends Item> void renderArmorPiece(AzRendererPipelineContext<UUID, T> context, AzBone bone, EquipmentSlot slot, ItemStack armorStack, ModelPart modelPart) {
        VertexConsumer buffer;
        int color = armorStack.is(ItemTags.DYEABLE) ? DyedItemColor.getOrDefault((ItemStack)armorStack, (int)-6265536) : -1;
        Holder material = ((ArmorItem)armorStack.getItem()).getMaterial();
        for (ArmorMaterial.Layer layer : ((ArmorMaterial)material.value()).layers()) {
            buffer = this.getVanillaArmorBuffer(context, armorStack, slot, bone, layer, false);
            modelPart.render(context.poseStack(), buffer, context.packedLight(), context.packedOverlay(), color);
        }
        ArmorTrim trim = (ArmorTrim)armorStack.get(DataComponents.TRIM);
        if (trim != null) {
            TextureAtlasSprite sprite = Minecraft.getInstance().getModelManager().getAtlas(Sheets.ARMOR_TRIMS_SHEET).getSprite(slot == EquipmentSlot.LEGS ? trim.innerTexture(material) : trim.outerTexture(material));
            buffer = sprite.wrap(context.multiBufferSource().getBuffer(Sheets.armorTrimsSheet((boolean)((TrimPattern)trim.pattern().value()).decal())));
            modelPart.render(context.poseStack(), buffer, context.packedLight(), context.packedOverlay());
        }
        if (armorStack.hasFoil()) {
            modelPart.render(context.poseStack(), this.getVanillaArmorBuffer(context, armorStack, slot, bone, null, true), context.packedLight(), context.packedOverlay(), Color.WHITE.argbInt());
        }
    }

    protected VertexConsumer getVanillaArmorBuffer(AzRendererPipelineContext<UUID, T> context, ItemStack stack, EquipmentSlot slot, AzBone bone, @Nullable ArmorMaterial.Layer layer, boolean forGlint) {
        if (forGlint) {
            return context.multiBufferSource().getBuffer(RenderType.armorEntityGlint());
        }
        return context.multiBufferSource().getBuffer(RenderType.armorCutoutNoCull((ResourceLocation)layer.texture(slot == EquipmentSlot.LEGS)));
    }

    @Nullable
    protected AzArmorRenderer getRendererForItem(ItemStack stack) {
        return AzArmorRendererRegistry.getOrNull(stack);
    }

    protected HumanoidModel<T> getModelForItem(EquipmentSlot slot) {
        return slot == EquipmentSlot.LEGS ? INNER_ARMOR_MODEL : OUTER_ARMOR_MODEL;
    }

    protected void renderSkullAsArmor(AzRendererPipelineContext<UUID, T> context, AzBone bone, ItemStack stack, AbstractSkullBlock skullBlock) {
        SkullBlock.Type type = skullBlock.getType();
        SkullModelBase model = (SkullModelBase)SkullBlockRenderer.createSkullRenderers((EntityModelSet)Minecraft.getInstance().getEntityModels()).get(type);
        RenderType renderType = SkullBlockRenderer.getRenderType((SkullBlock.Type)type, (ResolvableProfile)((ResolvableProfile)stack.get(DataComponents.PROFILE)));
        context.poseStack().pushPose();
        RenderUtils.translateAndRotateMatrixForBone(context.poseStack(), bone);
        context.poseStack().scale(1.1875f, 1.1875f, 1.1875f);
        context.poseStack().translate(-0.5f, 0.0f, -0.5f);
        SkullBlockRenderer.renderSkull(null, (float)0.0f, (float)0.0f, (PoseStack)context.poseStack(), (MultiBufferSource)context.multiBufferSource(), (int)context.packedLight(), (SkullModelBase)model, (RenderType)renderType);
        context.poseStack().popPose();
    }

    protected void prepModelPartForRender(AzRendererPipelineContext<UUID, T> context, AzBone bone, ModelPart sourcePart) {
        GeoCube firstCube = bone.getCubes().getFirst();
        ModelPart.Cube armorCube = (ModelPart.Cube)sourcePart.cubes.getFirst();
        double armorBoneSizeX = firstCube.size().x();
        double armorBoneSizeY = firstCube.size().y();
        double armorBoneSizeZ = firstCube.size().z();
        float actualArmorSizeX = Math.abs(armorCube.maxX - armorCube.minX);
        float actualArmorSizeY = Math.abs(armorCube.maxY - armorCube.minY);
        float actualArmorSizeZ = Math.abs(armorCube.maxZ - armorCube.minZ);
        float scaleX = (float)(armorBoneSizeX / (double)actualArmorSizeX);
        float scaleY = (float)(armorBoneSizeY / (double)actualArmorSizeY);
        float scaleZ = (float)(armorBoneSizeZ / (double)actualArmorSizeZ);
        sourcePart.setPos(-(bone.getPivotX() - (bone.getPivotX() * scaleX - bone.getPivotX()) / scaleX), -(bone.getPivotY() - (bone.getPivotY() * scaleY - bone.getPivotY()) / scaleY), bone.getPivotZ() - (bone.getPivotZ() * scaleZ - bone.getPivotZ()) / scaleZ);
        sourcePart.xRot = -bone.getRotX();
        sourcePart.yRot = -bone.getRotY();
        sourcePart.zRot = bone.getRotZ();
        context.poseStack().scale(scaleX, scaleY, scaleZ);
    }
}

