/*
 * Decompiled with CFR 0.152.
 */
package commoble.bagofyurting;

import commoble.bagofyurting.BagOfYurtingData;
import commoble.bagofyurting.BagOfYurtingMod;
import commoble.bagofyurting.CompressedBagOfYurtingData;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.core.component.DataComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.Style;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.component.DyedItemColor;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.Nullable;

public class BagOfYurtingItem
extends Item {
    public static final String RADIUS_KEY = "radius";
    public static final int UNDYED_COLOR = -1;

    public BagOfYurtingItem(Item.Properties properties) {
        super(properties);
    }

    public boolean isFoil(ItemStack stack) {
        return stack.has((DataComponentType)BagOfYurtingMod.get().yurtDataComponent.get());
    }

    public static int getRadius(ItemStack stack) {
        Integer radius = (Integer)stack.get((DataComponentType)BagOfYurtingMod.get().radiusComponent.get());
        return radius == null ? 0 : radius;
    }

    public static int getDiameter(ItemStack stack) {
        return BagOfYurtingItem.getRadius(stack) * 2 + 1;
    }

    public static ItemStack withRadius(ItemStack stack, int radius) {
        ItemStack newStack = stack.copy();
        newStack.set((DataComponentType)BagOfYurtingMod.get().radiusComponent.get(), (Object)radius);
        return newStack;
    }

    public InteractionResult useOn(UseOnContext context) {
        Level Level2 = context.getLevel();
        if (Level2 instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)Level2;
            MinecraftServer server = serverLevel.getServer();
            CompressedBagOfYurtingData compressedData = (CompressedBagOfYurtingData)context.getItemInHand().get((DataComponentType)BagOfYurtingMod.get().yurtDataComponent.get());
            if (compressedData == null) {
                this.loadBag(server, context);
            } else {
                this.unloadBag(context, compressedData.uncompress());
            }
        }
        return InteractionResult.SUCCESS;
    }

    public void loadBag(MinecraftServer server, UseOnContext context) {
        InteractionHand hand = context.getHand();
        ItemStack oldStack = context.getPlayer().getItemInHand(hand);
        BagOfYurtingData data = BagOfYurtingData.yurtBlocksAndConvertToData(context, BagOfYurtingItem.getRadius(oldStack));
        if (!data.isEmpty()) {
            context.getItemInHand().set((DataComponentType)BagOfYurtingMod.get().yurtDataComponent.get(), (Object)data.compress());
        } else {
            context.getPlayer().displayClientMessage((Component)Component.translatable((String)"bagofyurting.failure.load"), true);
        }
    }

    public void unloadBag(UseOnContext context, BagOfYurtingData data) {
        InteractionHand hand = context.getHand();
        ItemStack oldStack = context.getPlayer().getItemInHand(hand);
        boolean success = data.attemptUnloadIntoLevel(context, BagOfYurtingItem.getRadius(oldStack));
        if (success) {
            context.getItemInHand().remove((DataComponentType)BagOfYurtingMod.get().yurtDataComponent.get());
        } else {
            context.getPlayer().displayClientMessage((Component)Component.translatable((String)"bagofyurting.failure.unload"), true);
        }
    }

    public static ItemStack getUpgradeRecipeResult(List<ItemStack> inputs, ItemStack baseOutput) {
        ItemStack output = baseOutput.copy();
        int bagRadius = Integer.MAX_VALUE;
        boolean foundBag = false;
        ArrayList<Integer> dyes = new ArrayList<Integer>();
        for (ItemStack stack : inputs) {
            Item item = stack.getItem();
            if (!(item instanceof BagOfYurtingItem)) continue;
            foundBag = true;
            int newRadius = BagOfYurtingItem.getRadius(stack);
            @Nullable DyedItemColor color = (DyedItemColor)stack.get(DataComponents.DYED_COLOR);
            if (color != null) {
                dyes.add(color.rgb());
            }
            if (newRadius >= bagRadius) continue;
            bagRadius = newRadius;
        }
        if (!foundBag) {
            bagRadius = 0;
        }
        ItemStack actualOutput = BagOfYurtingItem.withRadius(output, bagRadius + 1);
        int colors = dyes.size();
        if (colors > 0) {
            int redSum = 0;
            int greenSum = 0;
            int blueSum = 0;
            Iterator iterator = dyes.iterator();
            while (iterator.hasNext()) {
                int color = (Integer)iterator.next();
                redSum += color >> 16 & 0xFF;
                greenSum += color >> 8 & 0xFF;
                blueSum += color & 0xFF;
            }
            int finalRed = redSum / colors << 16;
            int finalGreen = greenSum / colors << 8;
            int finalBlue = blueSum / colors & 0xFF;
            int finalColor = finalRed + finalGreen + finalBlue;
            actualOutput.set(DataComponents.DYED_COLOR, (Object)new DyedItemColor(finalColor, true));
        }
        return actualOutput;
    }

    public void appendHoverText(ItemStack stack, Item.TooltipContext context, List<Component> tooltip, TooltipFlag flagIn) {
        int diameter = BagOfYurtingItem.getDiameter(stack);
        String sizeText = String.format("%sx%sx%s", diameter, diameter, diameter);
        tooltip.add((Component)Component.literal((String)sizeText).setStyle(Style.EMPTY.withItalic(Boolean.valueOf(true)).applyFormat(ChatFormatting.GRAY)));
    }
}

