/*
 * Decompiled with CFR 0.152.
 */
package commoble.bagofyurting.client.jei;

import commoble.bagofyurting.BagOfYurtingItem;
import commoble.bagofyurting.BagOfYurtingMod;
import commoble.bagofyurting.ShapelessBagUpgradeRecipe;
import commoble.bagofyurting.UpgradeRecipeHacks;
import java.util.ArrayList;
import java.util.function.IntFunction;
import mezz.jei.api.IModPlugin;
import mezz.jei.api.JeiPlugin;
import mezz.jei.api.constants.RecipeTypes;
import mezz.jei.api.ingredients.subtypes.UidContext;
import mezz.jei.api.registration.IRecipeRegistration;
import mezz.jei.api.registration.ISubtypeRegistration;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.item.crafting.RecipeManager;

@JeiPlugin
public class JEIProxy
implements IModPlugin {
    public static final ResourceLocation ID = ResourceLocation.fromNamespaceAndPath((String)"bagofyurting", (String)"bagofyurting");

    public ResourceLocation getPluginUid() {
        return ID;
    }

    public void registerItemSubtypes(ISubtypeRegistration registration) {
        registration.registerSubtypeInterpreter((Item)BagOfYurtingMod.get().bagOfYurtingItem.get(), JEIProxy::getBagOfYurtingSubtype);
    }

    private static String getBagOfYurtingSubtype(ItemStack stack, UidContext context) {
        return Integer.toString(BagOfYurtingItem.getRadius(stack));
    }

    public void registerRecipes(IRecipeRegistration registration) {
        Minecraft mc = Minecraft.getInstance();
        if (mc == null) {
            return;
        }
        ClientLevel level = mc.level;
        if (level == null) {
            return;
        }
        RecipeManager manager = Minecraft.getInstance().level.getRecipeManager();
        manager.byKey(BagOfYurtingMod.UPGRADE_RECIPE_ID).ifPresent(recipe -> JEIProxy.registerExtraRecipes(recipe, registration));
    }

    private static void registerExtraRecipes(RecipeHolder<?> recipeHolder, IRecipeRegistration registration) {
        ResourceLocation id = recipeHolder.id();
        Recipe baseRecipe = recipeHolder.value();
        IntFunction<RecipeHolder> recipeFactory = null;
        if (!(baseRecipe instanceof ShapelessBagUpgradeRecipe)) {
            return;
        }
        ShapelessBagUpgradeRecipe bagRecipe = (ShapelessBagUpgradeRecipe)baseRecipe;
        recipeFactory = i -> UpgradeRecipeHacks.getFakeShapelessRecipe(id, bagRecipe, i);
        ArrayList<RecipeHolder> extraRecipes = new ArrayList<RecipeHolder>();
        int iterations = (Integer)BagOfYurtingMod.get().serverConfig().creativeUpgradeIterations().get();
        for (int i2 = 2; i2 < iterations; ++i2) {
            extraRecipes.add(recipeFactory.apply(i2));
        }
        registration.addRecipes(RecipeTypes.CRAFTING, extraRecipes);
    }
}

