/*
 * Decompiled with CFR 0.152.
 */
package com.leclowndu93150.baguettelib.gui;

import com.mojang.blaze3d.platform.NativeImage;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.texture.AbstractTexture;
import net.minecraft.client.renderer.texture.DynamicTexture;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.Resource;
import net.minecraft.server.packs.resources.ResourceManager;

public class ScreenTextureBuilder {
    private final String modId;
    private final String name;
    private final List<SlotData> slots = new ArrayList<SlotData>();
    private static final Map<String, ResourceLocation> textureCache = new HashMap<String, ResourceLocation>();
    private static final int DEFAULT_GUI_WIDTH = 176;
    private static final int DEFAULT_GUI_HEIGHT = 166;
    private static final int DEFAULT_SLOT_SIZE = 18;
    private static final int STANDARD_SLOT_SPACING = 18;
    private static final int GUI_TOP_AREA_HEIGHT = 84;
    private static final int PLAYER_INV_START_Y = 84;

    private ScreenTextureBuilder(String modId, String name) {
        this.modId = modId;
        this.name = name;
    }

    public static ScreenTextureBuilder create(String modId, String name) {
        return new ScreenTextureBuilder(modId, name);
    }

    public ScreenTextureBuilder addSlot(int x, int y) {
        return this.addSlot(x, y, null);
    }

    public ScreenTextureBuilder addSlot(int x, int y, ResourceLocation customTexture) {
        this.slots.add(new SlotData(x, y, customTexture));
        return this;
    }

    public ScreenTextureBuilder addSlotRect(int x, int y, int cols, int rows, int xSpacing, int ySpacing) {
        return this.addSlotRect(x, y, cols, rows, xSpacing, ySpacing, null);
    }

    public ScreenTextureBuilder addSlotRect(int x, int y, int cols, int rows, int xSpacing, int ySpacing, ResourceLocation customTexture) {
        for (int row = 0; row < rows; ++row) {
            for (int col = 0; col < cols; ++col) {
                int slotX = x + col * xSpacing;
                int slotY = y + row * ySpacing;
                this.addSlot(slotX, slotY, customTexture);
            }
        }
        return this;
    }

    public ScreenTextureBuilder addFurnaceLayout() {
        return this.addSlot(56, 17).addSlot(56, 53).addSlot(116, 35);
    }

    public ScreenTextureBuilder addCraftingTableLayout() {
        return this.addSlotRect(30, 17, 3, 3, 18, 18).addSlot(124, 35);
    }

    public ScreenTextureBuilder addChestLayout(int rows) {
        return this.addSlotRect(8, 18, 9, Math.min(rows, 6), 18, 18);
    }

    public ScreenTextureBuilder addDoubleChestLayout() {
        return this.addChestLayout(6);
    }

    public ScreenTextureBuilder addShulkerBoxLayout() {
        return this.addSlotRect(8, 18, 9, 3, 18, 18);
    }

    public ScreenTextureBuilder addHopperLayout() {
        return this.addSlotRect(44, 20, 5, 1, 18, 18);
    }

    public ScreenTextureBuilder addDispenserLayout() {
        return this.addSlotRect(62, 17, 3, 3, 18, 18);
    }

    public ScreenTextureBuilder addBrewingStandLayout() {
        return this.addSlot(79, 17).addSlot(56, 47).addSlot(79, 53).addSlot(102, 47);
    }

    public ScreenTextureBuilder addEnchantmentTableLayout() {
        return this.addSlot(15, 47).addSlot(35, 47);
    }

    public ScreenTextureBuilder addAnvilLayout() {
        return this.addSlot(27, 47).addSlot(76, 47).addSlot(134, 47);
    }

    public ScreenTextureBuilder addBeaconLayout() {
        return this.addSlot(79, 34);
    }

    public ScreenTextureBuilder addCenteredSlot(int y) {
        int x = 79;
        return this.addSlot(x, y);
    }

    public ScreenTextureBuilder addCenteredSlotRect(int y, int cols, int rows) {
        return this.addCenteredSlotRect(y, cols, rows, 18, 18);
    }

    public ScreenTextureBuilder addCenteredSlotRect(int y, int cols, int rows, int xSpacing, int ySpacing) {
        int totalWidth = cols * xSpacing - (xSpacing - 18);
        int x = (176 - totalWidth) / 2;
        return this.addSlotRect(x, y, cols, rows, xSpacing, ySpacing);
    }

    public ScreenTextureBuilder addCenteredRow(int y, int count) {
        return this.addCenteredRow(y, count, 18);
    }

    public ScreenTextureBuilder addCenteredRow(int y, int count, int spacing) {
        int totalWidth = count * spacing - (spacing - 18);
        int x = (176 - totalWidth) / 2;
        return this.addSlotRect(x, y, count, 1, spacing, spacing);
    }

    public ScreenTextureBuilder addEvenlySpacedRow(int y, int count, int leftMargin, int rightMargin) {
        int availableWidth = 176 - leftMargin - rightMargin - count * 18;
        int spacing = count > 1 ? availableWidth / (count - 1) + 18 : 0;
        return this.addSlotRect(leftMargin, y, count, 1, spacing, spacing);
    }

    public ScreenTextureBuilder addGridWithMargins(int topMargin, int leftMargin, int rightMargin, int cols, int rows) {
        int availableWidth = 176 - leftMargin - rightMargin;
        int spacing = cols > 1 ? (availableWidth - cols * 18) / (cols - 1) + 18 : 18;
        return this.addSlotRect(leftMargin, topMargin, cols, rows, spacing, 18);
    }

    public ScreenTextureBuilder addCirclePattern(int centerX, int centerY, int radius, int slotCount) {
        for (int i = 0; i < slotCount; ++i) {
            double angle = Math.PI * 2 * (double)i / (double)slotCount;
            int x = centerX + (int)(Math.cos(angle) * (double)radius) - 9;
            int y = centerY + (int)(Math.sin(angle) * (double)radius) - 9;
            this.addSlot(x, y);
        }
        return this;
    }

    public ScreenTextureBuilder addDiamondPattern(int centerX, int centerY, int size) {
        for (int i = 0; i <= size; ++i) {
            int y;
            int x;
            int j;
            if (i == 0) {
                this.addSlot(centerX - 9, centerY - size * 18 / 2);
            } else {
                for (j = -i; j <= i; j += i * 2) {
                    x = centerX + j * 18 / 2 - 9;
                    y = centerY - (size - i) * 18 / 2;
                    this.addSlot(x, y);
                }
            }
            if (i <= 0 || i >= size) continue;
            for (j = -i; j <= i; j += i * 2) {
                x = centerX + j * 18 / 2 - 9;
                y = centerY + (size - i) * 18 / 2;
                this.addSlot(x, y);
            }
        }
        return this;
    }

    public ScreenTextureBuilder addLShape(int x, int y, int width, int height) {
        this.addSlotRect(x, y, width, 1, 18, 18);
        this.addSlotRect(x, y + 18, 1, height - 1, 18, 18);
        return this;
    }

    public ScreenTextureBuilder validateSlotBounds() {
        for (SlotData slot : this.slots) {
            if (slot.x >= 0 && slot.y >= 0 && slot.x + 18 <= 176 && slot.y + 18 <= 84) continue;
            throw new IllegalArgumentException("Slot at (" + slot.x + ", " + slot.y + ") is out of bounds");
        }
        return this;
    }

    public ScreenTextureBuilder removeOverlappingSlots() {
        HashSet positions = new HashSet();
        this.slots.removeIf(slot -> {
            String pos = slot.x + "," + slot.y;
            return !positions.add(pos);
        });
        return this;
    }

    public ScreenTextureBuilder addCustomPattern(SlotPattern pattern) {
        pattern.apply(this);
        return this;
    }

    public ScreenTextureBuilder conditionalSlot(boolean condition, int x, int y) {
        if (condition) {
            this.addSlot(x, y);
        }
        return this;
    }

    public ScreenTextureBuilder multiSlot(int count, SlotPositionFunction positionFunction) {
        for (int i = 0; i < count; ++i) {
            int[] pos = positionFunction.getPosition(i);
            this.addSlot(pos[0], pos[1]);
        }
        return this;
    }

    public int getSlotCount() {
        return this.slots.size();
    }

    public boolean hasSlotAt(int x, int y) {
        return this.slots.stream().anyMatch(slot -> slot.x == x && slot.y == y);
    }

    public ScreenTextureBuilder clearSlots() {
        this.slots.clear();
        return this;
    }

    public static int calculateOptimalColumns(int slotCount, int maxCols) {
        if (slotCount <= maxCols) {
            return slotCount;
        }
        for (int cols = maxCols; cols >= 1; --cols) {
            if (slotCount % cols != 0) continue;
            return cols;
        }
        return Math.min(maxCols, (int)Math.ceil(Math.sqrt(slotCount)));
    }

    public static int calculateOptimalRows(int slotCount, int cols) {
        return (int)Math.ceil((double)slotCount / (double)cols);
    }

    public static int calculateCenteredX(int cols) {
        int totalWidth = cols * 18 - 0;
        return (176 - totalWidth) / 2;
    }

    public static int calculateTotalWidth(int cols) {
        return cols * 18 - 0;
    }

    public static int calculateTotalHeight(int rows) {
        return rows * 18 - 0;
    }

    public ResourceLocation buildAndCache() {
        String cacheKey = this.modId + ":" + this.name + "_" + this.generateSlotHash();
        if (textureCache.containsKey(cacheKey)) {
            return textureCache.get(cacheKey);
        }
        if (!ScreenTextureBuilder.isClientReady()) {
            throw new IllegalStateException("Cannot build GUI textures before client is initialized. Call this method after the client has started.");
        }
        try {
            NativeImage compositeImage = this.createCompositeTexture();
            ResourceLocation textureId = ResourceLocation.fromNamespaceAndPath((String)this.modId, (String)("gui/generated/" + this.name));
            DynamicTexture dynamicTexture = new DynamicTexture(compositeImage);
            Minecraft.getInstance().getTextureManager().register(textureId, (AbstractTexture)dynamicTexture);
            textureCache.put(cacheKey, textureId);
            return textureId;
        }
        catch (Exception e) {
            throw new RuntimeException("Failed to build GUI texture: " + cacheKey + ". Make sure the base textures exist and client is ready.", e);
        }
    }

    private NativeImage createCompositeTexture() throws IOException {
        NativeImage baseImage = this.loadBaseTexture();
        NativeImage slotTexture = this.loadDefaultSlotTexture();
        for (SlotData slot : this.slots) {
            NativeImage currentSlotTexture = slot.customTexture != null ? this.loadTexture(slot.customTexture) : slotTexture;
            this.blitImage(baseImage, currentSlotTexture, slot.x, slot.y);
        }
        return baseImage;
    }

    private NativeImage loadBaseTexture() throws IOException {
        ResourceLocation baseLocation = ResourceLocation.fromNamespaceAndPath((String)"baguettelib", (String)"textures/gui/empty_gui.png");
        try {
            return this.loadTexture(baseLocation);
        }
        catch (Exception e) {
            throw new IOException("Failed to load base GUI texture. Make sure 'assets/baguettelib/textures/gui/empty_gui.png' exists in your resources.", e);
        }
    }

    private NativeImage loadDefaultSlotTexture() throws IOException {
        ResourceLocation slotLocation = ResourceLocation.fromNamespaceAndPath((String)"baguettelib", (String)"textures/gui/slot.png");
        try {
            return this.loadTexture(slotLocation);
        }
        catch (Exception e) {
            throw new IOException("Failed to load slot texture. Make sure 'assets/baguettelib/textures/gui/slot.png' exists in your resources.", e);
        }
    }

    private NativeImage loadTexture(ResourceLocation location) throws IOException {
        ResourceManager resourceManager = Minecraft.getInstance().getResourceManager();
        try (InputStream stream = ((Resource)resourceManager.getResource(location).orElseThrow()).open();){
            NativeImage nativeImage = NativeImage.read((InputStream)stream);
            return nativeImage;
        }
    }

    private void blitImage(NativeImage dest, NativeImage src, int destX, int destY) {
        int srcWidth = src.getWidth();
        int srcHeight = src.getHeight();
        int destWidth = dest.getWidth();
        int destHeight = dest.getHeight();
        for (int x = 0; x < srcWidth && destX + x < destWidth; ++x) {
            for (int y = 0; y < srcHeight && destY + y < destHeight; ++y) {
                int pixel;
                int alpha;
                if (destX + x < 0 || destY + y < 0 || (alpha = (pixel = src.getPixelRGBA(x, y)) >> 24 & 0xFF) <= 0) continue;
                dest.setPixelRGBA(destX + x, destY + y, pixel);
            }
        }
    }

    private String generateSlotHash() {
        StringBuilder sb = new StringBuilder();
        for (SlotData slot : this.slots) {
            sb.append(slot.x).append(",").append(slot.y).append(",").append(slot.customTexture != null ? slot.customTexture.toString() : "default").append(";");
        }
        return Integer.toHexString(sb.toString().hashCode());
    }

    private static boolean isClientReady() {
        try {
            Minecraft minecraft = Minecraft.getInstance();
            return minecraft != null && minecraft.getResourceManager() != null;
        }
        catch (Exception e) {
            return false;
        }
    }

    public ResourceLocation buildAndCacheWhenReady() {
        if (ScreenTextureBuilder.isClientReady()) {
            return this.buildAndCache();
        }
        return null;
    }

    public boolean canBuild() {
        return ScreenTextureBuilder.isClientReady();
    }

    public static void clearCache() {
        textureCache.clear();
    }

    private static class SlotData {
        final int x;
        final int y;
        final ResourceLocation customTexture;

        SlotData(int x, int y, ResourceLocation customTexture) {
            this.x = x;
            this.y = y;
            this.customTexture = customTexture;
        }
    }

    @FunctionalInterface
    public static interface SlotPattern {
        public void apply(ScreenTextureBuilder var1);
    }

    @FunctionalInterface
    public static interface SlotPositionFunction {
        public int[] getPosition(int var1);
    }
}

