/*
 * Decompiled with CFR 0.152.
 */
package net.blay09.mods.balm.world.entity.internal;

import java.util.function.Function;
import java.util.function.Supplier;
import net.blay09.mods.balm.core.BalmRegistrar;
import net.blay09.mods.balm.world.entity.BalmEntityTypeRegistrar;
import net.blay09.mods.balm.world.entity.BalmEntityTypeRegistration;
import net.minecraft.core.Holder;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;

public abstract class AbstractBalmEntityTypeRegistrarImpl
implements BalmEntityTypeRegistrar {
    private final BalmRegistrar registrar;
    private final String namespace;

    protected AbstractBalmEntityTypeRegistrarImpl(BalmRegistrar registrar, String namespace) {
        this.registrar = registrar;
        this.namespace = namespace;
    }

    protected abstract <T extends Entity> void registerDefaultAttributes(Holder<EntityType<T>> var1, Supplier<AttributeSupplier.Builder> var2);

    @Override
    public <T extends Entity> BalmEntityTypeRegistration<T> register(String name, Supplier<EntityType.Builder<T>> builder) {
        ResourceLocation identifier = ResourceLocation.fromNamespaceAndPath((String)this.namespace, (String)name);
        ResourceKey resourceKey = ResourceKey.create((ResourceKey)Registries.ENTITY_TYPE, (ResourceLocation)identifier);
        Holder<EntityType> holder = this.registrar.register(resourceKey, (ResourceLocation id) -> ((EntityType.Builder)builder.get()).build(resourceKey.location().toString()));
        return new BalmEntityTypeRegistrationImpl(holder);
    }

    private class BalmEntityTypeRegistrationImpl<T extends Entity>
    implements BalmEntityTypeRegistration<T> {
        private final Holder<EntityType<T>> holder;

        private BalmEntityTypeRegistrationImpl(Holder<?> holder) {
            this.holder = holder;
        }

        @Override
        public Holder<EntityType<T>> asHolder() {
            return this.holder;
        }

        @Override
        public BalmEntityTypeRegistration<T> withDefaultAttributes(Supplier<AttributeSupplier.Builder> attributesFunction) {
            AbstractBalmEntityTypeRegistrarImpl.this.registerDefaultAttributes(this.holder, attributesFunction);
            return this;
        }

        @Override
        public BalmEntityTypeRegistration<T> withDefaultAttributes(Function<AttributeSupplier.Builder, AttributeSupplier.Builder> attributesFunction) {
            AbstractBalmEntityTypeRegistrarImpl.this.registerDefaultAttributes(this.holder, () -> (AttributeSupplier.Builder)attributesFunction.apply(AttributeSupplier.builder()));
            return this;
        }
    }
}

